/**
 * © 2008 by Andreas Kielkopf Diese Datei wurde für den c't creativ08 Wettbewerb programmiert, und
 * darf von jedem frei verwendet werden
 */
package de.uhingen.kielkopf.andreas;

import java.io.IOException;
import java.lang.reflect.Array;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JTextField;
import org.omg.CORBA.TIMEOUT;
import sun.reflect.ReflectionFactory.GetReflectionFactoryAction;
import de.uhingen.kielkopf.andreas.modell.Drawable;
import de.uhingen.kielkopf.andreas.modell.FlugKoerper;

/**
 * @author andreas
 * 
 * Öffnet einen Datagramm-Socket um Daten von MAME zu empfangen, empfängt diese,und stellt sie
 * anderen Programmteilen zur Verfügung
 */
public class UdpHandler extends Thread {
    static public enum Taste {
        HYPERSPACE(0), FEUER(1), SCHUB(2), RECHTS(3), LINKS(4), BIT5(5), BIT6(6), BIT7(7);
        final public byte maske;

        /** Maske ermitteln */
        Taste(final int shift) {
            maske = (byte) (1 << shift);
        }
        final public static byte getMaske(Taste... tasten) {
            byte b = Taste.BIT6.maske;
            for (Taste taste : tasten) {
                b |= taste.maske;
            }
            return b;
        }
    }

    final private int         MAMEPORT         = 1979;
    private InetSocketAddress inetSocketAdress = null;

    /**
     * @param ip
     *            Hostname oder ip als String
     */
    private UdpHandler(final String host) {
        super();
        inetSocketAdress = new InetSocketAddress((host == null) ? "127.0.0.1" : host, MAMEPORT);
    }

    private static UdpHandler analyzer = null;

    /**
     * wir erzeugen nur einen Analyser. Mit dem darf sich jeder verbinden
     */
    public static synchronized UdpHandler getHandler(final String host) {
        if (analyzer == null) {
            analyzer = new UdpHandler(host);
            analyzer.setName("UdpHandler");
            analyzer.start();
        }
        return analyzer;
    }
    /**
     * @return den vorhandenen analyser, oder null
     */
    public static synchronized UdpHandler getHandler() {
        return analyzer;
    }
    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Thread#run()
     */
    @Override
    public void run() {
        do {
            connect();
            try {
                do {
                    byte[] packet = recievePacket();
                    UdpInterpreter.analysePacket(packet, Math.min(Math.abs(packetTime.get() - lastPacketTime.get()),
                            100));
                } while (true);
            } catch (final SocketException e) {
                e.printStackTrace();
            } catch (final SocketTimeoutException e) {
                System.out.print(".");
                e.printStackTrace();
            } catch (final IOException e) {
                e.printStackTrace();
            }
        } while (true);
    }

    /* */
    final private String   CTMAME          = "ctmame..";
    final private int      UDP_PING_LEN    = 8;
    private byte           ping_out_byte   = 0;
    private DatagramPacket ping_out_packet = null;
    private byte[]         ping_out_puffer = null;

    public boolean isReady2Send() {
        return (ping_in_byte == ping_out_byte);
    }

    private long[] pingsendTimes = new long[256];
    private double pingtime      = 1d;

    /**
     * sendet ein Standardpaket mit 8 Byte
     * 
     * @throws IOException
     * @throws SocketException
     */
    public void sendPing(byte b) throws SocketException, IOException {
        int timeout = 10;
        while (!isReady2Send()) {
            try {
                sleep(1);
                timeout--;
            } catch (InterruptedException e) {}
            if (timeout <= 0) break;
        }
        if (ping_out_packet == null) {
            ping_out_puffer = CTMAME.getBytes();
            ping_out_packet = new DatagramPacket(ping_out_puffer, UDP_PING_LEN, inetSocketAdress);
        }
        ping_out_puffer[7] = ++ping_out_byte;
        ping_out_puffer[6] = b;
        getSocket().send(ping_out_packet);
        pingsendTimes[ping_out_byte + 128] = System.currentTimeMillis();
    }

    final static private String CTNAME          = "ctname  Andreas Kielkopf (Uhingen)....";
    final static private int    UDP_NAME_LEN    = 38;
    private byte[]              name_out_puffer = null;
    private DatagramPacket      name_out_packet = null;

    /**
     * sendet ein Standardpaket mit 38 Byte
     * 
     * @throws IOException
     * @throws SocketException
     */
    public void sendName() throws SocketException, IOException {
        // if (name_out_packet == null) {
        name_out_puffer = CTNAME.getBytes();
        name_out_packet = new DatagramPacket(name_out_puffer, UDP_NAME_LEN, inetSocketAdress);
        name_out_puffer[37] = 0;
        // }
        getSocket().send(name_out_packet);
        System.out.print("Name");
    }

    /** Versuche 30 x im Abstand von 1 Sekunde zu verbinden */
    final private static int CONNECT_MAX_TRYS    = 60;
    final private static int CONNECT_TRY_TIMEOUT = 1000;

    /**
     * versuche Verbindung aufzubauen
     */
    private void connect() {
        System.out.println("try:");
        for (int i = 0; i < CONNECT_MAX_TRYS; i++) {
            try {
                sendPing(Taste.BIT6.maske);
                sendName();
                recievePacket();
                sendName();
                return;
            } catch (final SocketException e) {} catch (final IOException e) {} catch (RuntimeException e) {}
            System.out.print(".");
            try {
                sleep(CONNECT_TRY_TIMEOUT);
            } catch (InterruptedException e) {}
        }
        try {
            sleep(30000);
        } catch (InterruptedException e1) {}
    }

    final static public int UDP_LEN_EMPF   = 1026;
    private DatagramPacket  packet_in      = null;
    private byte[]          puffer_in      = null;
    final private int       SO_TIMEOUT     = 200;             // Empfangstimeout
    private byte            ping_in_byte   = -1;
    private AtomicLong      packetTime     = new AtomicLong();
    private AtomicLong      lastPacketTime = new AtomicLong();

    /**
     * @param puffer
     * @throws IOException
     * @throws SocketException
     */
    private byte[] recievePacket() throws SocketException, IOException {
        if (packet_in == null) {
            puffer_in = new byte[UDP_LEN_EMPF];
            packet_in = new DatagramPacket(puffer_in, UDP_LEN_EMPF);
        }
        getSocket().receive(packet_in);
        lastPacketTime.set(packetTime.getAndSet(System.currentTimeMillis()));
        countFps(packetTime.get(), lastPacketTime.get());
        countPingtime();
        // Empfang melden
        // Kopie anfertigen
        createTransferBuffer(packetTime.get());
        return puffer_in;
    }
    /**
     * 
     */
    private void countPingtime() {
        ping_in_byte = puffer_in[1025];
        long dif = packetTime.get() - pingsendTimes[ping_in_byte + 128];
        pingtime *= 0.9d;
        pingtime += 0.1d * dif;
    }

    private final Semaphore puffer_transfer_lock = new Semaphore(1);
    private final byte[]    puffer_transfer      = new byte[UDP_LEN_EMPF];

    /**
     * @param jetzt
     */
    private void createTransferBuffer(long jetzt) {
        puffer_transfer_lock.acquireUninterruptibly();
        System.arraycopy(puffer_in, 0, puffer_transfer, 0, puffer_transfer.length);
        puffer_packet_in_time = jetzt;
        puffer_transfer_lock.release();
    }

    private long       puffer_packet_in_time;
    private int        fpsCounter;
    private int        fps;
    private JTextField fpsTextField;
    private JTextField pingTextField;

    /**
     * @param jetzige
     *            Empfangszeitpunkt
     * @param letzter
     *            Empfangszeitpunkt
     * 
     */
    private void countFps(long pTime, long lastPTime) {
        // Frames pro Sekunde zählen
        fpsCounter++;
        if ((pTime / 1000) != (lastPTime / 1000)) {
            fps = fpsCounter;
            fpsCounter = 0;
            if (fpsTextField != null) fpsTextField.setText(fps + " fps");
            if (pingTextField != null) pingTextField.setText((int) pingtime + " ms");
        }
    }
    /**
     * @param textField
     */
    public void setFPSTextfield(final JTextField textField) {
        fpsTextField = textField;
    }
    public void setPingTextfield(final JTextField textField) {
        pingTextField = textField;
    }

    private DatagramSocket datagramSocket = null;

    /**
     * @return the socket
     * @throws SocketException
     */
    private DatagramSocket getSocket() throws SocketException {
        if (datagramSocket == null) {
            final DatagramSocket s = new DatagramSocket();
            s.setReuseAddress(true);
            s.setSoTimeout(SO_TIMEOUT); // s.bind(socketAdress);
            s.connect(inetSocketAdress);
            datagramSocket = s;
        }
        return datagramSocket;
    }
    /**
     * @return
     */
    public long getUDPCopy(final byte[] udpcopy) {
        if (udpcopy.length == puffer_transfer.length) {
            if (puffer_transfer_lock.tryAcquire()) {
                System.arraycopy(puffer_transfer, 0, udpcopy, 0, puffer_transfer.length);
                puffer_transfer_lock.release();
                return puffer_packet_in_time;
            }
        }
        return 0;
    }
    /**
     * @return
     */
    public long getPacketTime() {
        return packetTime.get();
    }
}
