//
//  APSaucer.m
//  APlayer
//
//  Created by Holger Sadewasser on 4/26/08.
//  Copyright 2008. All rights reserved.
//

#import "parameter.h"
#import "APSaucer.h"
#import "tools.h"


//#define RADUIS_SAUCER_LARGE 21.6
//#define RADUIS_SAUCER_SMALL 12.0
#define RADUIS_C_SAUCER_LARGE 20.0
#define RADUIS_C_SAUCER_SMALL 8.0
#define RADUIS_SAUCER_LARGE 12.0
#define RADUIS_SAUCER_SMALL 6.0



// methods that are used internally by this class, but should not be needed externally
// are defined here to keep them "private". Anyone who knows about them can still call
// them of course, but by putting the prototypes here, it emphasizes that they are only
// meant for internal use.
@interface APSaucer(_private_methods)


@end


@implementation APSaucer

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

- (id) init {
  self = [super initWithType:cSaucer];
  return self;
}


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Redefined Instance Methods
// -------------------------------------------------------------------------------------

-(void)updateWithPosX:(int)iPosX posY:(int)iPosY frames:(uint8_t)iFrames {
  
  double distX, distY;
  double divX, divY;

  // If we have recoreded at least 2 frames of the saucer...
  if ( mTotalFrames > 1 ) {
    
    distX = distXdouble( mPosX, (double)iPosX );
    distY = distYdouble( mPosY, (double)iPosY );      
    
    divX = fabs(distX - mHeadingX);
    divY = fabs(distY - mHeadingY);
    
    // ... check if it has changed its heading
//    if ( divX*divX + divY*divY > TRACKING_HEADING_DIV ) {
    if ( divX > SAUCER_HEADING_DIV || divY > SAUCER_HEADING_DIV ) {
//      NSLog(@"saucer changed direction");
      
      mInitFrame = mTotalFrames;
      mInitPosX = mPosX;
      mInitPosY = mPosY;
      mDeltaX[0] = floor(mPosX);
      mDeltaY[0] = floor(mPosY);
      mFlgCalcHeading = YES;
      mTimeToLive = -1;
      mFlgTargeted = NO;
            
      mTempPosX = mInitPosX;
      mTempPosY = mInitPosY;
//      mInitFrame = 1;
      mTempFrame = mInitFrame;
//      mTotalFrames = mInitFrame;
    }      
  }
  
  // Update the position, the heading and the number of frames
  [super updateWithPosX:iPosX posY:iPosY frames:iFrames];

//  if ( iPosX != 0 || iPosY != 0 )
//    NSLog(@"Saucer size: %d x: %lf y: %lf hx: %lf hy: %lf f:%d\n", mSize, mPosX, mPosY, mHeadingX, mHeadingY, mTotalFrames);
}


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(void)setSize:(int)iSize posX:(int)iPosX posY:(int)iPosY {

  mSize = iSize;
  mInitPosX = iPosX;
  mInitPosY = iPosY;
  mInitFrame = 1;
  mTempPosX = mInitPosX;
  mTempPosY = mInitPosY;
  mDeltaX[0] = iPosX;
  mDeltaY[0] = iPosY;
  mFlgCalcHeading = YES;
  
  switch ( mSize ) {
    case 15:
      mRadius = RADUIS_SAUCER_LARGE;
      mRadiusC = RADUIS_C_SAUCER_LARGE;
      break;
    case 14:
      mRadius = RADUIS_SAUCER_SMALL;
      mRadiusC = RADUIS_C_SAUCER_SMALL;
      break;
  }
  mRadius2 = mRadius*mRadius;
  mRadiusC2 = mRadiusC*mRadiusC;
  mNumberOfShots = 1;

  // Before calling this method mSize must have been set.
  [super _setPosX:iPosX posY:iPosY];
 
//  NSLog(@"New saucer size: %d x: %lf y: %lf\n", mSize, mPosX, mPosY);
}


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Private Methods
// -------------------------------------------------------------------------------------


@end
