/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Communication;
import de.caff.asteroid.GeorgsFirstAsteroidPlayer;
import de.caff.asteroid.SpaceShip;
import junit.framework.TestCase;

public class GeorgsFirstAsteroidPlayerTest
extends TestCase {
    GeorgsFirstAsteroidPlayer player;

    public void setUp() throws Exception {
        super.setUp();
        Communication com = new Communication();
        this.player = new GeorgsFirstAsteroidPlayer(com);
    }

    public void testObjectsCollidingInFrames() {
        SpaceShip ship = new SpaceShip(100, 100, 5, 5);
        Asteroid asteroid = new Asteroid(200, 100, 0, 0);
        ship.setVelocity(5, 5);
        asteroid.setVelocity(-5, 5);
        int timeToCollision = this.player.objectsCollidingInFrames(ship, asteroid);
        GeorgsFirstAsteroidPlayerTest.assertEquals((int)7, (int)timeToCollision);
        ship.setVelocity(0, 0);
        asteroid.setVelocity(-5, 5);
        timeToCollision = this.player.objectsCollidingInFrames(ship, asteroid);
        GeorgsFirstAsteroidPlayerTest.assertEquals((int)-1, (int)timeToCollision);
        Asteroid asteroid2 = new Asteroid(101, 50, 0, 0);
        ship.setVelocity(0, 5);
        asteroid2.setVelocity(0, 5);
        timeToCollision = this.player.objectsCollidingInFrames(ship, asteroid2);
        GeorgsFirstAsteroidPlayerTest.assertEquals((int)-1, (int)timeToCollision);
        asteroid2.setVelocity(0, 6);
        timeToCollision = this.player.objectsCollidingInFrames(ship, asteroid2);
        GeorgsFirstAsteroidPlayerTest.assertEquals((int)53, (int)timeToCollision);
    }

    public void testCollisionDetection() {
        Asteroid ast = new Asteroid(323, 275, 8, 0);
        ast.setVelocity(3, -1);
    }
}

