/*
 * Decompiled with CFR 0.152.
 */
package se.jupp.asteroids;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.LinkedList;
import java.util.List;
import se.jupp.asteroids.Frame;
import se.jupp.asteroids.FrameListener;

public class Communication {
    private static final int MAME_PORT = 1979;
    private static final byte[] KEY_FRAME;
    private DatagramChannel channel;
    private InetSocketAddress mameAddr;
    ByteBuffer keyBuffer = ByteBuffer.allocate(KEY_FRAME.length);
    private List<FrameListener> frameListeners = new LinkedList<FrameListener>();

    static {
        byte[] byArray = new byte[8];
        byArray[0] = 99;
        byArray[1] = 116;
        byArray[2] = 109;
        byArray[3] = 97;
        byArray[4] = 109;
        byArray[5] = 101;
        KEY_FRAME = byArray;
    }

    public Communication(String hostname) throws IOException {
        int port = 1979;
        String[] parts = hostname.split(":");
        if (parts.length == 2) {
            try {
                port = Integer.parseInt(parts[1]);
                hostname = parts[0];
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.keyBuffer.put(KEY_FRAME);
        this.mameAddr = new InetSocketAddress(hostname, port);
        this.channel = DatagramChannel.open();
        this.channel.connect(this.mameAddr);
        Thread comThread = new Thread(new Runnable(){

            public void run() {
                Communication.this.loop();
            }
        }, "Communication");
        comThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loop() {
        boolean first = true;
        while (true) {
            try {
                this.sendKeys(0, 0);
                ByteBuffer buffer = ByteBuffer.allocate(1026);
                while (true) {
                    buffer.clear();
                    SocketAddress adr = this.channel.receive(buffer);
                    if (adr == null) {
                        System.out.println("adr=" + adr);
                    } else if (first) {
                        System.out.println("Got first datagram from " + adr);
                    }
                    first = false;
                    buffer.flip();
                    Frame f = null;
                    if (buffer.remaining() == 11) {
                        System.out.println("Got game over packet");
                    } else if (buffer.remaining() == 1026) {
                        f = new Frame(buffer);
                    } else {
                        System.out.println("Datagram size = " + buffer.remaining());
                        continue;
                    }
                    List<FrameListener> list = this.frameListeners;
                    synchronized (list) {
                        for (FrameListener l : this.frameListeners) {
                            l.frameReceived(f);
                        }
                    }
                    if (f == null) break;
                }
                return;
            }
            catch (PortUnreachableException e) {
                if (!first) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void sendKeys(int keys, int pingid) throws IOException {
        this.keyBuffer.put(6, (byte)keys);
        this.keyBuffer.put(7, (byte)pingid);
        this.keyBuffer.flip();
        this.channel.write(this.keyBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrameListener(FrameListener listener) {
        List<FrameListener> list = this.frameListeners;
        synchronized (list) {
            this.frameListeners.add(listener);
        }
    }
}

