/*
 * Decompiled with CFR 0.152.
 */
package se.jupp.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import se.jupp.asteroids.Bullet;
import se.jupp.asteroids.Frame;
import se.jupp.asteroids.Game;
import se.jupp.asteroids.GameObject;
import se.jupp.asteroids.Position;

public class Ship
extends GameObject
implements Cloneable {
    private static final Color COLOR = new Color(192, 192, 192);
    private static final GeneralPath SHIP_SHAPE = new GeneralPath();
    int turns = 0;
    static final Position[] turrets;
    static final Position[] directions;
    Position direction;
    List<Position> history = new ArrayList<Position>(8);
    List<Integer> turnHistory = new ArrayList<Integer>(11);
    boolean left;
    boolean right;
    boolean thrust;
    boolean fire;
    boolean hyper;
    int lastFire = 0;
    Queue<Game.Hit> hits = new LinkedList<Game.Hit>();
    LinkedList<Bullet> bullets = new LinkedList();

    static {
        SHIP_SHAPE.moveTo(16.0f, 0.0f);
        SHIP_SHAPE.lineTo(-16.0f, 8.0f);
        SHIP_SHAPE.lineTo(-8.0f, 0.0f);
        SHIP_SHAPE.lineTo(-16.0f, -8.0f);
        SHIP_SHAPE.closePath();
        turrets = new Position[]{new Position(152, 0, true), new Position(152, 8, true), new Position(152, 16, true), new Position(152, 32, true), new Position(152, 40, true), new Position(144, 56, true), new Position(136, 64, true), new Position(136, 72, true), new Position(128, 80, true), new Position(120, 96, true), new Position(112, 104, true), new Position(104, 112, true), new Position(96, 120, true), new Position(88, 128, true), new Position(80, 128, true), new Position(64, 136, true), new Position(56, 144, true), new Position(48, 144, true), new Position(32, 152, true), new Position(24, 152, true), new Position(8, 152, true), new Position(0, 152, true), new Position(-8, 152, true), new Position(-24, 152, true), new Position(-40, 152, true), new Position(-48, 152, true), new Position(-56, 144, true), new Position(-72, 144, true), new Position(-80, 136, true), new Position(-88, 128, true), new Position(-96, 120, true), new Position(-112, 120, true), new Position(-120, 112, true), new Position(-120, 96, true), new Position(-128, 88, true), new Position(-136, 80, true), new Position(-144, 72, true), new Position(-152, 56, true), new Position(-152, 48, true), new Position(-160, 40, true), new Position(-160, 24, true), new Position(-160, 16, true), new Position(-160, 0, true), new Position(-160, -8, true), new Position(-160, -16, true), new Position(-160, -32, true), new Position(-160, -40, true), new Position(-160, -56, true), new Position(-152, -64, true), new Position(-144, -80, true), new Position(-144, -88, true), new Position(-136, -96, true), new Position(-128, -104, true), new Position(-120, -112, true), new Position(-112, -120, true), new Position(-104, -128, true), new Position(-96, -136, true), new Position(-80, -144, true), new Position(-72, -152, true), new Position(-64, -152, true), new Position(-48, -160, true), new Position(-40, -160, true), new Position(-32, -160, true), new Position(-16, -160, true), new Position(0, -160, true), new Position(8, -160, true), new Position(16, -160, true), new Position(32, -160, true), new Position(40, -160, true), new Position(56, -152, true), new Position(64, -152, true), new Position(72, -144, true), new Position(80, -136, true), new Position(96, -128, true), new Position(104, -120, true), new Position(112, -112, true), new Position(120, -104, true), new Position(128, -96, true), new Position(128, -88, true), new Position(136, -80, true), new Position(144, -64, true), new Position(144, -56, true), new Position(152, -40, true), new Position(152, -32, true), new Position(152, -16, true), new Position(152, -8, true), new Position(152, 0, true), new Position(152, 16, true), new Position(152, 24, true), new Position(152, 40, true), new Position(144, 48, true), new Position(144, 56, true), new Position(136, 72, true), new Position(128, 80, true), new Position(120, 88, true), new Position(120, 96, true), new Position(112, 112, true), new Position(96, 120, true), new Position(88, 120, true), new Position(80, 128, true), new Position(72, 136, true), new Position(56, 144, true), new Position(48, 144, true), new Position(40, 152, true), new Position(24, 152, true), new Position(16, 152, true), new Position(0, 152, true), new Position(-8, 152, true), new Position(-16, 152, true), new Position(-32, 152, true), new Position(-40, 152, true), new Position(-56, 144, true), new Position(-64, 144, true), new Position(-80, 136, true), new Position(-88, 128, true), new Position(-96, 128, true), new Position(-104, 120, true), new Position(-112, 112, true), new Position(-120, 104, true), new Position(-128, 96, true), new Position(-136, 80, true), new Position(-144, 72, true), new Position(-152, 64, true), new Position(-152, 56, true), new Position(-160, 40, true), new Position(-160, 32, true), new Position(-160, 16, true), new Position(-160, 8, true), new Position(-160, 0, true), new Position(-160, -16, true), new Position(-160, -32, true), new Position(-160, -40, true), new Position(-160, -48, true), new Position(-152, -64, true), new Position(-152, -72, true), new Position(-144, -80, true), new Position(-136, -96, true), new Position(-128, -104, true), new Position(-120, -112, true), new Position(-112, -120, true), new Position(-104, -128, true), new Position(-96, -136, true), new Position(-88, -144, true), new Position(-80, -144, true), new Position(-64, -152, true), new Position(-56, -160, true), new Position(-40, -160, true), new Position(-32, -160, true), new Position(-16, -160, true), new Position(-8, -160, true), new Position(0, -160, true), new Position(16, -160, true), new Position(24, -160, true), new Position(40, -160, true), new Position(48, -152, true), new Position(56, -152, true), new Position(72, -144, true), new Position(80, -136, true), new Position(88, -128, true), new Position(96, -120, true), new Position(112, -120, true), new Position(120, -112, true), new Position(120, -96, true), new Position(128, -88, true), new Position(136, -80, true), new Position(144, -72, true), new Position(144, -56, true), new Position(152, -48, true), new Position(152, -40, true), new Position(152, -24, true), new Position(152, -8, true), new Position(152, 0, true), new Position(152, 8, true), new Position(152, 24, true), new Position(152, 32, true), new Position(144, 48, true), new Position(144, 56, true), new Position(136, 64, true), new Position(128, 80, true), new Position(128, 88, true), new Position(120, 96, true), new Position(112, 104, true), new Position(104, 112, true), new Position(96, 120, true), new Position(80, 128, true), new Position(72, 136, true), new Position(64, 136, true), new Position(56, 144, true), new Position(40, 152, true), new Position(32, 152, true), new Position(16, 152, true), new Position(8, 152, true), new Position(0, 152, true), new Position(-16, 152, true), new Position(-32, 152, true), new Position(-40, 152, true), new Position(-48, 152, true), new Position(-64, 144, true), new Position(-72, 136, true), new Position(-80, 136, true), new Position(-96, 128, true), new Position(-104, 120, true), new Position(-112, 112, true), new Position(-120, 104, true), new Position(-128, 96, true), new Position(-136, 88, true), new Position(-144, 80, true), new Position(-144, 64, true), new Position(-152, 56, true), new Position(-160, 48, true), new Position(-160, 32, true), new Position(-160, 24, true), new Position(-160, 8, true), new Position(-160, 0, true), new Position(-160, -8, true), new Position(-160, -24, true), new Position(-160, -40, true), new Position(-160, -48, true), new Position(-152, -56, true), new Position(-152, -72, true), new Position(-144, -80, true), new Position(-136, -88, true), new Position(-128, -96, true), new Position(-120, -112, true), new Position(-120, -120, true), new Position(-112, -120, true), new Position(-96, -128, true), new Position(-88, -136, true), new Position(-80, -144, true), new Position(-72, -152, true), new Position(-56, -152, true), new Position(-48, -160, true), new Position(-40, -160, true), new Position(-24, -160, true), new Position(-8, -160, true), new Position(0, -160, true), new Position(8, -160, true), new Position(24, -160, true), new Position(32, -160, true), new Position(48, -160, true), new Position(56, -152, true), new Position(64, -144, true), new Position(80, -144, true), new Position(88, -136, true), new Position(96, -128, true), new Position(104, -120, true), new Position(112, -112, true), new Position(120, -104, true), new Position(128, -96, true), new Position(136, -80, true), new Position(136, -72, true), new Position(144, -64, true), new Position(152, -48, true), new Position(152, -40, true), new Position(152, -32, true), new Position(152, -16, true)};
        directions = new Position[]{new Position(63, 0, true), new Position(63, 4, true), new Position(63, 9, true), new Position(62, 14, true), new Position(61, 18, true), new Position(59, 23, true), new Position(57, 27, true), new Position(55, 31, true), new Position(53, 35, true), new Position(50, 39, true), new Position(47, 42, true), new Position(44, 46, true), new Position(40, 49, true), new Position(36, 52, true), new Position(32, 54, true), new Position(28, 56, true), new Position(24, 58, true), new Position(20, 60, true), new Position(15, 61, true), new Position(11, 62, true), new Position(6, 63, true), new Position(1, 63, true), new Position(-3, 63, true), new Position(-8, 63, true), new Position(-13, 62, true), new Position(-17, 61, true), new Position(-22, 60, true), new Position(-26, 58, true), new Position(-30, 56, true), new Position(-34, 53, true), new Position(-38, 51, true), new Position(-42, 48, true), new Position(-45, 45, true), new Position(-48, 41, true), new Position(-51, 38, true), new Position(-54, 34, true), new Position(-56, 30, true), new Position(-58, 25, true), new Position(-60, 21, true), new Position(-61, 17, true), new Position(-63, 12, true), new Position(-63, 8, true), new Position(-64, 3, true), new Position(-64, -2, true), new Position(-63, -6, true), new Position(-63, -11, true), new Position(-62, -16, true), new Position(-61, -20, true), new Position(-59, -25, true), new Position(-57, -29, true), new Position(-55, -33, true), new Position(-52, -37, true), new Position(-49, -41, true), new Position(-46, -44, true), new Position(-43, -47, true), new Position(-39, -50, true), new Position(-36, -53, true), new Position(-32, -56, true), new Position(-27, -58, true), new Position(-23, -59, true), new Position(-19, -61, true), new Position(-14, -62, true), new Position(-10, -63, true), new Position(-5, -64, true), new Position(0, -64, true), new Position(4, -64, true), new Position(9, -63, true), new Position(14, -62, true), new Position(18, -61, true), new Position(23, -59, true), new Position(27, -58, true), new Position(31, -56, true), new Position(35, -53, true), new Position(39, -50, true), new Position(42, -47, true), new Position(46, -44, true), new Position(49, -41, true), new Position(52, -37, true), new Position(54, -33, true), new Position(56, -29, true), new Position(58, -25, true), new Position(60, -20, true), new Position(61, -16, true), new Position(62, -11, true), new Position(63, -6, true), new Position(63, -2, true), new Position(63, 3, true), new Position(63, 8, true), new Position(62, 12, true), new Position(61, 17, true), new Position(60, 21, true), new Position(58, 25, true), new Position(56, 30, true), new Position(53, 34, true), new Position(51, 38, true), new Position(48, 41, true), new Position(45, 45, true), new Position(41, 48, true), new Position(38, 51, true), new Position(34, 53, true), new Position(30, 56, true), new Position(25, 58, true), new Position(21, 60, true), new Position(17, 61, true), new Position(12, 62, true), new Position(8, 63, true), new Position(3, 63, true), new Position(-2, 63, true), new Position(-6, 63, true), new Position(-11, 62, true), new Position(-16, 61, true), new Position(-20, 60, true), new Position(-25, 58, true), new Position(-29, 56, true), new Position(-33, 54, true), new Position(-37, 52, true), new Position(-41, 49, true), new Position(-44, 46, true), new Position(-47, 42, true), new Position(-50, 39, true), new Position(-53, 35, true), new Position(-56, 31, true), new Position(-58, 27, true), new Position(-59, 23, true), new Position(-61, 18, true), new Position(-62, 14, true), new Position(-63, 9, true), new Position(-64, 4, true), new Position(-64, 0, true), new Position(-64, -5, true), new Position(-63, -10, true), new Position(-62, -14, true), new Position(-61, -19, true), new Position(-59, -23, true), new Position(-58, -27, true), new Position(-56, -32, true), new Position(-53, -36, true), new Position(-50, -39, true), new Position(-47, -43, true), new Position(-44, -46, true), new Position(-41, -49, true), new Position(-37, -52, true), new Position(-33, -55, true), new Position(-29, -57, true), new Position(-25, -59, true), new Position(-20, -61, true), new Position(-16, -62, true), new Position(-11, -63, true), new Position(-6, -63, true), new Position(-2, -64, true), new Position(3, -64, true), new Position(8, -63, true), new Position(12, -63, true), new Position(17, -61, true), new Position(21, -60, true), new Position(25, -58, true), new Position(30, -56, true), new Position(34, -54, true), new Position(38, -51, true), new Position(41, -48, true), new Position(45, -45, true), new Position(48, -42, true), new Position(51, -38, true), new Position(52, -34, true), new Position(56, -30, true), new Position(58, -26, true), new Position(60, -22, true), new Position(61, -17, true), new Position(62, -13, true), new Position(63, -8, true), new Position(63, -3, true), new Position(63, 1, true), new Position(63, 6, true), new Position(62, 11, true), new Position(61, 15, true), new Position(60, 20, true), new Position(58, 24, true), new Position(56, 28, true), new Position(54, 32, true), new Position(52, 36, true), new Position(49, 40, true), new Position(46, 44, true), new Position(42, 47, true), new Position(39, 50, true), new Position(35, 53, true), new Position(31, 55, true), new Position(27, 57, true), new Position(23, 59, true), new Position(18, 61, true), new Position(14, 62, true), new Position(9, 63, true), new Position(4, 63, true), new Position(0, 63, true), new Position(-5, 63, true), new Position(-10, 63, true), new Position(-14, 62, true), new Position(-19, 61, true), new Position(-23, 59, true), new Position(-27, 57, true), new Position(-32, 55, true), new Position(-36, 53, true), new Position(-39, 50, true), new Position(-43, 47, true), new Position(-46, 44, true), new Position(-49, 40, true), new Position(-52, 36, true), new Position(-55, 32, true), new Position(-57, 28, true), new Position(-59, 24, true), new Position(-61, 20, true), new Position(-62, 15, true), new Position(-63, 11, true), new Position(-63, 6, true), new Position(-64, 1, true), new Position(-64, -3, true), new Position(-63, -8, true), new Position(-63, -13, true), new Position(-61, -17, true), new Position(-60, -22, true), new Position(-58, -26, true), new Position(-56, -30, true), new Position(-54, -34, true), new Position(-51, -38, true), new Position(-48, -42, true), new Position(-45, -45, true), new Position(-42, -48, true), new Position(-38, -51, true), new Position(-34, -54, true), new Position(-30, -56, true), new Position(-26, -58, true), new Position(-22, -60, true), new Position(-17, -61, true), new Position(-13, -63, true), new Position(-8, -63, true), new Position(-3, -64, true), new Position(1, -64, true), new Position(6, -63, true), new Position(11, -63, true), new Position(15, -62, true), new Position(20, -61, true), new Position(24, -59, true), new Position(28, -57, true), new Position(32, -55, true), new Position(36, -52, true), new Position(40, -49, true), new Position(44, -46, true), new Position(47, -43, true), new Position(50, -39, true), new Position(53, -36, true), new Position(55, -32, true), new Position(57, -27, true), new Position(59, -23, true), new Position(61, -19, true), new Position(62, -14, true), new Position(63, -10, true), new Position(63, -5, true)};
    }

    public Ship() {
        super(null, 0, 0);
    }

    protected Object clone() throws CloneNotSupportedException {
        Ship c = (Ship)super.clone();
        return c;
    }

    public Ship(Frame.SpaceShipPos pos, int timeBorn) {
        super(pos, 16, timeBorn);
        this.direction = pos.direction;
        this.history.add(pos);
        this.turns = 0;
        this.turnHistory.add(this.turns);
    }

    void registerBullet(Bullet b) {
        this.bullets.add(b);
    }

    void deregisterBullet(Bullet b) {
        this.bullets.remove(b);
    }

    void calibrate(Bullet bullet) {
        int i = 0;
        while (i < directions.length) {
            if (bullet.velocity.equals(directions[i])) {
                int t = i + (this.turns - this.turnHistory.get(0)) & 0xFF;
                int td = t - this.turns & 0xFF;
                if (t == this.turns) break;
                int j = 0;
                while (j < this.turnHistory.size()) {
                    this.turnHistory.set(j, this.turnHistory.get(j) + td & 0xFF);
                    ++j;
                }
                this.turns = t;
                this.direction = directions[this.turns];
                break;
            }
            ++i;
        }
    }

    void goLeft() {
        this.left = true;
        this.right = false;
    }

    void goRight() {
        this.left = false;
        this.right = true;
    }

    void goStraight() {
        this.left = false;
        this.right = false;
    }

    void goHyper() {
        this.left = false;
        this.right = false;
        this.hyper = true;
    }

    int bulletsUnderway() {
        return this.bullets.size() + this.hits.size();
    }

    boolean canFire() {
        return this.lastFire < this.age - 1 && this.bulletsUnderway() < 4;
    }

    void fire(Game.Hit hit) {
        this.fire = true;
        this.lastFire = this.age;
        this.hits.offer(hit);
    }

    Bullet predictedBullet() {
        return new Bullet(this.turret().add(this.velocity), this.bulletSpeed(), 0);
    }

    Bullet predictedBullet(int turns) {
        return new Bullet(this.turret(turns).add(this.velocity), this.bulletSpeed(turns), 0);
    }

    int getKeys() {
        return (this.left ? 16 : 0) | (this.right ? 8 : 0) | (this.thrust ? 4 : 0) | (this.fire ? 2 : 0) | (this.hyper ? 1 : 0);
    }

    int nextTurns(int t) {
        int x = this.left ? t + 1 : (this.right ? t - 1 : t);
        return x &= 0xFF;
    }

    void update(Frame.SpaceShipPos pos) {
        super.update(pos);
        if (pos != null) {
            this.pos = pos;
            this.velocity = this.pos.subtract(this.history.get(0)).divide(this.history.size()).normalize();
            this.turns = this.nextTurns(this.turns);
            this.direction = directions[this.turns];
            if (this.turnHistory.size() >= 11) {
                this.turnHistory.remove(0);
            }
            this.turnHistory.add(this.turns);
            this.fire = false;
            this.left = false;
            this.right = false;
            this.thrust = false;
            this.hyper = false;
            if (this.history.size() >= 8) {
                this.history.remove(0);
            }
            this.history.add(pos);
            if (this.hits.size() > 0 && this.age - this.lastFire > 2) {
                this.hits.clear();
            }
        }
    }

    public int getSize() {
        return 16;
    }

    public void draw(Graphics2D g) {
        g.setColor(COLOR);
        AffineTransform at = AffineTransform.getTranslateInstance(this.pos.x(), this.pos.y());
        at.concatenate(AffineTransform.getRotateInstance(this.direction.getAngle()));
        g.fill(at.createTransformedShape(SHIP_SHAPE));
        this.drawVelocityVector(g);
    }

    Position turret() {
        return this.pos.add(turrets[this.turns]);
    }

    Position turret(int turns) {
        return this.pos.add(turrets[turns & 0xFF]);
    }

    Position bulletSpeed() {
        return directions[this.turns].add(this.velocity);
    }

    Position bulletSpeed(int turns) {
        return directions[turns & 0xFF].add(this.velocity);
    }

    public String toString() {
        return "Ship@" + this.pos + " direction " + this.direction + " velocity " + this.velocity + " age " + this.age;
    }
}

