package gui;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import util.Statistics;

public class StatisticsTable extends JPanel {

	private static final long serialVersionUID = 1L;
	
	
	private JTable stats;
	private DefaultTableColumnModel columnModel;
	private StatisticsTableModel tableModel;
	
	
	public StatisticsTable() {
		initModels();

		stats = new JTable(tableModel, columnModel);
		stats.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		stats.setShowGrid(false);

		setPreferredSize(new Dimension(250, 500));
		setLayout(new BorderLayout());
		setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Aktuelle Statistik"));
		BGScrollPane sp = new BGScrollPane(stats);
		add(BorderLayout.CENTER, sp);
		
		updateTable();
	}


	private void initModels() {
		columnModel = new DefaultTableColumnModel();
		
		TableColumn nameCol = new TableColumn(0, 180);
		nameCol.setHeaderValue("Name");
		columnModel.addColumn(nameCol);
		
		TableColumn durCol = new TableColumn(1, 70);
		durCol.setHeaderValue("Wert");
		columnModel.addColumn(durCol);
		

		tableModel = new StatisticsTableModel(columnModel.getColumnCount());
	}
	
	
	public void updateTable() {
		int index = 0;

		tableModel.setRowCount(Statistics.stats.length);

		setRow(index++, Statistics.KEY_GAME_MODE);
		setRow(index++, Statistics.KEY_TIME);
		setRow(index++, Statistics.KEY_SCORE);
		setRow(index++, Statistics.KEY_SCORE_PER_MIN);
		setRow(index++, Statistics.KEY_WAVE);
		setRow(index++, Statistics.KEY_LIFES);
		setRow(index++, Statistics.KEY_DEATHS);
		setRow(index++, Statistics.KEY_HYPERJUMPS);
		setRow(index++, Statistics.KEY_KILLS);
		setRow(index++, Statistics.KEY_SHOTS);
		setRow(index++, Statistics.KEY_ALIVE_SHOTS);
		setRow(index++, Statistics.KEY_ASTEROIDS);
		setRow(index++, Statistics.KEY_HIT_RATE);
		setRow(index++, Statistics.KEY_LATENCY);
		setRow(index++, Statistics.KEY_FPS);
		setRow(index++, Statistics.KEY_DROPPED_FRAMES);
		setRow(index++, Statistics.KEY_SYNC_LOST_CNT);
		setRow(index++, Statistics.KEY_LOST_PACKETS);
		setRow(index++, Statistics.KEY_METHOD_CNT);
		setRow(index++, Statistics.KEY_LOOP_CNT);
	}
	
	
	private void setRow(int index, int key) {
		String name = "";
		String value = Statistics.getFormattedValue(key);
		
		switch(key) {
		case Statistics.KEY_TIME:
			name = "Zeit";
			break;
		case Statistics.KEY_SCORE:
			name = "Punkte";
			break;
		case Statistics.KEY_SCORE_PER_MIN:
			name = "Punkte pro Minute";
			break;
		case Statistics.KEY_WAVE:
			name = "Wave";
			break;
		case Statistics.KEY_LIFES:
			name = "Anzahl Leben";
			break;
		case Statistics.KEY_DEATHS:
			name = "Anzahl Tode";
			break;
		case Statistics.KEY_HYPERJUMPS:
			name = "Anzahl Sprnge";
			break;
		case Statistics.KEY_KILLS:
			name = "Anzahl Treffer";
			break;
		case Statistics.KEY_SHOTS:
			name = "Anzahl Schsse (gesamt)";
			break;
		case Statistics.KEY_ALIVE_SHOTS:
			name = "Anzahl Schsse (momentan)";
			break;
		case Statistics.KEY_ASTEROIDS:
			name = "Anzahl Asteroiden";
			break;
		case Statistics.KEY_HIT_RATE:
			name = "Trefferrate";
			break;
		case Statistics.KEY_GAME_MODE:
			name = "Spiel Modus";
			break;
		case Statistics.KEY_LATENCY:
			name = "Latenz";
			break;
		case Statistics.KEY_FPS:
			name = "FPS";
			break;
		case Statistics.KEY_DROPPED_FRAMES:
			name = "bersprungene Bilder";
			break;
		case Statistics.KEY_SYNC_LOST_CNT:
			name = "Winkelsync verloren";
			break;
		case Statistics.KEY_LOST_PACKETS:
			name = "Verlorene Pakete";
			break;
		case Statistics.KEY_METHOD_CNT:
			name = "Methoden Aufrufe";
			break;
		case Statistics.KEY_LOOP_CNT:
			name = "Schleifendurchlufe";
			break;
		}
		tableModel.setValueAt(name, index, 0);
		tableModel.setValueAt(value, index, 1);
	}
}
