package core.bot;

import util.Statistics;
import util.Vector2D;
import core.asteroid.AsteroidObject;
import core.asteroid.Ship;

public class TargetSolution implements Comparable<TargetSolution> {
	
	private static int methodCnt = 0;
	private static int loopCnt = 0;
	

	public Vector2D angle;
	public AsteroidObject target;
	public int turnTicks;
	public int shotDelay;
	public int shotTime;
	public int destroyTime;
	public float hitDist;
	public int resolution;
	public boolean willHit;
	public boolean legal;
	public float score;
	
	
	public static TargetSolution getAccurateSolution(Ship ship, AsteroidObject target, int latency) {
		TargetSolution sol = getPreviewSolution(ship, target, latency);
		sol.resolution = 2;
		if(sol.legal)
			sol.update(ship, latency);
		return sol;
	}
	
	
	public static TargetSolution getPreviewSolution(Ship ship, AsteroidObject target, int latency) {
		TargetSolution sol = new TargetSolution();
		sol.target = target;
		sol.resolution = 8;
		sol.update(ship, latency);
		return sol;
	}
	
	
	protected TargetSolution() {
		// leer aber protected halt...
	}
	
	
	public void update(Ship ship, int latency) {
		int tStart = destroyTime - 1;
		
		int hitRadius = target.getHitRadius();
		legal = false;
		
		Vector2D ls = new Vector2D(ship.getLocation().x, ship.getLocation().y);
		Vector2D lt = new Vector2D(target.getLocation().x, target.getLocation().y);
		Vector2D lb = new Vector2D();
		Vector2D vt = target.getVelocity();
		Vector2D vs = ship.getVelocity();

		Vector2D s = new Vector2D();
		
		lt.x += vt.x*tStart;
		lt.y += vt.y*tStart;
		ls.x += vs.x*tStart;
		ls.y += vs.y*tStart;
		
		methodCnt++;
		
		if(tStart < 0) tStart = 0;
		for(int i=tStart; i<100; i+=resolution) {
			loopCnt++;
			
			setMinLocation(lt, ls);
			int t = i;
			
			// Schussvektor Schiff -> Ziel
			s.x = lt.x - ls.x;
			s.y = lt.y - ls.y;
			float dist = s.getLength();
			
			// Bestmglicher erreichbarer Schussvektor
			Vector2D best = Ship.getNearestAngle(s, Ship.RANGE_360);

			// bentigte Drehzeit in Frames
			int turnTime = Math.abs(Ship.getTurnTicks(best));
			// Zeit, die der Schuss unterwegs ist
			shotTime = Math.round((s.getLength()/*-20*/) / best.getLength()) + latency;
			// Position des Schusses
			lb.x = best.x * (shotTime-latency) + ls.x;
			lb.y = best.y * (shotTime-latency) + ls.y;
			// Abstand Schuss Ziel
			lb.subtract(lt);
			int distShot = Math.round(lb.getLength());
			
			// Lsung gltig?
			if(shotTime + turnTime <= t && (resolution > 2 || distShot <= hitRadius)) {
				legal = true;
				angle = best;
				turnTicks = Ship.getTurnTicks(best);
				shotDelay = t - (shotTime + turnTime);
				destroyTime = shotTime + turnTime;
				hitDist = dist;
				willHit = true;
				
				break;
			}
			
			// Position des Ziels aktualisieren
			lt.x += vt.x*resolution;
			lt.y += vt.y*resolution;
			// Position des Schiffs aktualisieren
			ls.x += vs.x*resolution;
			ls.y += vs.y*resolution;
			
			Statistics.putFloat(Statistics.KEY_METHOD_CNT, methodCnt);
			Statistics.putFloat(Statistics.KEY_LOOP_CNT, loopCnt);
		}
		
		if(!legal) {
			// nchstes Mal komplett neu berechnen
			//destroyTime = 0;
		}
	}
	
	
	protected void setMinLocation(Vector2D target, Vector2D ship) {
		float dMin = 10000;
		int idx = 0;
		for(int i=0; i<9; i++) {
			float xDif = target.x - ship.x;
			float yDif = target.y - ship.y;
			float d = (float)Math.sqrt(xDif*xDif + yDif*yDif);
			if(d < dMin) {
				dMin = d;
				idx = i;
			}
			
			switch(i) {
			case 0: target.x -= 1024;	break;	// links aus dem Schirm schieen
			case 1: target.y -= 768;	break;	// links unten aus dem Schirm schieen
			case 2: target.x += 1024;	break;	// unten aus dem Schirm schieen
			case 3: target.x += 1024;	break;	// rechts unten aus dem Schirm schieen
			case 4: target.y += 768;	break;	// rechts aus dem Schirm schieen
			case 5: target.y += 768;	break;	// rechts oben aus dem Schirm schieen
			case 6: target.x -= 1024;	break;	// oben aus dem Schirm schieen
			case 7: target.x -= 1024;	break;	// links oben aus dem Schirm schieen
			case 8: target.x += 1024;	target.y -= 768;	break;	// wieder normal
			}
		}
		
		switch(idx) {
		case 1: target.x -= 1024;						break;	// links aus dem Schirm schieen
		case 2: target.x -= 1024;	target.y -= 768;	break;	// links unten aus dem Schirm schieen
		case 3: 					target.y -= 768;	break;	// unten aus dem Schirm schieen
		case 4: target.x += 1024;	target.y -= 768;	break;	// rechts unten aus dem Schirm schieen
		case 5: target.x += 1024;						break;	// rechts aus dem Schirm schieen
		case 6: target.x += 1024;	target.y += 768;	break;	// rechts oben aus dem Schirm schieen
		case 7: 					target.y += 768;	break;	// oben aus dem Schirm schieen
		case 8: target.x -= 1024;	target.y += 768;	break;	// links oben aus dem Schirm schieen
		}
	}
	
	
	public String toString() {
		return String.format("Target: %s, Fire Angle: %.1f, Destroy Time: %d",
				target, angle.getDeg(), destroyTime);
	}


	@Override
	public int compareTo(TargetSolution o) {
		if(o == null)			return -1;
		
		if(legal && !o.legal)	return -1;
		if(!legal && o.legal)	return 1;
		
		if(o.score < score)		return -1;
		else					return 1;
	}
	
}
