package core.asteroid;

import gui.AsteroidScreen;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;

import core.opCodes.OpLocation;
import core.opCodes.OpVector;

public class Shot extends AsteroidObject {

	public static final int SHOT_UNKNOWN	= 0;
	public static final int SHOT_UFO		= 1;
	public static final int SHOT_SHIP		= 2;
	
	
	private int shotType = SHOT_UNKNOWN;
	private boolean collisionCalculated = false;
	

	public Shot(OpLocation location, ArrayList<OpVector> vectors) {
		super(location, vectors);
		loc.gsf = 1;
		// Ein Schuss lebt nur 70 Frames
		hitTime = 70;
	}
	
	
	/*public void updateLocation(AsteroidObject obj, int packetInc) {
		super.updateLocation(obj, packetInc);
		dieTime--;
		if(dieTime < 0) {
			// eigentlich msster jetzt tot sein
			dieTime = 0;
		}
	}*/
	
	
	public void drawObject(Graphics2D g, AsteroidScreen screen, boolean drawInfo) {
		g.setStroke(new BasicStroke(3));
		super.drawObject(g, screen, drawInfo);
		g.setStroke(new BasicStroke(1));
	}

	
	public String getObjectName() {
		return "Schuss";
	}


	public Color getDefaultColor() {
		switch(shotType) {
			case SHOT_UFO: return Color.MAGENTA;
			case SHOT_SHIP: return Color.CYAN;
			default: return Color.WHITE;
		}
	}
	
	
	public int getShotType() {
		return shotType;
	}


	public void setShotType(int shotType) {
		this.shotType = shotType;
		setColor(getDefaultColor());
	}


	public boolean isCollisionCalculated() {
		return collisionCalculated;
	}


	public void setCollisionCalculated(boolean collisionCalculated) {
		this.collisionCalculated = collisionCalculated;
	}


	public boolean hasCollision() {
		return true;
	}


	@Override
	public boolean isDestroyable() {
		return false;
	}
}
