
class ObjectsStateList
{
	std::vector<ObjectsState> ObjectsStates;
	GameState Game;
	const ShotInfoList& ShotInfos;
	int CurrentShotInfo;
public:
	ObjectsStateList(const GameState& Game, const ShotInfoList& ShotInfos)
		: Game(Game),
		  ShotInfos(ShotInfos)
	{
		CurrentShotInfo = 0;
		assert(!pObjectsStates);
		pObjectsStates = &ObjectsStates;
		Game.CreateObjectsState(-1, -1);
		pObjectsStates = 0;
	}

	void Update(int NeededTime)
	{
		assert(pObjectsStates == 0);
		pObjectsStates = &ObjectsStates;
		try
		{
			while(Game.GetTime() < NeededTime)
			{
				Game.Move(ShotInfos[CurrentShotInfo], ShotInfos[CurrentShotInfo+1]);
				if(ShotInfos[CurrentShotInfo].Time == Game.GetTime()-1)
					CurrentShotInfo++;
			}
		}
		catch(KIGameInvalidException)
		{
			pObjectsStates = 0;
			throw;
		}
		pObjectsStates = 0;
	}

	const ObjectsState& operator [](int Index) const
	{
		return ObjectsStates[Index];
	}

	size_t GetCountStates()
	{
		return ObjectsStates.size();
	}
};

void GameState::CalculateNextShot(const ShotInfoList& ShotInfos, int MinShootTime,
								std::multiset<ShotInfoList>& ShotInfosVariety) const 
{
	GameState(*this).CalculateNextShot_(ShotInfos, MinShootTime, ShotInfosVariety);
}

void GameState::CalculateNextShot_(const ShotInfoList& ShotInfos, int MinShootTime,
								std::multiset<ShotInfoList>& ShotInfosVariety)
{
	assert(ShotInfos[0].Time >= CurrentTime);


	//Wenn ein Asteroid explodiert, die neuen Asteroiden erscheinen oder das UFO
	//erscheint oder seine Richtung ndert, werden alle Objekte in ObjectsStates gespeichert
	//ObjectsStates simuliert parallel im eigenen GameRam so weit in die Zukunft, wie wir
	//die Daten in der KI brauchen.
	//So mssen wir nur einmal berechnen, wie sich die Asteroiden verhalten und knnen viele
	//Schsse simulieren, ohne stndig Move aufrufen zu mssen. V.a. die Kollisionsberechnung
	//wrde viel Zeit verschlingen, was wir so verhindern.
	ObjectsStateList ObjectsStates(*this, ShotInfos);


	int MinCollisionAtTime = MaxInt;//Der frheste Zeitpunkt, zu dem ein Asteroid abgeschossen werden kann (0=jetzt)

	int CurrentObjectsStates = 0;
	int CurrentShotInfo = 0;
	int FreeRotationTime = 0;//Wie oft wir uns gerade gedreht haben knnten (wird jeden Frame inkrementiert, wenn der Spieler nicht tot ist, Hyperspace ausfhrt...)
	int RotationWasLockedAtTime = -1;//Ob wir seit dem letzten Schuss gestorben sind
	int cShotsShot = 0;//Wie oft wir im aktuellen ObjectsState geschossen haben. Bentigen wir, da kein ObjectsStates erstellt wird, wenn geschossen wird
	for(int t = 0; t < MinCollisionAtTime; t++)
	{
		//Zu welchem Zeitpunkt schieen wir am besten? (t=0: jetzt)
		if(t)
		{
			if(ShotInfos[CurrentShotInfo].Time == CurrentTime)
			{
				ShipDirection = MaxShipDirection = ShotInfos[CurrentShotInfo].TargetDirection;
				FreeRotationTime = 0;
				RotationWasLockedAtTime = -1;
			}

			if(NumPlayers &&
				Objects[PlayerIndex].Status >= 0 &&
				InvisibleTimer == 0)
				FreeRotationTime++;//Wenn wir eine Richtungstaste drcken werden wir uns drehen
			else if(RotationWasLockedAtTime == -1)
				RotationWasLockedAtTime = CurrentTime;

			ObjectsStates.Update(CurrentTime+1);
			while(ObjectsStates[CurrentObjectsStates].ValidUntilTime == CurrentTime)
			{
				if(ValidateKIGame)
					assert(ObjectsStates[CurrentObjectsStates+1].CountExtraSlots >= ObjectsStates[CurrentObjectsStates].CountExtraSlots - cShotsShot, KIGameInvalidException());
				CurrentObjectsStates++;
				cShotsShot = 0;
			}
			assert(CurrentTime < ObjectsStates[CurrentObjectsStates].ValidUntilTime);

			byte OldShipDirection = ShipDirection;
			Move(ShotInfos[CurrentShotInfo], ShotInfos[CurrentShotInfo+1]);
			ShipDirection = MaxShipDirection = OldShipDirection;

			if(ShotInfos[CurrentShotInfo].Time == CurrentTime-1)
				CurrentShotInfo++;
		}

		if(ShotInfos[CurrentShotInfo].Time == CurrentTime)
			cShotsShot++;
		if(ValidateKIGame)
			assert(ObjectsStates[CurrentObjectsStates].CountExtraSlots - cShotsShot >= 0, KIGameInvalidException());

		if(CurrentTime < MinShootTime)
			continue;

		//Knnen wir schieen?
		if(FireHyperspaceToggle & 0x80 || InvisibleTimer)
			continue;

		//Schieen wir jetzt sowieso oder im nchsten Frame? (falls im nchsten drfen wir jetzt nicht schieen, weil wir sonst nicht im nchsten Frame schieen knnen)
		if(ShotInfos[CurrentShotInfo].Time == CurrentTime || ShotInfos[CurrentShotInfo].Time == CurrentTime+1)
			continue;

		if(ShotInfos[CurrentShotInfo].Time != MaxInt && ShotInfos[CurrentShotInfo].RotationWasLockedAtTime != -1)
			continue;

		//Ist noch ein Slot frei?
		if(ObjectsStates[CurrentObjectsStates].CountExtraSlots - cShotsShot <= 0)
			continue;

		//Ist noch ein Slot frei?
		int NewShot = PlayerShotMaxIndex;
		while(Objects[NewShot].Status)
			if(NewShot-- == PlayerShotMinIndex)
				break;
		if(NewShot == PlayerShotMinIndex-1)
		{
			if(ValidateKIGame)
				assert(0, KIGameInvalidException());//Sollte wegen oberem if eigentlich nicht passieren
			continue;//Kein Slot frei
		}

		//Je nach Abschusszeitpunkt berlebt der Schuss unterschiedlich lange
		//int CollisionAtTime = Min(ShotLifetime-4 + (3-(Timer&3)) + t, MinCollisionAtTime);

		//Gibt an, wie wir uns zu diesem Zeitpunkt gedreht haben werden knnen
		int MinDeltaDir = -FreeRotationTime * RotationSpeed;
		int MaxDeltaDir = FreeRotationTime * RotationSpeed;
		if(ShotInfos[CurrentShotInfo].Time != MaxInt)
		{
			//Dafr sorgen, dass der nchste Schuss nach diesem Schuss erreicht werden kann
			const int PossibleRotation = (ShotInfos[CurrentShotInfo].Time-CurrentTime) * RotationSpeed;
			const int NeededRot = NeededRotation(ShipDirection, ShotInfos[CurrentShotInfo].TargetDirection, ShotInfos[CurrentShotInfo].Dir);
			MinDeltaDir = Max(MinDeltaDir, NeededRot - PossibleRotation);
			MaxDeltaDir = Min(MaxDeltaDir, NeededRot + PossibleRotation);
		}
		MinDeltaDir = Max(MinDeltaDir, -129/RotationSpeed*RotationSpeed); // In Tests hat sich herausgestellt, dass grere DeltaDirs selten benutzt werden und nichts bringen. Wir sparen uns also die Rechenzeit
		MaxDeltaDir = Min(MaxDeltaDir, 129/RotationSpeed*RotationSpeed);
		assert(MinDeltaDir%RotationSpeed == 0);
		assert(MaxDeltaDir%RotationSpeed == 0);
		//Wir prfen erst die betragsmig kleinen DeltaDirs, damit diese bei gleichem Kollisionszeitpunkt bevorzugt werden
		//Das gibt erstaunlich viele Punkte:)
		int MaxAbsDeltaDir = Max(MaxDeltaDir, -MinDeltaDir) / RotationSpeed * 2;
		for(int AbsDeltaDir = 0; AbsDeltaDir <= MaxAbsDeltaDir; AbsDeltaDir++)
		{
			int DeltaDir;
			if(AbsDeltaDir == 0)
				DeltaDir = 0;
			else if(AbsDeltaDir%2 == 0)
				DeltaDir = AbsDeltaDir / 2 * RotationSpeed;
			else
				DeltaDir = (AbsDeltaDir+1) / 2 * -RotationSpeed;
			if(DeltaDir < MinDeltaDir || DeltaDir > MaxDeltaDir)
				continue;
			//if(DeltaDir != MinDeltaDir && DeltaDir != MaxDeltaDir)
			//	continue;///////////////////

			SimulateShot(ObjectsStates, ShotInfos, CurrentObjectsStates, CurrentShotInfo, cShotsShot,
				         t, NewShot, DeltaDir, MinCollisionAtTime, ShotInfosVariety, RotationWasLockedAtTime);

			//Hier simulieren wir einen Schuss in t Frames bei einer Schiffsdrehung von DeltaDir (relativ zur Richtung beim letzten Schuss)

/*			word StartX = Objects[PlayerIndex].PositionX;
			word StartY = Objects[PlayerIndex].PositionY;
			char VelocityX = Objects[PlayerIndex].VelocityX;
			char VelocityY = Objects[PlayerIndex].VelocityY;
			ShootLocationFromAngle(ShipDirection+DeltaDir,
								   StartX,
								   StartY,
								   VelocityX,
								   VelocityY);

			int CurrentObjectsStates2 = CurrentObjectsStates;
			int CurrentShotInfo2 = CurrentShotInfo;
			int cShotsShot2 = cShotsShot;
			for(int t2 = t; t2 < CollisionAtTime; t2++)
			{
				int CurrentTime2 = CurrentTime+t2-t;
				ObjectsStates.Update(CurrentTime2+1);
				//Wir simulieren die Bewegung des Schusses

				if(ShotInfos[CurrentShotInfo2].Time == CurrentTime2)
				{
					CurrentShotInfo2++;
					cShotsShot2++;
					assert(ObjectsStates[CurrentObjectsStates2].CountExtraSlots - cShotsShot2 >= 0);
					if(ObjectsStates[CurrentObjectsStates2].CountExtraSlots - cShotsShot2 <= 0)
						break;
				}

				while(CurrentTime2 == ObjectsStates[CurrentObjectsStates2].ValidUntilTime &&
					NewShot < ObjectsStates[CurrentObjectsStates2].CollisionCauser)
				{
					CurrentObjectsStates2++;
					cShotsShot2 = 0;
				}
				assert(CurrentTime2 <= ObjectsStates[CurrentObjectsStates2].ValidUntilTime);

				const Object* Objects2 = ObjectsStates[CurrentObjectsStates2].Objects;

				for(int Object = SaucerIndex-2; Object >= 0; Object--)
				{
					//Trifft der Schuss ein Objekt?
					if(Objects2[Object].Status <= 0)
						continue;
					bool collision = AreObjectsNear(NewShot,
													MoveLinearX(StartX, VelocityX, t2-t+1),
													MoveLinearY(StartY, VelocityY, t2-t+1),
													ShotLifetime/4,//wird ignoriert
						                            Object,
													MoveLinearX(Objects2[Object].PositionX, Objects2[Object].VelocityX, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1),
													MoveLinearY(Objects2[Object].PositionY, Objects2[Object].VelocityY, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1),
													Objects2[Object].Status);
					if(!collision)
						continue;
					//Wir treffen das Objekt!!

					//Wir schieen aber nicht, falls es gleich (noch im gleichen Frame) von einem anderen Schuss
					//getroffen wird.
					//Dies kann passieren, wenn unser Schuss einen hheren Index bekommt als der, der auf dieses
					//Objekt unterwegs ist, und wir das Objekt deshalb trotzdem erreichen knnen, obwohl wir
					//offensichtlich spter schieen. (Schsse mit hherem Index werden von Asteroids zuerst abgearbeitet)
					//Dieser Fall tritt aber zugegebenermaen sehr selten ein..
					int CurrentObjectsStates3 = CurrentObjectsStates2;
					while(CurrentTime2 == ObjectsStates[CurrentObjectsStates3++].ValidUntilTime)
						if(ObjectsStates[CurrentObjectsStates3].DestroyedObject == Object)
						{
#ifdef PRINT_DEBUG_INFO
							printf("Vermeide Schuss mit Slot %i auf %x um %i\n", NewShot-PlayerShotMinIndex, Object, CurrentTime);
#endif
							break;
						}
					if(CurrentTime2 == ObjectsStates[CurrentObjectsStates3-1].ValidUntilTime)
					{
						t2 = MaxInt;//Dieses DeltaDir kommt nicht in Frage
						break;
					}

//					while(CurrentObjectsStates3 < ObjectsStates.GetCountStates())
//						assert(ObjectsStates[CurrentObjectsStates3++].DestroyedObject != Object);

					//Wenn wir einen groen Asteroiden abknallen mssen wir darauf achten, dass es genug
					//Slots fr die zwei kleinen gibt.
					if(!(Objects2[Object].Status & 0x01))
					{
						int cFreeAsteroidSlots = 0;
						for(int i = AsteroidMinIndex; i <= AsteroidMaxIndex; i++)
							if(Objects2[i].Status == 0 ||
								Objects2[i].Status < 0 && AsteroidLifetime(Objects2[i].Status) <= CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1)
							{
								if(++cFreeAsteroidSlots == 2)
									break;
							}
						if(cFreeAsteroidSlots != 2)
						{
							//Wenn wir dieses Asteroiden abknallen wrden, wrden keine 2 kleinere Asteroiden entstehen
							//Wir vermeiden also diese Richtung zu diesem Zeitpunkt
#ifdef PRINT_DEBUG_INFO
							printf("Vermeide Schuss mit Slot %i auf %x um %i, da zu wenig Slots da sind\n", NewShot-PlayerShotMinIndex, Object, CurrentTime);
#endif
							t2 = MaxInt;
							break;
						}
					}

					if(CurrentTime2 < ShotInfos.GetMaxCollisionTime())
					{
#ifdef PRINT_DEBUG_INFO
						printf("Zu frueher Schuss\n");
#endif
						t2 = MaxInt;
						break;
					}


					bool CrossedNextDir = false;
					if(ShotInfos[CurrentShotInfo].Time != MaxInt && DeltaDir)
					{
						for(int i = 0; i != DeltaDir; i += (DeltaDir>0?RotationSpeed:-RotationSpeed))
							if(byte(i+ShipDirection) == ShotInfos[CurrentShotInfo].TargetDirection)
							{
								CrossedNextDir = true;
								break;
							}
					}

					CollisionAtTime = t2;
					MinCollisionAtTime = t2;

					ShotInfo BestShotInfo;
					BestShotInfo.Time = CurrentTime;
					if(DeltaDir > 0)
						BestShotInfo.Dir = Dir_Left;
					else if(DeltaDir < 0)
						BestShotInfo.Dir = Dir_Right;
					else
						BestShotInfo.Dir = Dir_None;
					BestShotInfo.TargetDirection = ShipDirection+DeltaDir;
					BestShotInfo.CollisionTime = CurrentTime2;
				
					BestShotInfo.ShotIndex = NewShot;
					BestShotInfo.PositionX = MoveLinearX(StartX, VelocityX, t2-t+1);
					BestShotInfo.PositionY = MoveLinearY(StartY, VelocityY, t2-t+1);
					BestShotInfo.Target = Object;
					BestShotInfo.StartX = StartX;
					BestShotInfo.StartY = StartY;
					BestShotInfo.VelocityX = VelocityX;
					BestShotInfo.VelocityY = VelocityY;
					BestShotInfo.TargetPositionX = MoveLinearX(Objects2[Object].PositionX, Objects2[Object].VelocityX, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1);
					BestShotInfo.TargetPositionY = MoveLinearY(Objects2[Object].PositionY, Objects2[Object].VelocityY, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1);
					BestShotInfo.TargetStatus = Objects2[Object].Status;

					ShotInfoList ShotInfos2 = ShotInfos;
					ShotInfos2.AddShot(BestShotInfo, CurrentShotInfo, CrossedNextDir);
					OriginalRam.CheckForErrors(ShotInfos2, BestShotInfo.CollisionTime+20);
					ShotInfosVariety.insert(ShotInfos2);
					break;
				}
				if(t2 == MaxInt)
					break;
				while(CurrentTime2 == ObjectsStates[CurrentObjectsStates2].ValidUntilTime)
				{
					CurrentObjectsStates2++;
					cShotsShot2 = 0;
				}
				assert(CurrentTime2 < ObjectsStates[CurrentObjectsStates2].ValidUntilTime);
			}*/
		}
	}
}


//Das knnte man noch so optimieren, dass man die beiden Schleifen austauscht und dann
//fr jedes Objekt gegen einen Linie testet, anstatt der einzelnen Punkte.
void GameState::SimulateShot(ObjectsStateList& ObjectsStates, const ShotInfoList& ShotInfos,
						   const int CurrentObjectsStates, const int CurrentShotInfo, const int cShotsShot,
						   const int t,
						   const int ShotIndex, const int DeltaDir, int& MinCollisionAtTime,
						   std::multiset<ShotInfoList>& ShotInfosVariety, int RotationWasLockedAtTime)
{
	word StartX = Objects[PlayerIndex].PositionX;
	word StartY = Objects[PlayerIndex].PositionY;
	char VelocityX = Objects[PlayerIndex].VelocityX;
	char VelocityY = Objects[PlayerIndex].VelocityY;
	ShootLocationFromAngle(ShipDirection+DeltaDir,
						   StartX,
						   StartY,
						   VelocityX,
						   VelocityY);

	//Je nach Abschusszeitpunkt berlebt der Schuss unterschiedlich lange
	int CollisionAtTime = Min(ShotLifetime-4 + (3-(Timer&3)) + t, MinCollisionAtTime);

	int CurrentObjectsStates2 = CurrentObjectsStates;
	int CurrentShotInfo2 = CurrentShotInfo;
	int cShotsShot2 = cShotsShot;
	for(int t2 = t; t2 < CollisionAtTime; t2++)
	{
		int CurrentTime2 = CurrentTime+t2-t;
		ObjectsStates.Update(CurrentTime2+1);
		//Wir simulieren die Bewegung des Schusses

		if(ShotInfos[CurrentShotInfo2].Time == CurrentTime2)
		{
			CurrentShotInfo2++;
			cShotsShot2++;
			if(ValidateKIGame)
				assert(ObjectsStates[CurrentObjectsStates2].CountExtraSlots - cShotsShot2 >= 0, KIGameInvalidException());
			if(ObjectsStates[CurrentObjectsStates2].CountExtraSlots - cShotsShot2 <= 0)
				break;
		}

		while(CurrentTime2 == ObjectsStates[CurrentObjectsStates2].ValidUntilTime &&
			ShotIndex < ObjectsStates[CurrentObjectsStates2].CollisionCauser)
		{
			CurrentObjectsStates2++;
			cShotsShot2 = 0;
		}
		assert(CurrentTime2 <= ObjectsStates[CurrentObjectsStates2].ValidUntilTime);

		const Object* Objects2 = ObjectsStates[CurrentObjectsStates2].Objects;

		for(int Object = SaucerIndex; Object >= AsteroidMinIndex; Object--)
		{
			if(Object == PlayerIndex)//Wir knnen zwar vom eigenen Schuss getroffen werden, allerdings nur mit Hyperspace. Und den benutzen wir eh nicht.
				continue;
			//Trifft der Schuss ein Objekt?
			if(Objects2[Object].Status <= 0)
				continue;
			bool collision = AreObjectsNear(ShotIndex,
											MoveLinearX(StartX, VelocityX, t2-t+1),
											MoveLinearY(StartY, VelocityY, t2-t+1),
											ShotLifetime/4,//wird ignoriert
				                            Object,
											MoveLinearX(Objects2[Object].PositionX, Objects2[Object].VelocityX, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1),
											MoveLinearY(Objects2[Object].PositionY, Objects2[Object].VelocityY, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1),
											Objects2[Object].Status);
			if(!collision)
				continue;
			//Wir treffen das Objekt!!

			//Wir schieen aber nicht, falls es gleich (noch im gleichen Frame) von einem anderen Schuss
			//getroffen wird.
			//Dies kann passieren, wenn unser Schuss einen hheren Index bekommt als der, der auf dieses
			//Objekt unterwegs ist, und wir das Objekt deshalb trotzdem erreichen knnen, obwohl wir
			//offensichtlich spter schieen. (Schsse mit hherem Index werden von Asteroids zuerst abgearbeitet)
			//Dieser Fall tritt aber zugegebenermaen sehr selten ein..
			int CurrentObjectsStates3 = CurrentObjectsStates2;
			while(CurrentTime2 == ObjectsStates[CurrentObjectsStates3++].ValidUntilTime)
				if(ObjectsStates[CurrentObjectsStates3].DestroyedObject == Object)
				{
#ifdef PRINT_DEBUG_INFO
					printf("Vermeide Schuss mit Slot %i auf %x um %i\n", ShotIndex-PlayerShotMinIndex, Object, CurrentTime);
#endif
					break;
				}
			if(CurrentTime2 == ObjectsStates[CurrentObjectsStates3-1].ValidUntilTime)
			{
				t2 = MaxInt;//Dieses DeltaDir kommt nicht in Frage
				break;
			}

			//Wenn wir einen groen Asteroiden abknallen mssen wir darauf achten, dass es genug
			//Slots fr die zwei kleinen gibt.
			if(!(Objects2[Object].Status & 0x01))
			{
				int cFreeAsteroidSlots = 0;
				for(int i = AsteroidMinIndex; i <= AsteroidMaxIndex; i++)
					if(Objects2[i].Status == 0 ||
						Objects2[i].Status < 0 && Objects2[i].ExplosionLifetime() <= CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1)
					{
						if(++cFreeAsteroidSlots == 2)
							break;
					}
				if(cFreeAsteroidSlots != 2)
				{
					//Wenn wir dieses Asteroiden abknallen wrden, wrden keine 2 kleinere Asteroiden entstehen
					//Wir vermeiden also diese Richtung zu diesem Zeitpunkt
#ifdef PRINT_DEBUG_INFO
					printf("Vermeide Schuss mit Slot %i auf %x um %i, da zu wenig Slots da sind\n", ShotIndex-PlayerShotMinIndex, Object, CurrentTime);
#endif
					t2 = MaxInt;
					break;
				}
			}

			if(CurrentTime2 < ShotInfos.GetMaxCollisionTime())
			{
//#ifdef PRINT_DEBUG_INFO
//				printf("Zu frueher Schuss\n");
//#endif
				t2 = MaxInt;
				break;
			}

			MinCollisionAtTime = CollisionAtTime = t2;

			ShotInfo BestShotInfo;
			BestShotInfo.Time = CurrentTime;
			if(DeltaDir > 0)
				BestShotInfo.Dir = Dir_Left;
			else if(DeltaDir < 0)
				BestShotInfo.Dir = Dir_Right;
			else
				BestShotInfo.Dir = Dir_None;
			BestShotInfo.TargetDirection = ShipDirection+DeltaDir;
			BestShotInfo.CollisionTime = CurrentTime2;
			BestShotInfo.RotationWasLockedAtTime = RotationWasLockedAtTime;

			BestShotInfo.ShotIndex = ShotIndex;
			BestShotInfo.PositionX = MoveLinearX(StartX, VelocityX, t2-t+1);
			BestShotInfo.PositionY = MoveLinearY(StartY, VelocityY, t2-t+1);
			BestShotInfo.Target = Object;
			BestShotInfo.StartX = StartX;
			BestShotInfo.StartY = StartY;
			BestShotInfo.VelocityX = VelocityX;
			BestShotInfo.VelocityY = VelocityY;
			BestShotInfo.TargetPositionX = MoveLinearX(Objects2[Object].PositionX, Objects2[Object].VelocityX, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1);
			BestShotInfo.TargetPositionY = MoveLinearY(Objects2[Object].PositionY, Objects2[Object].VelocityY, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1);
			BestShotInfo.TargetStatus = Objects2[Object].Status;
			BestShotInfo.StartDirection = ShipDirection;

			bool CrossedNextDir = false;
			if(ShotInfos[CurrentShotInfo].Time != MaxInt && DeltaDir)
			{
				for(int i = 0; i != DeltaDir; i += (DeltaDir>0?RotationSpeed:-RotationSpeed))
					if(byte(ShipDirection+i) == ShotInfos[CurrentShotInfo].TargetDirection)
					{
						CrossedNextDir = true;
						break;
					}
			}


			ShotInfoList ShotInfos2 = ShotInfos;
			ShotInfos2.AddShot(BestShotInfo, CurrentShotInfo, CrossedNextDir);
			//OriginalRam.CheckForErrors(ShotInfos2, BestShotInfo.CollisionTime+20);
			ShotInfosVariety.insert(ShotInfos2);
			break;
		}
		if(t2 == MaxInt)
			break;
		while(CurrentTime2 == ObjectsStates[CurrentObjectsStates2].ValidUntilTime)
		{
			CurrentObjectsStates2++;
			cShotsShot2 = 0;
		}
		assert(CurrentTime2 < ObjectsStates[CurrentObjectsStates2].ValidUntilTime);
	}
}

void GameState::CheckForErrors(const ShotInfoList& ShotInfos, int UntilTime)
{
	//Zuknftige Schritte simulieren, um schon jetzt Fehler abzufangen, die spter auftreten knnen (erleichtert Debugging)
	GameState OriginalGame = *this;
	//bool ErrorsOccured = false;
	//pErrorsOccured = &ErrorsOccured;
	int CurrentShotInfo = 0;
	while(CurrentTime != UntilTime)
	{
		Move(ShotInfos[CurrentShotInfo], ShotInfos[CurrentShotInfo+1]);
		if(ShotInfos[CurrentShotInfo].Time == CurrentTime-1)
			CurrentShotInfo++;
	}
	*this = OriginalGame;
	/*pErrorsOccured = 0;
	if(ErrorsOccured)
	{
		printf("Fehler...:(\n");
		while(true)
			;
		MessageBeep(0);
		//exit(0);
		// CalcDirInfos(pShotInfo, pDeltaDir, CalcSecondShoot, FixedShootAtTime, FixedShootAtDir, FixedKey);
	}*/
}
