//Das ist wohl das Herz dieses Programms. Diese Klasse ist praktisch ein nachprogrammiertes
//Asteroids, welches zumindest gameplay theoretisch exakt nachgebildet ist. Bei gleichen
//Anfangsparametern und gleichen Tastendrcken sollte sich diese Klasse also genau wie
//das Original verhalten.
//Nicht eingebaut sind das Men (Highscore, Mnzen und co.), Support fr mehrere Spieler,
//Game Over (Man kann mit 0 Leben normal weiter spielen) und die Fhigkeit zum Erstellen
//eines VRams (Dafr gibt es eine GDI Renderfunktion).

//Auerdem ist die Klasse so erweitert, dass sie eine gewisse Varianz einiger Parameter
//zulsst. So kann zB der Seed mehrere Werte gleichzeitig haben, Objekte mehrere Positionen,
//der Timer unbekannte Bits... Wenn eine unscharfe Variable zu verschiedenen Ergebnissen
//fhrt (eine Art Schmetterlingseffekt), spaltet sich die entsprechende Codestelle, wo diese
//Variable entscheident ist, praktisch auf: Zuerst rechnet man mit dem einen Wert, dann mit dem
//anderen. Am Ende von Move() kann man also mehrere Spielzustnde haben, die je nach den Variablen
//unterschiedlich sind. Von dieses Spielzustnden vergleichen wir alle mit dem empfangenen VRam
//und schmeien die weg, die nicht passen. Dann sollte mindestens ein Spielzustand brig
//bleiben, der dem Spielzustand in Mame entspricht. Falls mehrere Spielzustnde brigbleiben,
//werden diese zusammengepappt, sodass das Spiel alle Zustnde der einzelnen Spiele einnehmen kann.
//Falls keiner brigbleibt, haben wir ein ernsthaftes Problem:(
//So lassen sich theoretisch alle versteckten Parameter im Laufe des Spiels ermitteln, die
//Einfluss auf das Spielgeschehen haben.

class ObjectsStateList;

class GameState
{
	int CurrentTime; //Eigner globaler Zeitzhler. Wird am Ende von Move inkrementiert.
	int GameStartedTime;
#ifdef DETECT_START_FOR_TIMERBITS
	bool StartPrintedLastFrame, StartSwapNoticed;
#endif

	byte NumPlayers;
	int Score;  //Asteroids speichert den Score anders, nmlich in 2 Bytes und in dezimal. Ja richtig, DEZIMAL!
				//Wenn man also beispielsweise 12340 Punkte hat, ist in dem einem Byte 0x12 (=18) drin und in
				//dem anderen 0x34 (=52). Die 0 am Ende ist nur Deko.
				//Wir speichern den Score ohne berlauf.
	byte NumShips;
	char HyperSpaceStatus;
	byte Timer; //Wird jeden Frame inkrementiert. Das Original nimmt sich dafr eigentlich sogar 2 Bytes,
				//benutzt aber effektiv noch nichtmal das erste Byte, sondern nur die ersten 7 Bits.
				//Mag sein, dass hhere Bits fr Sachen benutzt werden, die ich mir nicht weiter angeschaut
				//habe (vielleicht der Wechsel zur Highscoreanzeige im Men)
	int TimerBitsKnown; //Wie viele Bits vom Timer bekannt sind.
						//Das erste lsst sich leicht ber den Backbuffer herausfinden, da dieser
						//synchron mit dem Timer wechselt.
						//Die ersten 6 lassen sich auf einen Schlag bestimmen, wenn man "PUSH START"
						//zweimal blinken sieht
						//Falls man das nicht tut, kann man die ersten beiden bestimmen, weil
						//das UFO nur auftaucht, wenn die ersten beiden Bits nicht gesetzt sind.
						//Das 7te entscheidet mit, ob das UFO die Richtung wechseln soll, lsst sich also
						//so bestimmen.
						//Das letzte hat, wie gesagt, keinen Einfluss auf das Spielgeschehen und lsst sich
						//deshalb auch nicht bestimmen.
						//	byte RandomSeed1, RandomSeed2;
public:
	BitArray<NumSeedCombinations> RandomSeedDistribution;
private:
	byte ShipDirection;  //Die Richtung des Schiffes, das berchtige Winkelbyte:)
	byte MaxShipDirection;	//Der maximale Wert. Der eigentliche Wert liegt also zwischen ShipDirection
							//und MaxShipDirection (inklusive), wobei letzteres auch kleiner sein kann, wenn
							//die "Nahtstelle" des Rings dazwischen liegt. Es ist also auch z.B.
							//ShipDirection == 254 && MaxShipDirection == 2 mglich.
	byte FireHyperspaceToggle; //Hier wird gespeichert, ob im letzten Frame geschossen wurde
	byte AccX, AccY;//Acc steht fr Acceleration. Die Variablen zeigen aber nicht wirklich
					//die Beschleunigung, sondern stellen einen Timer fr jede Komponente dar.
					//Bei jedem Durchlauf wird die Geschwindigkeit gendert, je nachdem, ob
					//man gerade Gas gibt oder nicht.
					//Habs einfach so genannt, weil ich beim Lesen des Maschinencodes noch
					//nicht wusste, was sie genau bedeuten..
	byte NumAsteroids, NumAsteroidsStart;
	byte SaucerCountdown, SaucerCountdownStart;	
	byte AsteroidDestroyedTimer;//Wird zurckgesetzt, wenn ein Asteroid getroffen wurde und zhlt
								//stndig runter. Wird benutzt, um zu entscheiden, ob ein UFO
								//erstellt werden soll.
								//Es wird am Anfang nicht auf einen Wert gesetzt, sodass es am Anfang
								//unbekannt ist, es sollte sich aber automatisch synchronisieren,
								//da die KI recht schnell einen Asteroiden treffen sollte.
	byte InvisibleTimer; //Das Schiff ist unsichtbar, solange != 0
	byte NewLevelStartCountdown;
	byte Level; //Wird jedes Level bis zu einem Maximalwert inkrementiert

	Object Objects[NumObjects];

public:
	void StartNewGame()//loc_68DE
	{
		memset(this, 0, sizeof(*this));//Bitte nicht nachmachen! Endet schnell bse, wenn Member C++ Objekte sind, virtuelle Methoden vorhanden sind oder Vererbung im Spiel ist.
		NumPlayers = 0;
		NumShips = 3;
		//RandomSeed1 = 5;
		NumAsteroidsStart = 2;
		InvisibleTimer = 1;
		SaucerCountdownStart = SaucerCountdown = 0x92;
		NewLevelStartCountdown = 0x7F;
		Level = 5;
		ResetPlayerPosition();

#ifdef DETECT_START_FOR_TIMERBITS
		StartSwapNoticed = false;
#endif
		RandomSeedDistribution.SetAll();
		TimerBitsKnown = 0;
		ShipDirection = 0;
		MaxShipDirection = 255;
	}

	int GetTime() const
	{
		return CurrentTime;
	}

	void SetTime(int Time)
	{
		this->CurrentTime = Time;
	}

	int GetScore() const
	{
		return Score;
	}

	bool IsPlaying() const
	{
		return NumPlayers != 0;
	}

	int GetCountExtraSlots() const
	{
		int CountExtraSlots = 0;
		for(int i = PlayerShotMinIndex; i <= PlayerShotMaxIndex; i++)
			if(Objects[i].Status == 0)
				CountExtraSlots++;
		return CountExtraSlots;
	}

	void Move(byte Keys)
	{
		Timer++;

		//sub_6885
		if(NumPlayers &&
			Objects[PlayerIndex].Status == 0 &&
			InvisibleTimer == 0x80)
		{
			InvisibleTimer = 0x10;
			//if(cShips == 0) loc_69CF();
			//sub_702D
			SaucerCountdown = SaucerCountdownStart;
			Objects[SaucerIndex].Status = 0;
			Objects[SaucerIndex].VelocityX = 0;
			Objects[SaucerIndex].VelocityY = 0;
		}


		Shoot(Keys, 0);
		DoHyperSpace(Keys, 0);
		UpdateHyperspace(Keys); //Ruft UpdateDirectionAndThrust() auf
		UpdateSaucer(0);

		//Objekte aktualisieren
		for(int i = NumObjects-1; i >= 0; i--)
			MoveObject(i);

		UpdateShots();

		// Kollision fr Spielerschsse(4), Saucerschsse(2), Saucer und Schiff prfen
		for(int CollisionObject = PlayerShotMaxIndex; CollisionObject >= PlayerIndex; CollisionObject--)
			CheckCollisions(CollisionObject, -1, 0);

		//Asteroids ruft hier Rand() auf. Aufgrund der Weise, wie wir uns die Verteilung
		//speichern, knnen wir die Verteilung einfach nach rechts rotieren.
		//Siehe auch RandomSeeds.h
		RandomSeedDistribution.RotateRight();

		//sub_7BC0

		byte a = NewLevelStartCountdown;
		if(a)
			NewLevelStartCountdown--;
		if((a | NumAsteroids) == 0)
			ResetAsteroids(0);

		CurrentTime++;
	}

	byte GetKeyFromShotInfo(const ShotInfo& CurrentShotInfo, const ShotInfo& NextShotInfo)
	{
		byte Keys = 0;
		assert(CurrentShotInfo.Time >= CurrentTime);
		if(CurrentShotInfo.Time != MaxInt && ShipDirection != CurrentShotInfo.TargetDirection)
		{
			Keys = KeyFromDirection(CurrentShotInfo.Dir);
		}
		if(CurrentShotInfo.Time <= CurrentTime)
		{
			//Jetzt mssen wir schieen
			if(ValidateKIGame)
				assert(ShipDirection == CurrentShotInfo.TargetDirection, KIGameInvalidException());
			assert(NextShotInfo.Time > CurrentTime);
			//Jetzt schon die Richtung fr den nchsten Schuss setzen, da Asteroids leider erst schiet und dann die Richtung ndert
			if(NextShotInfo.Time != MaxInt && ShipDirection != NextShotInfo.TargetDirection)
				Keys = KeyFromDirection(NextShotInfo.Dir);
			else
				Keys = 0;
			Keys |= Key_Fire;
		}
		if(CurrentShotInfo.Time != MaxInt &&
		   CurrentShotInfo.RotationWasLockedAtTime >= CurrentTime &&
		   (Keys&Key_Fire) == 0 &&
		   WouldHyperSpaceSuccess(false))
		{
			Keys |= Key_Hyperspace;
			printf("Hyperspace weil sonst tot um %i\n", CurrentShotInfo.RotationWasLockedAtTime);
		}
		else if((CurrentShotInfo.Time != MaxInt && CurrentShotInfo.Time - CurrentTime >  120 || HyperSpaceTargetY != 0xffff) &&
				(Keys&Key_Fire) == 0 &&
				!PlayerPositionGoodForKI(Objects[PlayerIndex].PositionX, Objects[PlayerIndex].PositionY) && 
				WouldHyperSpaceSuccess(true)) 
		{
			Keys |= Key_Hyperspace;
			printf("Hyperspace fuer gute Position\n");
		}
/*		if(CurrentShotInfo.Time != MaxInt && CurrentShotInfo.Time - CurrentTime > 30)
		{
			printf("Thrust um %i zu lange\n", CurrentShotInfo.Time);
			Keys |= Key_Thrust;
		}*/
		return Keys;
	}

	void Move(const ShotInfo& CurrentShotInfo, const ShotInfo& NextShotInfo)
	{
		Move(GetKeyFromShotInfo(CurrentShotInfo, NextShotInfo));
	}

	void VRamMove(byte Keys, const word* VRam, const byte* Ram,
				  std::vector<GameState>& NewVRamGames,
				  int LastVRamScore, int LastVRamNumShips, int& NewVRamScore, int& NewVRamNumShips,
				  GameState* pKIGame)
	{
#if 0
		FILE* out = fopen("asteroidpos.txt", "w");

		int h = 0;
		for(int i = 0; i < NumSeedCombinations; i++)
		{
			RandomSeedDistribution.ClearAll();
			RandomSeedDistribution.Set((i-28+NumSeedCombinations)%NumSeedCombinations, true);
			NumAsteroidsStart = 2;
			Objects[SaucerIndex].Status = 0;
			NewLevelStartCountdown = 0;

			for(int i = AsteroidMaxIndex-4+1; i <= AsteroidMaxIndex; i++)
			{
				Objects[i].SetEmpty();
				Objects[i].AddLocation(0xffff, 0xffff, 0, 0);
			}

			ResetAsteroids(0);

			fprintf(out, "\t{ ", RandomSeedDistribution.GetFirstSetIndex());
			for(int i = AsteroidMaxIndex-4+1; i <= AsteroidMaxIndex; i++)
			{
				assert(Objects[i].Status != 0);
				assert(Objects[i].IsFixed());
				if(Objects[i].PositionY == 0)
				{
					assert(Objects[i].PositionX != 0);
					LowByte(Objects[i].PositionX) = 0;
					word MinX = MoveLinearX(Objects[i].PositionX, Objects[i].VelocityX, 1)/8;
					LowByte(Objects[i].PositionX) = 0xff;
					word MaxX = MoveLinearX(Objects[i].PositionX, Objects[i].VelocityX, 1)/8;
					Objects[i].PositionY = MoveLinearY(Objects[i].PositionY, Objects[i].VelocityY, 1);
					fprintf(out, "{ 0x%02x, false, 0x%04x, 0x%04x, 0x%04x, (char)0x%02x, (char)0x%02x}, ",
						Objects[i].Status,
						MinX, MaxX, Objects[i].PositionY,
						Objects[i].VelocityX&0xff, Objects[i].VelocityY&0xff);
				}
				else if(Objects[i].PositionX == 0)
				{
					LowByte(Objects[i].PositionY) = 0;
					word MinY = MoveLinearY(Objects[i].PositionY, Objects[i].VelocityY, 1)/8;
					LowByte(Objects[i].PositionY) = 0xff;
					word MaxY = MoveLinearY(Objects[i].PositionY, Objects[i].VelocityY, 1)/8;
					Objects[i].PositionX = MoveLinearX(Objects[i].PositionX, Objects[i].VelocityX, 1);
					fprintf(out, "{ 0x%02x, true , 0x%04x, 0x%04x, 0x%04x, (char)0x%02x, (char)0x%02x}, ",
						Objects[i].Status,
						MinY, MaxY, Objects[i].PositionX,
						Objects[i].VelocityX&0xff, Objects[i].VelocityY&0xff);
				}
				else
					assert(0);
				//PreMoveObject(i);
			}
			fprintf(out, "},\n");
			printf("%i\n", h++);
		}
		fclose(out);
		exit(0);
#endif

		std::stack<MovePosition> MovePositions;
		MovePosition NextMovePosition(MPT_Start, false);

		while(true)
		{
			bool VRamInvalid = false;

			if(NextMovePosition.Type != MPT_NewGame)
			{
				if(NumPlayers)
					VRamMove(Keys, NextMovePosition, MovePositions, LastVRamScore, LastVRamNumShips, VRamInvalid, Ram, pKIGame);
				else
				{
					Timer++;
					CurrentTime++;
				}

				if(!VRamInvalid && VRam)
					CheckVRam(&NewVRamScore, &NewVRamNumShips, VRam, VRamInvalid, MovePositions);
			}


			if(!VRamInvalid)
			{
				pKIGame = 0;//Wir haben einen korrekten Gamestate gefunden, weitere brauchen wir nicht
				NewVRamGames.push_back(*this);
			}

			while(!VRamInvalid && !MovePositions.empty() && MovePositions.top().SkipRemainingIfSuccessful)
				MovePositions.pop();

			if(MovePositions.empty())
				break;

			NextMovePosition = MovePositions.top();
			MovePositions.pop();
			*this = NextMovePosition.Game;
		}
	}

	bool VRamMove(byte Keys,
		const MovePosition& NextMovePosition,
		std::stack<MovePosition>& MovePositions,
		int LastVRamScore, int LastVRamNumShips, bool& VRamInvalid,
		const byte* Ram, GameState* pKIGame)
	{
		int CollisionObject;
		int FixedTarget;

		//Ja, ich wei. goto ist bse. Es wre hier auch viel einfacher, wenn man den Stack kopieren und wiederherstellen
		//knnte. Leider wei ich nicht wie das geht und bezweifle auch, dass es einfach ist.
		//Unter Unix knnte man einfach fork() benutzen. Allerdings wei ich nicht, ob das so schnell wre und
		//mag Windows einfach lieber:)
		//Jedenfalls ist das mit den gotos zwar etwas unbersichtlich, aber sicher bersichtlicher als wenn ich
		//hier paar Ebenen mit if else Blcken reingepackt htte, oder das ganze mit ner Statemachine gemacht htte.
		switch(NextMovePosition.Type)
		{
		case MPT_Start:
			break;

		case MPT_ObjectCollision:
			CollisionObject = NextMovePosition.CollisionCauser;
			FixedTarget = NextMovePosition.Target;
			goto CheckCollisionsLabel;

		case MPT_ResetAsteroids: goto ResetAsteroidsLabel;
		case MPT_Shoot: goto ShootLabel;
		case MPT_DoHyperSpace: goto DoHyperspaceLabel;
		case MPT_UpdateSaucer: goto UpdateSaucerLabel;

		default:
			assert(0);
		}

		UpdateShots();

		// Kollision fr Spielerschsse(4), Saucerschsse(2), Saucer und Schiff prfen
		CollisionObject = PlayerShotMaxIndex;
		FixedTarget = -1;
CheckCollisionsLabel:
		for(; CollisionObject >= PlayerIndex; CollisionObject--)
		{
			CheckCollisions(CollisionObject, FixedTarget, &MovePositions);
			FixedTarget = -1;
		}

		if(LastVRamScore != -1)
		{
			VRamAssert(Score%100000 == LastVRamScore, VRamInvalid);
			VRamAssert(NumShips == LastVRamNumShips, VRamInvalid);
		}

		//Asteroids ruft hier Rand() auf. Aufgrund der Weise, wie wir uns die Verteilung
		//speichern, knnen wir die Verteilung einfach nach rechts rotieren.
		//Siehe auch RandomSeeds.h
		RandomSeedDistribution.RotateRight();

		//sub_7BC0

		byte a = NewLevelStartCountdown;
		if(a)
			NewLevelStartCountdown--;
		if((a | NumAsteroids) == 0)
		{
ResetAsteroidsLabel:
			ResetAsteroids(&MovePositions);
		}

		CurrentTime++;

		//Hier endet die eigentliche Hauptschleife von Asteroids
		//Es wird also auf den Vektorgenerator gewartet und Mame schickt uns zu diesem
		//Zeitpunkt den VRam Inhalt
		if(Ram)
		{
			try
			{
				CheckRam(Ram);
			}
			catch(RamInvalidException)
			{
				if(false)
					throw;
				//printf("Ram falsch\n");
			}
		}

		if(pKIGame)
		{
			*pKIGame = *this;
			pKIGame->SetFixed();
		}


		Timer++;

		//sub_6885
		if(NumPlayers &&
			Objects[PlayerIndex].Status == 0 &&
			InvisibleTimer == 0x80)
		{
			InvisibleTimer = 0x10;
			//if(cShips == 0) loc_69CF();
			//sub_702D
			SaucerCountdown = SaucerCountdownStart;
			Objects[SaucerIndex].Status = 0;
			Objects[SaucerIndex].VelocityX = 0;
			Objects[SaucerIndex].VelocityY = 0;
		}

ShootLabel:
		Shoot(Keys, &MovePositions);
DoHyperspaceLabel:
		DoHyperSpace(Keys, &MovePositions);
		UpdateHyperspace(Keys); //Ruft UpdateDirectionAndThrust() auf
UpdateSaucerLabel:
		UpdateSaucer(&MovePositions);

		//Objekte aktualisieren
		for(int i = NumObjects-1; i >= 0; i--)
			MoveObject(i);

		return false;
	}

	void MoveObject(int i)
	{
		//byte tmp4, tmp5, tmp6, tmp7;
		byte a = Objects[i].Status;
		if(a == 0)
			return;
		//loc_6F62
		if(char(a) < 0)
		{
			//Objekt explodiert
			a = ((a^0xFF)+1) >> 4;
			//a = (-a) >> 4;
			bool c = true;
			if(i == PlayerIndex)
			{
				c = (Timer&1) != 0;
				a = 0;
			}
			//loc_6F77
			Add(a, Objects[i].Status, c);
			if(char(a) < 0)
			{//loc_6FA1
				//Objekt explodiert weiter
				Objects[i].Status = a;
				//a = (a&0xF0)+0x10;
				//if(i == PlayerIndex)
				//	a = 0;
				//byte y = a;
				//4567a = VarO(RAMO_PositionExactX, i);
				{//loc_7027
					//sub_72FE
				}
			}
			else if(i == PlayerIndex)
			{//loc_6F93
				ResetPlayerPosition();
				Objects[i].Status = 0;
			}
			else if(i == SaucerIndex)
			{//loc_6F99
				SaucerCountdown = SaucerCountdownStart;
				Objects[i].Status = 0;
			}
			else
			{
				assert(i >= AsteroidMinIndex && i <= AsteroidMaxIndex);
				if(--NumAsteroids == 0)
					NewLevelStartCountdown = 0x7F;
				Objects[i].Status = 0;
			}
			return;
		}
		//loc_6FC7
		//byte y = 0;

		//xPosition += char(VarO(RAMO_VelocityX, i));
		/*a = VarO(RAMO_VelocityX, i);
		if(char(a) < 0)
		y--;
		bool c = false;
		Add(a, VarO(RAMO_PositionExactX, i), c);
		VarO(RAMO_PositionExactX, i) = a;
		a = y;
		Add(a, VarO(RAMO_PositionX, i), c);*/
		//if(a >= 0x20)//Objekt geht rechts raus

		if(i == SaucerIndex && word(Objects[i].PositionX + Objects[i].VelocityX) >= 0x2000)
		{
			//Das UFO ist ber den Bildschirmrand gelaufen
			//sub_702D
			SaucerCountdown = SaucerCountdownStart;
			Objects[SaucerIndex].Status = 0;
			LowByte(Objects[SaucerIndex].PositionX) = word(Objects[i].PositionX + Objects[i].VelocityX) & 0xFF;
			Objects[SaucerIndex].VelocityX = 0;
			Objects[SaucerIndex].VelocityY = 0;
			return;
		}
		//Objects[i].PositionX = MoveLinearX(Objects[i].PositionX, Objects[i].VelocityX, 1);
		//		MakeBytesFromWord(xPosition, VarO(RAMO_PositionX, i), VarO(RAMO_PositionExactX, i));
		//loc_6FEC
		//VarO(RAMO_PositionX, i) = a;

		//Objects[i].PositionY = MoveLinearY(Objects[i].PositionY, Objects[i].VelocityY, 1);
		Objects[i].MoveLinear(1);
		//		MakeBytesFromWord(yPosition, VarO(RAMO_PositionY, i), VarO(RAMO_PositionExactY, i));

/*		y = 0;
		a = VarO(RAMO_VelocityY, i);
		if(char(a) < 0)
			y--;
		bool c = false;
		Add(a, VarO(RAMO_PositionExactY, i), c);
		VarO(RAMO_PositionExactY, i) = a;
		a = y;
		Add(a, VarO(RAMO_PositionY, i), c);
		if(a >= 0x18)
		{
			if(a == 0x18)
			{//loc_7011
				a = 0;
			}
			else
				a = 0x17;
		}
		//loc_7013
		VarO(RAMO_PositionY, i) = a;*/

/*		a = Objects[i].Status;
		y = 0xE0;
		if((a&1) == 0)
		{
			y = 0xF0;
			if((a&2) == 0)
				y = 0;
		}*/
			//sub_72FE(i);
	}

	void UpdateShots()
	{
		if(Timer & 3)
			return;
		for(int i = PlayerShotMaxIndex; i >= SaucerShotMinIndex; i--)
		{
			if(Objects[i].Status > 0)
			{
				Objects[i].Status--;
				if(Objects[i].Status == 0 && i >= PlayerShotMinIndex)
				{
#ifdef PRINT_DEBUG_INFO
					printf("Shot %i ins Leere gegangen um %i\n", i-PlayerShotMinIndex, CurrentTime);
#endif
					if(ValidateKIGame)
						assert(0, KIGameInvalidException());
					//*pErrorsOccured = true;
				}
			}
		}
	}

	byte GetHash()
	{
		return Timer&0x3F;
		/*byte h = RandomSeed1 + RandomSeed2;
		for(int i = 0; i < NumObjects; i++)
		{
			h += Objects[i].Status;
			h += Objects[i].VelocityX + Objects[i].VelocityY;
			h += LowByte(Objects[i].PositionX) + HighByte(Objects[i].PositionX);
			h += LowByte(Objects[i].PositionY) + HighByte(Objects[i].PositionY);
		}
		return h;*/
	}

	void Shoot(byte Keys, std::stack<MovePosition>* pMovePositions)//sub_6CD7
	{
		if(NumPlayers == 0)
			return;

		if(ShipDirection != MaxShipDirection &&
			(Keys & Key_Fire) &&
			(FireHyperspaceToggle & 0x80) == 0 &&
			InvisibleTimer == 0 &&
			GetCountExtraSlots())
		{
			//Wir werden gleich schieen, kennen die Schiffsrichtung aber noch nicht genau
			MovePosition NewMovePosition(MPT_Shoot, false);
			NewMovePosition.Game = *this;
			NewMovePosition.Game.ShipDirection++;
			pMovePositions->push(NewMovePosition);

			MaxShipDirection = ShipDirection;
		}

		FireHyperspaceToggle >>= 1;
		if(Keys & Key_Fire)
			FireHyperspaceToggle |= 0x80;

		if(!(Keys & Key_Fire) || //nicht gedrckt?
			FireHyperspaceToggle & 0x40 || //letzten Frame schon gedrckt?
			InvisibleTimer) //unsichtbar?
			return;

		int NewShot = PlayerShotMaxIndex;
		while(Objects[NewShot].Status)
			if(NewShot-- == PlayerShotMinIndex)
				return;

		Objects[NewShot] = Objects[PlayerIndex];
		Objects[NewShot].Status = ShotLifetime/4;

		ShootLocationFromAngle(ShipDirection, Objects[NewShot].PositionX, Objects[NewShot].PositionY, Objects[NewShot].VelocityX, Objects[NewShot].VelocityY);
	}

	static void ShootLocationFromAngle(byte Direction, word& PositionX, word& PositionY, char& VelocityX, char& VelocityY)
	{
		//xVelocity
		byte a = Direction;
		CosLookup(a);
		bool c = a >= 0x80;
		RotateRight(a, c);
		byte tmp9 = a;
		a += byte(VelocityX);
		Clamp(a, 0x91, 0x6F);
		VelocityX = char(a);

		//yVelocity
		a = Direction;
		SinLookup(a);
		c = a >= 0x80;
		RotateRight(a, c);
		byte tmpC = a;
		a += byte(VelocityY);
		Clamp(a, 0x91, 0x6F);
		VelocityY = char(a);

		PositionX += char(tmp9) + char(Half(tmp9));
		PositionY += char(tmpC) + char(Half(tmpC));

		/*		//xVelocity
		byte a = Var(RAM_ShipDirection);
		CosLookup(a);
		bool c = a >= 0x80;
		RotateRight(a, c);
		byte tmp9 = a;
		a += VarO(RAMO_VelocityX, PlayerIndex);
		Clamp(a, 0x91, 0x6F);
		VarO(RAMO_VelocityX, PlayerIndex+NewShot) = a;

		//yVelocity
		a = Var(RAM_ShipDirection);
		SinLookup(a);
		c = a >= 0x80;
		RotateRight(a, c);
		byte tmpC = a;
		a += VarO(RAMO_VelocityY, PlayerIndex);
		Clamp(a, 0x91, 0x6F);
		VarO(RAMO_VelocityY, PlayerIndex+NewShot) = a;

		//xPosition
		a = tmp9;
		byte tmp8 = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmp9;
		c = false;
		Add(a, VarO(RAMO_PositionExactX, PlayerIndex), c);
		VarO(RAMO_PositionExactX, PlayerIndex+NewShot) = a;
		Add(tmp8, VarO(RAMO_PositionX, PlayerIndex), c);
		VarO(RAMO_PositionX, PlayerIndex+NewShot) = tmp8;

		//yPosition
		a = tmpC;
		byte tmpB = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmpC;
		c = false;
		Add(a, VarO(RAMO_PositionExactY, PlayerIndex), c);
		VarO(RAMO_PositionExactY, PlayerIndex+NewShot) = a;
		Add(tmpB, VarO(RAMO_PositionY, PlayerIndex), c);
		VarO(RAMO_PositionY, PlayerIndex+NewShot) = tmpB;*/
		//xPosition
		/*a = tmp9;
		byte tmp8 = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmp9;
		c = false;
		Add(a, LowByte(PositionX), c);
		LowByte(PositionX) = a;
		Add(tmp8, HighByte(PositionX), c);
		HighByte(PositionX) = tmp8;*/

		//yPosition
		/*		a = tmpC;
		byte tmpB = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmpC;
		c = false;
		Add(a, LowByte(PositionY), c);
		LowByte(PositionY) = a;
		Add(tmpB, HighByte(PositionY), c);
		HighByte(PositionY) = tmpB;*/
	}

	static bool PlayerPositionGoodForKI(word PositionX, word PositionY)
	{
		if(HyperSpaceTargetY != 0xffff)
			return Sq(int(PositionX)-int(HyperSpaceTargetX)) + Sq(int(PositionY)-int(HyperSpaceTargetY)) < Sq(500);
		else
			return ((PositionX+1000) & 0x1FFF) < 1000*2 &&
				   ((PositionY+1500) % 0x1800) < 1500*2;
	}

	bool WouldHyperSpaceSuccess(bool MustHaveGoodPosition)
	{
		if(	NumPlayers == 0 ||
			InvisibleTimer ||
			Objects[PlayerIndex].Status < 0 ||
			RandomSeedDistribution.GetNumSetBits() != 1)
			return false;

		int OldRandIndex = RandomSeedDistribution.GetFirstSetIndex();

		byte a = Rand() & 0x1F;
		if(a >= 0x1D)
			a = 0x1C;
		if(a < 3)
			a = 3;
		word PositionX = MakeWord(a, LowByte(Objects[PlayerIndex].PositionX));

		Rand(); Rand(); Rand(); Rand();

		a = Rand() & 0x1F;
		RandomSeedDistribution.ClearAll();
		RandomSeedDistribution.Set(OldRandIndex, true);
		if(a >= 0x18)
		{
			a &= 7;
			bool c = true;
			ShiftLeft(a, c);
			Add(a, 4, c);
			if(a >= NumAsteroids)//HyperSpace fehlgeschlagen
				return false;
		}
		if(a > 0x14)
			a = 0x14;
		if(a < 3)
			a = 3;
		word PositionY = MakeWord(a, LowByte(Objects[PlayerIndex].PositionY));
		if(MustHaveGoodPosition && !PlayerPositionGoodForKI(PositionX, PositionY))
			return false;
		return true;
	}

	void DoHyperSpace(byte Keys, std::stack<MovePosition>* pMovePositions)//sub_6E74
	{
		if(!(Keys & Key_Hyperspace) ||
			NumPlayers == 0 ||
			InvisibleTimer ||
			Objects[PlayerIndex].Status < 0)
			return;

		if(RandomSeedDistribution.GetNumSetBits() != 1)
		{
			//Wir werden gleich in den Hyperspace gehen, kennen aber den Seed noch nicht.
			ChooseRandomSeed(pMovePositions, MPT_DoHyperSpace);
		}


		Objects[PlayerIndex].Status = 0;
		Objects[PlayerIndex].VelocityX = 0;
		Objects[PlayerIndex].VelocityY = 0;
		InvisibleTimer = 0x30;

		byte a = Rand() & 0x1F;
		if(a >= 0x1D)
			a = 0x1C;
		if(a < 3)
			a = 3;
		HighByte(Objects[PlayerIndex].PositionX) = a;

		Rand(); Rand(); Rand(); Rand();

		a = Rand() & 0x1F;
		HyperSpaceStatus = 1;
		if(a >= 0x18)
		{
			a &= 7;
			bool c = true;
			ShiftLeft(a, c);
			Add(a, 4, c);
			if(a >= NumAsteroids)//HyperSpace fehlgeschlagen
				HyperSpaceStatus = -128;
		}
		if(a > 0x14)
			a = 0x14;
		if(a < 3)
			a = 3;
		HighByte(Objects[PlayerIndex].PositionY) = a;
	}

	void UpdateHyperspace(byte Keys)//sub_703F
	{
		if(NumPlayers == 0 ||
			Objects[PlayerIndex].Status < 0)
			return;
		if(InvisibleTimer == 0)
		{
			UpdateDirectionAndThrust(Keys);
			return;
		}
		if(--InvisibleTimer)
			return;
		//Noch nicht ordentlich in richtiges C umgewandelt:
		if(char(HyperSpaceStatus) < 0) goto loc_706F;
		if(HyperSpaceStatus) goto loc_7068;
		if(!CanShipAppear()) goto loc_7081;
		if(Objects[SaucerIndex].Status)
		{
			InvisibleTimer = 2;
			return;
		}
loc_7068:
		//Schiff taucht wieder auf
		Objects[PlayerIndex].Status = 1;
		goto loc_7081;
loc_706F:
		Objects[PlayerIndex].Status = -96;
		NumShips--;
		InvisibleTimer = 0x81;
loc_7081:
		HyperSpaceStatus = 0;
	}

	bool CanShipAppear()
	{
		for(int i = SaucerIndex; i >= 0; i--)
		{
			if(Objects[i].Status == 0)
				continue;

			byte dif = HighByte(Objects[i].PositionX)-HighByte(Objects[PlayerIndex].PositionX);
			if(dif < 0xFC && dif >= 4)
				continue;

			dif = HighByte(Objects[i].PositionY)-HighByte(Objects[PlayerIndex].PositionY);
			if(dif < 0xFC && dif >= 4)
				continue;

			InvisibleTimer++;
			return false;
		}
		return true;
	}

	void UpdateDirectionAndThrust(byte Keys)//loc_7086
	{
		if(Keys & Key_Left)
		{
			ShipDirection += RotationSpeed;
			MaxShipDirection += RotationSpeed;
		}
		else if(Keys & Key_Right)
		{
			ShipDirection -= RotationSpeed;
			MaxShipDirection -= RotationSpeed;
		}

		if(Timer & 1)
			return;
		if(Keys & Key_Thrust)
		{
			byte y = 0;
			byte a = ShipDirection;//a=0
			CosLookup(a);
			if(char(a) < 0)
				y--;
			a <<= 1;   //a=80/FE
			bool c = false;
			Add(a, AccX, c);//a=f9  c=1
			byte x = a;//x=77
			a = y;
			Add(a, Objects[PlayerIndex].VelocityX, c);//a=2
			sub7125(a, x);
			Objects[PlayerIndex].VelocityX = a;
			AccX = x;

			y = 0;
			a = ShipDirection;
			SinLookup(a);
			if(char(a) < 0)
				y--;
			a <<= 1;
			c = false;
			Add(a, AccY, c);
			x = a;
			a = y;
			Add(a, Objects[PlayerIndex].VelocityY, c);
			sub7125(a, x);
			Objects[PlayerIndex].VelocityY = a;
			AccY = x;
		}
		else
		{
			// KEY_THRUST nicht gedrckt:
			if(Objects[PlayerIndex].VelocityX | AccX)
			{
				byte a = (Objects[PlayerIndex].VelocityX << 1) ^ 0xFF;
				bool c = char(a) >= 0;
				byte x = c ? 0 : 0xFF;
				Add(a, AccX, c); // Wenn man beide Zeilen durch Add(AccX, a, c); ersetzt optimiert der Microsoft Compiler falsch...
				AccX = a;
				Add((byte&)Objects[PlayerIndex].VelocityX, x, c);
			}
			if(Objects[PlayerIndex].VelocityY | AccY)
			{
				byte a = (Objects[PlayerIndex].VelocityY << 1) ^ 0xFF;
				bool c = char(a) >= 0;
				byte x = c ? 0 : 0xFF;
				Add(a, AccY, c);
				AccY = a;
				Add((byte&)Objects[PlayerIndex].VelocityY, x, c);
			}

		/*	char a = Var(RAM_VelocityY)<<1;
			char x = 0xFF;
			a ^= 0xFF;
			bool c = false;
			if(a >= 0)
			{
				x++;
				c = true;
			}
			int sum = int(a)+int(Var(RAM_AccY))+c;
			bool overflow = (sum & 0xFF00) != 0;
			a = sum;
			Var(RAM_AccY) = a;
			a = x;
			a += Var(RAM_VelocityY) + overflow;
			Var(RAM_VelocityY) = a;*/
		}
	}

	void ResetAsteroids(std::stack<MovePosition>* pMovePositions)//sub_7168
	{
		int x = AsteroidMaxIndex;
		if(!NewLevelStartCountdown)
		{
			if(Objects[SaucerIndex].Status)
				return;

			if(RandomSeedDistribution.GetNumSetBits() != 1)
			{
				//Wir werden gleich neue Asteroiden erstellen, kennen den Seed aber noch nicht
				ChooseRandomSeed(pMovePositions, MPT_ResetAsteroids);
			}

			Objects[SaucerIndex].SetVelocity(0, 0);

			if(Level < 10)
				Level++;

			NumAsteroidsStart += 2;
			if(NumAsteroidsStart >= 0x0B)
				NumAsteroidsStart = 0x0B;
			NumAsteroids = NumAsteroidsStart;
			for(int i = 0; i < NumAsteroids; i++)
			{
				Objects[x].Status = (Rand()&0x18) | 0x04;

				//sub_7203
				{
					byte a = Rand() & 0x8F;
					if(char(a) < 0)
						a |= 0xF0;
					for(int i = 0; i < Objects[x].cX; i++)
					{
						Objects[x].VX[i] = a;
						ClampVelocity(Objects[x].VX[i]);
					}

					Rand(); Rand(); Rand();

					a = Rand() & 0x8F;
					if(char(a) < 0)
						a |= 0xF0;
					for(int i = 0; i < Objects[x].cY; i++)
					{
						Objects[x].VY[i] = a;
						ClampVelocity(Objects[x].VY[i]);
					}
				}

				byte a = Rand();
				bool c;
				ShiftRight(a, c);
				a &= 0x1F;
				if(c)
				{
					if(a >= 0x18)
						a &= 0x17;
					for(int i = 0; i < Objects[x].cY; i++)
						HighByte(Objects[x].PY[i]) = a;
					for(int i = 0; i < Objects[x].cX; i++)
						Objects[x].PX[i] = 0;
				}
				else
				{
					for(int i = 0; i < Objects[x].cX; i++)
						HighByte(Objects[x].PX[i]) = a;
					for(int i = 0; i < Objects[x].cY; i++)
						Objects[x].PY[i] = 0;
				}
				Objects[x].RemoveEqualities();
				x--;
			}
			SaucerCountdown = 0x7F;
			//Var(RAM_2FC) = 0x30;
		}
		
		while(x >= AsteroidMinIndex)
			Objects[x--].Status = 0;
		
		CreateObjectsState(-1, -1);
	}

	void ResetPlayerPosition()//sub_71E8
	{
		Objects[PlayerIndex].PositionX = 0x1060;
		Objects[PlayerIndex].PositionY = 0x0C60;

		Objects[PlayerIndex].VelocityX = 0;
		Objects[PlayerIndex].VelocityY = 0;

		Objects[PlayerIndex].SetFixed();
	}

	static void CosLookup(byte& a)//sub_77D2
	{
		a += 0x40;
		SinLookup(a);
	}

	static void SinLookup(byte& a)//sub_77D5
	{
		const byte Table[0x41] =//0x57B9
		{
			0x00, 0x03, 0x06, 0x09, 0x0c, 0x10, 0x13, 0x16, 0x19, 0x1c, 0x1f, 0x22, 0x25, 0x28,
			0x2b, 0x2e, 0x31, 0x33, 0x36, 0x39, 0x3c, 0x3f, 0x41, 0x44, 0x47, 0x49, 0x4c, 0x4e,
			0x51, 0x53, 0x55, 0x58, 0x5a, 0x5c, 0x5e, 0x60, 0x62, 0x64, 0x66, 0x68, 0x6a, 0x6b,
			0x6d, 0x6f, 0x70, 0x71, 0x73, 0x74, 0x75, 0x76, 0x78, 0x79, 0x7a, 0x7a, 0x7b, 0x7c,
			0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f
		};
		bool inv = false;
		if(char(a) < 0)
		{
			inv = true;
			a &= 0x7F;
		}
		if(a >= 0x41)
			a = (a^0x7F) + 1;
		a = Table[a];
		if(inv)
			a = (a^0xFF) + 1;
	}

	void sub7125(byte& a, byte& x)
	{
		if(char(a) >= 0)
		{
			if(a >= 0x40)
			{
				x = 0xFF;
				a = 0x3F;
			}
		}
		else
		{
			if(a < 0xC0)
			{
				x = 1;
				a = 0xC0;
			}
		}
	}

	//Erzeugt zwei kleine Asteroiden
	void SplitAsteroid(int CollisionCauser, int Asteroid, std::stack<MovePosition>* pMovePositions)//sub_75EC
	{
		AsteroidDestroyedTimer = 0x50;
		//byte a = Objects[y].Status;
		//a &= 0x78;
		//byte tmp_e = a;
		byte NewStatus = (Objects[Asteroid].Status&7) >> 1;

		if(RandomSeedDistribution.GetNumSetBits() != 1 &&
			NewStatus)
		{
			//Wir werden gleich neue Asteroiden erstellen, kennen den Seed aber noch nicht
			ChooseRandomSeed(pMovePositions, MPT_ObjectCollision);
			pMovePositions->top().CollisionCauser = CollisionCauser;
			pMovePositions->top().Target = Asteroid;
		}

		if(NumPlayers && (CollisionCauser == PlayerIndex || CollisionCauser >= PlayerShotMinIndex))
		{
			//Der Schuss ist vom Spieler oder der Spieler kollidiert selber mit dem Asteroid -> Punkte
			if(NewStatus == 0)
				AddScore(100);
			else if(NewStatus == 1)
				AddScore(50);
			else if(NewStatus == 2)
				AddScore(20);
			else
				assert(0);
		}
		if(!NewStatus)
			return;
		Objects[Asteroid].Status = (NewStatus | (Objects[Asteroid].Status&0x78));


		CreateSmallAsteroid(Asteroid, true);
		CreateSmallAsteroid(Asteroid, false);
	}

	void CreateSmallAsteroid(int BaseAsteroid, bool Type)
	{
		//sub_745A
		int NewAsteroid = AsteroidMaxIndex;
		while(Objects[NewAsteroid].Status)
			if(NewAsteroid-- == AsteroidMinIndex)
			{
#ifdef PRINT_DEBUG_INFO
				printf("Keine Slots mehr fuer neuen Asteroiden uebrig!!\n");
#endif
				return;
			}
		NumAsteroids++;

		//sub_6A9D
		Objects[NewAsteroid] = Objects[BaseAsteroid];
		Objects[NewAsteroid].Status = (Objects[BaseAsteroid].Status&7) | (Rand()&0x18);

		//sub_7203
		byte a = Rand() & 0x8F;
		if(char(a) < 0)
			a |= 0xF0;
		for(int i = 0; i < Objects[NewAsteroid].cX; i++)
		{
			Objects[NewAsteroid].VX[i] = a + Objects[BaseAsteroid].VX[i];
			ClampVelocity(Objects[NewAsteroid].VX[i]);
		}

		Rand(); Rand(); Rand();

		a = Rand() & 0x8F;
		if(char(a) < 0)
			a |= 0xF0;
		for(int i = 0; i < Objects[NewAsteroid].cY; i++)
		{
			Objects[NewAsteroid].VY[i] = a + Objects[BaseAsteroid].VY[i];
			ClampVelocity(Objects[NewAsteroid].VY[i]);
		}

		if(Type)
			for(int i = 0; i < Objects[NewAsteroid].cX; i++)
				LowByte(Objects[NewAsteroid].PX[i]) ^= (Objects[NewAsteroid].VX[i] & 0x1F) << 1;
		else
			for(int i = 0; i < Objects[NewAsteroid].cY; i++)
				LowByte(Objects[NewAsteroid].PY[i]) ^= (Objects[NewAsteroid].VY[i] & 0x1F) << 1;
		Objects[NewAsteroid].RemoveEqualities();

	}

	void ClampVelocity(char& a)//sub_7233
	{
		if(a < 0)
		{
			if(a < -31)
				a = -31;
			else if(a > -6)
				a = -6;
		}
		else
		{
			if(a < 6)
				a = 6;
			else if(a > 31)
				a = 31;
		}
	}

	void AddScore(int ToAdd)//sub_7397
	{
		if(Score/10000 != (Score+ToAdd)/10000)
			NumShips++;
		Score += ToAdd;
	}

	//Prft, ob das Objekt CollisionCauser mit irgendwas kollidiert und fhrt
	//entsprechende Aktionen aus
	void CheckCollisions(byte CollisionCauser, int FixedTarget, std::stack<MovePosition>* pMovePositions)//sub_69F0
	{
		if(Objects[CollisionCauser].Status <= 0 && FixedTarget == -1)
			return;
		int y = SaucerIndex;
		if(CollisionCauser < PlayerShotMinIndex)//CollisionCauser ist kein Schuss vom Spieler
			y--;// kann also nicht mit dem UFO kollidieren
		if(CollisionCauser == PlayerIndex)
			y--;//Spieler kann nicht mit sich selbst kollidieren
		if(FixedTarget != -1)
			y = FixedTarget;
		do
		{
			if(Objects[y].Status <= 0)
			{
				assert(y != FixedTarget);
				continue;
			}

			if(FixedTarget != y)
			{
				int cCollisionCombinations = 0, cNoCollisionCombinations = 0;
				Object ColNewCollisionCauser(Objects[CollisionCauser].Status);
				Object ColNewTarget(Objects[y].Status);
				Object NoColNewCollisionCauser(Objects[CollisionCauser].Status);
				Object NoColNewTarget(Objects[y].Status);

				for(int ax = 0; ax < Objects[CollisionCauser].cX; ax++)
				for(int ay = 0; ay < Objects[CollisionCauser].cY; ay++)
				for(int bx = 0; bx < Objects[y].cX; bx++)
				for(int by = 0; by < Objects[y].cY; by++)
				{
					bool Near = AreObjectsNear(CollisionCauser,
											   Objects[CollisionCauser].PX[ax],
											   Objects[CollisionCauser].PY[ay],
											   Objects[CollisionCauser].Status,
											   y,
											   Objects[y].PX[bx],
											   Objects[y].PY[by],
											   Objects[y].Status);
					if(Near)
						cCollisionCombinations++;
					else
						cNoCollisionCombinations++;
					if(Near)
					{
						ColNewCollisionCauser.AddLocation(Objects[CollisionCauser].PX[ax], Objects[CollisionCauser].PY[ay],
														  Objects[CollisionCauser].VX[ax], Objects[CollisionCauser].VY[ay]);
						ColNewTarget.AddLocation(Objects[y].PX[bx], Objects[y].PY[by],
												 Objects[y].VX[bx], Objects[y].VY[by]);
					}
					else
					{
						NoColNewCollisionCauser.AddLocation(Objects[CollisionCauser].PX[ax], Objects[CollisionCauser].PY[ay],
															Objects[CollisionCauser].VX[ax], Objects[CollisionCauser].VY[ay]);
						NoColNewTarget.AddLocation(Objects[y].PX[bx], Objects[y].PY[by],
												   Objects[y].VX[bx], Objects[y].VY[by]);
					}
				}
				
				if(cNoCollisionCombinations && cCollisionCombinations == 0)
				{
					//Es sind eine oder mehrere Kombinationen, die alle nicht kollidieren
					//->Kein Entscheidungsproblem
					continue;
				}
				else if(cNoCollisionCombinations == 0 && cCollisionCombinations)
				{
					//Es gibt nur Kollisionen
					//->Kein Entscheidungsproblem
				}
				else if(cNoCollisionCombinations && cCollisionCombinations)
				{
					assert(ColNewCollisionCauser.IsValid());
					assert(ColNewTarget.IsValid());
					assert(NoColNewCollisionCauser.IsValid());
					assert(NoColNewTarget.IsValid());

					MovePosition NewMovePosition(MPT_ObjectCollision, true);
					NewMovePosition.CollisionCauser = CollisionCauser;
					NewMovePosition.Target = y;
					NewMovePosition.Game = *this;

					NewMovePosition.Game.Objects[CollisionCauser] = ColNewCollisionCauser;
					NewMovePosition.Game.Objects[y] = ColNewTarget;
					pMovePositions->push(NewMovePosition);

					Objects[CollisionCauser] = NoColNewCollisionCauser;
					Objects[y] = NoColNewTarget;

					printf("Entscheide fuer keine Kollisionen um %i  No: %i %i\n", CurrentTime, cNoCollisionCombinations, cCollisionCombinations);
					continue;//Keine Kollision
				}
				else
					assert(0);
			}

			//Wir kollidieren!

			if(OnCollision(CollisionCauser, y, pMovePositions))
				CreateObjectsState(CollisionCauser, y);
			return;//Nur eine Kollision pro Objekt
	
		}while(y--);
	}

	//Prft, ob die beiden Objekte kollidieren
	static bool AreObjectsNear(byte i, word iPositionX, word iPositionY, byte iStatus,
							   byte j, word jPositionX, word jPositionY, byte jStatus)
	{//Ship/Saucer/Shots mssen in i sein, Asteroiden in j
		byte tmp8 = (jPositionX - iPositionX) >> 1;
		byte a = ((jPositionX - iPositionX) >> 9) << 1;
		if(a)
		{
			if(char(a) >= 0)
				return false;
			a ^= 0xFE;
			if(a)
				return false;
			tmp8 ^= 0xFF;
		}

		byte tmp9 = (jPositionY - iPositionY) >> 1;
		a = ((jPositionY - iPositionY) >> 9) << 1;
	
		if(a)
		{
			if(char(a) >= 0)
				return false;
			a ^= 0xFE;
			if(a)
				return false;
			tmp9 ^= 0xFF;
		}

		if(jStatus & 4)
			a = 0x84;
		else if(jStatus & 2)
			a = 0x48;
		else
			a = 0x2A;

		if(i == PlayerIndex)
			a += 0x1C;
		else if(i == SaucerIndex)
		{
			a += 0x13;
			if(iStatus == 2)
				a += 0x12;
		}
		if(a < tmp8 || a < tmp9)
			return false;

		byte tmp = a;
		a >>= 1;
		bool c = false;
		Add(a, tmp, c);
		tmp = a;
		a = tmp9;
		Add(a, tmp8, c);
		if(c) return false;
		if(a >= tmp) return false;
		return true;
	}

	//Wenn AreObjectsNear fr zwei Objekte true zurckgibt, wird diese Methode aufgerufen.
	//Gibt zurck, ob sich die Asteroiden oder das UFO gendert haben
	bool OnCollision(int CollisionCauser, int& y, std::stack<MovePosition>* pMovePositions)//sub_6B0F
	{
		bool HaveToDestroyShip = false;//Das Schiff darf nicht vor dem Aufruf von SplitAsteroid zerstrt werden,
		//da der Zustand durch das Abziehen des Lebens gendert wird und SplitAsteroid
		//den Zustand per MovePosition wiederherstellen kann.
		if(CollisionCauser != SaucerIndex)
		{
			if(CollisionCauser != PlayerIndex)
			{
				// CollisionCauser ist ein Schuss
				Objects[CollisionCauser].Status = 0; //Schuss lschen
				if(y == PlayerIndex)
					DestroyShip();
				else if(y > PlayerIndex)
					DestroySaucer();
				else
					SplitAsteroid(CollisionCauser, y, pMovePositions);
				Objects[y].Status = -96;
				Objects[y].SetVelocity(0, 0);
				return y != PlayerIndex;
			}
			HaveToDestroyShip = true;
			CollisionCauser = PlayerIndex;
		}
		else if(y == PlayerIndex)
		{
			//Schiff kollidiert mit UFO
			CollisionCauser = PlayerIndex;
			y = SaucerIndex;
			HaveToDestroyShip = true;
		}
		Objects[CollisionCauser].Status = -96;
		Objects[CollisionCauser].SetVelocity(0, 0);
		if(y < PlayerIndex)
		{
			SplitAsteroid(CollisionCauser, y, pMovePositions);
		}
		else
		{
			assert(y == SaucerIndex);
			DestroySaucer();
		}
		Objects[y].Status = -96;
		Objects[y].SetVelocity(0, 0);
		if(HaveToDestroyShip)
			DestroyShip();
		return true;
	}

	void DestroyShip()
	{
		InvisibleTimer = 0x81;
		NumShips--;
	}

	void UpdateSaucer(std::stack<MovePosition>* pMovePositions)//sub_6B93
	{
		assert(TimerBitsKnown >= 2);

		if(Timer & 3 || Objects[SaucerIndex].Status < 0)
			return;

		if(Objects[SaucerIndex].Status == 0)
		{
			if(NumPlayers && Objects[PlayerIndex].Status <= 0)
				return;

			if(RandomSeedDistribution.GetNumSetBits() != 1 &&
				SaucerCountdown == 1 &&
				(AsteroidDestroyedTimer <= 1 || (NumAsteroids != 0 && NumAsteroids < Level)))
			{
				//Wir werden gleich ein UFO erstellen, kennen aber den Seed noch nicht.
				ChooseRandomSeed(pMovePositions, MPT_UpdateSaucer);
			}

			if(AsteroidDestroyedTimer)
				AsteroidDestroyedTimer--;
			if(--SaucerCountdown)
				return;
			SaucerCountdown = 0x12;
			if(AsteroidDestroyedTimer && (NumAsteroids == 0 || NumAsteroids >= Level))
				return;

			//Saucer erstellen
			if(SaucerCountdownStart >= 38)
				SaucerCountdownStart -= 6;
			byte RandomSeed2;
			byte a = Rand(&RandomSeed2);

			//Setze y Position (y Geschwindigkeit wird nicht angerhrt)
			/*			bool c;
			ShiftRight(a, c);
			RotateRight(LowByte(Objects[SaucerIndex].PositionY), c);
			ShiftRight(a, c);
			RotateRight(LowByte(Objects[SaucerIndex].PositionY), c);
			ShiftRight(a, c);
			RotateRight(LowByte(Objects[SaucerIndex].PositionY), c);*/

			for(int i = 0; i < Objects[SaucerIndex].cY; i++)
			{
				Objects[SaucerIndex].PY[i] = ((Objects[SaucerIndex].PY[i]>>3) & 0x1F) | ((a&7) << 5);
				HighByte(Objects[SaucerIndex].PY[i]) = a;
				HighByte(Objects[SaucerIndex].PY[i]) >>= 3;
				if(HighByte(Objects[SaucerIndex].PY[i]) >= 0x18)
					HighByte(Objects[SaucerIndex].PY[i]) &= 0x17;
			}

			//x Komponente
			Objects[SaucerIndex].PositionX = RandomSeed2 & 0x40 ? 0 : 0x1FFF;
			Objects[SaucerIndex].VelocityX = RandomSeed2 & 0x40 ? 16 : -16;
			Objects[SaucerIndex].cX = 1;

			//Status
			Objects[SaucerIndex].Status = 2;
			if(char(SaucerCountdownStart) >= 0 && (Score%100000 >= 30000 || (SaucerCountdownStart>>1) <  Rand()))
				Objects[SaucerIndex].Status = 1;

			Objects[SaucerIndex].RemoveEqualities();

			CreateObjectsState(MaxInt, -1);
			return;
		}
		//UFO lebt:

		if(SaucerCountdown == 1 &&
			(!NumPlayers || !InvisibleTimer))
		{
			//Wir werden gleich schieen
			if(RandomSeedDistribution.GetNumSetBits() != 1)
			{
				//Wir kennen den Seed noch nicht.
				ChooseRandomSeed(pMovePositions, MPT_UpdateSaucer);
			}
			if(!Objects[SaucerIndex].IsFixed())
			{
				//Die Berechnung des Schusses setzt voraus, dass die Position genau bekannt ist.
				//Man knnte die Berechnung auch so gestalten, dass sie mit der Ungenauigkeit klar
				//kommt, das wre aber sehr aufwendig und der Geschwindigkeitsvorteil wre eher klein.
				assert(Objects[SaucerIndex].cX == 1);

				MovePosition NewMovePosition(MPT_UpdateSaucer, false);
				NewMovePosition.Game = *this;
				NewMovePosition.Game.Objects[SaucerIndex].RemoveY(Objects[SaucerIndex].cY-1);
				pMovePositions->push(NewMovePosition);

				Objects[SaucerIndex].Decide(0, Objects[SaucerIndex].cY-1);
			}
		}

		//Richtung hin und wieder ndern
		if(TimerBitsKnown < 7)
		{
			if((Timer & (0xFF >> (8-TimerBitsKnown))) == 0)//Sind alle bekannten Bits 0?
			{
				//Wenn unser Timer falsch geht knnte das UFO jetzt die Richtung ndern
				MovePosition NewMovePosition(MPT_UpdateSaucer, false);
				NewMovePosition.Game = *this;
				NewMovePosition.Game.Timer = 0;
				NewMovePosition.Game.TimerBitsKnown = 7;
				pMovePositions->push(NewMovePosition);
				printf("Saucer knnte jetzt Richtung ndern. um %i\n", CurrentTime);
			}
		}
		else if(byte(Timer << 1) == 0)
		{
			if(RandomSeedDistribution.GetNumSetBits() != 1)
			{
				//Wir werden gleich die Richtung ndern, kennen aber den Seed noch nicht.
				ChooseRandomSeed(pMovePositions, MPT_UpdateSaucer);
			}

			char OldVelocityY = Objects[SaucerIndex].VelocityY;
			const char DirectionTable[] = {-16, 0, 0, 16};
			Objects[SaucerIndex].SetVelocityY(DirectionTable[Rand()&3]);

			if(OldVelocityY != Objects[SaucerIndex].VelocityY)
				CreateObjectsState(MaxInt, -1);
		}

		if(NumPlayers && InvisibleTimer)
			return;

		if(--SaucerCountdown)
			return;

		//Wir feuern mal einen Schuss
		SaucerCountdown = 0x0A;

		byte ShotDirection;
		if(Objects[SaucerIndex].Status != 2)
		{
			byte a = Objects[SaucerIndex].VelocityX;
			bool c = a >= 0x80;
			RotateRight(a, c);
			byte tmpC = a;
			a = LowByte(Objects[PlayerIndex].PositionX);
			c = true;
			Subtract(a, LowByte(Objects[SaucerIndex].PositionX), c);
			byte tmpB = a;
			a = HighByte(Objects[PlayerIndex].PositionX);
			Subtract(a, HighByte(Objects[SaucerIndex].PositionX), c);
			ShiftLeft(tmpB, c);
			RotateLeft(a, c);
			ShiftLeft(tmpB, c);
			RotateLeft(a, c);
			c = true;
			Subtract(a, tmpC, c);
			byte x = a;

			a = Objects[SaucerIndex].VelocityY;
			c = a >= 0x80;
			RotateRight(a, c);
			tmpC = a;
			a = LowByte(Objects[PlayerIndex].PositionY);
			c = true;
			Subtract(a, LowByte(Objects[SaucerIndex].PositionY), c);
			tmpB = a;
			a = HighByte(Objects[PlayerIndex].PositionY);
			Subtract(a, HighByte(Objects[SaucerIndex].PositionY), c);
			ShiftLeft(tmpB, c);
			RotateLeft(a, c);
			ShiftLeft(tmpB, c);
			RotateLeft(a, c);
			c = true;
			Subtract(a, tmpC, c);
			byte y = a;

			ShotDirection = loc_76F0(x, y);

			a = Rand();
			c = Score%100000 >= 35000;
			a &= c ? 0x87 : 0x8F;
			if(char(a) < 0)
				a |= c ? 0x78 : 0x70;
			Add(ShotDirection, a, c);
		}
		else
			ShotDirection = Rand();

		int NewShot = SaucerShotMaxIndex;
		while(Objects[NewShot].Status)
			if(NewShot-- == SaucerShotMinIndex)
				return;

		assert(Objects[SaucerIndex].IsFixed());
		Objects[NewShot] = Objects[SaucerIndex];
		Objects[NewShot].Status = ShotLifetime/4;

		ShootLocationFromAngle(ShotDirection, Objects[NewShot].PositionX, Objects[NewShot].PositionY, Objects[NewShot].VelocityX, Objects[NewShot].VelocityY);
	}

	//Die folgenden Methoden bestimmen, in welche Richtung das kleine UFO schieen soll
	//Mir sind keine sinnvollen Namen eingefallen und habe auch keine groe Lust, das
	//in eine Methode zusammenzufassen..
	byte loc_76F0(byte x, byte y)
	{
		byte a = y;
		if(char(a) < 0)
		{
			a = (a ^ 0xFF) + 1;
			a = loc_76FC(a, x);
			a = (a ^ 0xFF) + 1;
			return a;
		}
		else
			return loc_76FC(a, x);
	}
	byte loc_76FC(byte a, byte x)
	{
		byte y = a;
		a = x;
		if(char(a) < 0)
		{
			a = (a ^ 0xFF) + 1;
			a = sub_770E(a, y);
			a ^= 0x80;
			a = (a ^ 0xFF) + 1;
			return a;
		}
		else
			return sub_770E(a, y);
	}
	byte sub_770E(byte a, byte y)
	{
		byte tmpC = a;
		a = y;	
		if(a == tmpC)
			return 0x20;
		if(a >= tmpC)
		{
			y = tmpC;
			tmpC = a;
			a = y;
			a = sub_7728(a, tmpC, true);
			a -= 0x40;
			a = (a ^ 0xFF) + 1;
			return a;
		}
		else
			return sub_7728(a, tmpC, false);
	}
	byte sub_7728(byte a, byte tmpC, bool c)
	{
		byte tmpB = 0;
		for(int i = 0; i < 4; i++)
		{
			RotateLeft(tmpB, c);
			RotateLeft(a, c);
			c = a >= tmpC;
			if(c)
				Subtract(a, tmpC, c);
		}
		RotateLeft(tmpB, c);

		const byte _772F[0x10] = {0x00, 0x02, 0x05, 0x07, 0x0A, 0x0C, 0x0F, 0x11, 0x13, 0x15, 0x17, 0x19, 0x1A, 0x1C, 0x1D, 0x1F};
		return _772F[tmpB & 0x0F];
	}

	void DestroySaucer()//loc_6B73
	{
		SaucerCountdown = SaucerCountdownStart;
		if(NumPlayers)
		{
			if(Objects[SaucerIndex].Status == 1)
				AddScore(1000);
			else
				AddScore(200);
		}
	}

	static int GetRandomSeedIndex(byte RandomSeed1, byte RandomSeed2)
	{
		for(int i = 0; i < NumSeedCombinations; i++)
			if(RandomSeeds[i][0] == RandomSeed1 && RandomSeeds[i][1] == RandomSeed2)
			{
				return i;
			}
		assert(0);
		return 0;
	}

	void ChooseRandomSeed(std::stack<MovePosition>* pMovePositions, MovePositionType MPT)
	{
		assert(RandomSeedDistribution.GetNumSetBits() > 1);
		int FirstSetIndex = RandomSeedDistribution.GetFirstSetIndex();
		assert(FirstSetIndex != -1);

		MovePosition NewMovePosition(MPT, false);
		NewMovePosition.Game = *this;
		NewMovePosition.Game.RandomSeedDistribution.Set(FirstSetIndex, false);
		pMovePositions->push(NewMovePosition);

		RandomSeedDistribution.ClearAll();
		RandomSeedDistribution.Set(FirstSetIndex, true);
	}

	byte Rand(byte* pRandomSeed2 = 0)
	{
		assert(RandomSeedDistribution.GetNumSetBits() == 1);
		RandomSeedDistribution.RotateRight();
		int Index = RandomSeedDistribution.GetFirstSetIndex();
		if(pRandomSeed2)
			*pRandomSeed2 = RandomSeeds[Index][1];
		return RandomSeeds[Index][0];
	
		/*bool carry = false;
		ShiftLeft(RandomSeed1, carry);
		if(char(RotateLeft(RandomSeed2, carry)) < 0)
			RandomSeed1++;
		if(RandomSeed1 & 2)
			RandomSeed1 ^= 1;
		if(RandomSeed1 == 0 && RandomSeed2 == 0)
			RandomSeed1++;
		return RandomSeed1;*/
	}

	//Der KI bescheid sagen, dass sich an den Objekten etwas gendert hat
	void CreateObjectsState(int CollisionCauser, int DestroyedObject) const
	{
		if(!pObjectsStates)
			return;

		if(!pObjectsStates->empty())
		{
			pObjectsStates->back().ValidUntilTime = CurrentTime;
			pObjectsStates->back().CollisionCauser = CollisionCauser;
		}

		ObjectsState NewObjectsState;
		NewObjectsState.StartTime = CurrentTime+1;
		NewObjectsState.ValidUntilTime = MaxInt;
		NewObjectsState.CollisionCauser = -1;
		NewObjectsState.DestroyedObject = DestroyedObject;
		NewObjectsState.CountExtraSlots = GetCountExtraSlots();
		memcpy(NewObjectsState.Objects, Objects, sizeof(Objects));
		for(int i = 0; i < NumObjects; i++)
			assert(i != DestroyedObject || Objects[i].Status <= 0);

		pObjectsStates->push_back(NewObjectsState);
	}

	//Setzt den Zustand genau fest. Sodass also die Positionen der Objekte genau sind,
	//der Randomseed bekannt ist u.s.w. Die Entscheidungen sind willkrlich, der Zustand
	//wird also wahrscheinlich nicht mehr synchron mit dem Emulator sein.
	void SetFixed()
	{
		TimerBitsKnown = 7;
		if(RandomSeedDistribution.GetNumSetBits() != 1)
		{
			int Index = RandomSeedDistribution.GetFirstSetIndex();
			RandomSeedDistribution.ClearAll();
			RandomSeedDistribution.Set(Index, true);
		}
		MaxShipDirection = ShipDirection;
		for(int i = 0; i < NumObjects; i++)
			Objects[i].SetFixed();
	}

	bool CanBeOredWith(const GameState& rhs) const
	{
		assert(CurrentTime == rhs.CurrentTime &&
			   NumPlayers == rhs.NumPlayers);
		return 	Score == rhs.Score &&
				NumShips == rhs.NumShips &&
				(Timer&3) == (rhs.Timer&3) &&
				HyperSpaceStatus == rhs.HyperSpaceStatus &&
				FireHyperspaceToggle == rhs.FireHyperspaceToggle &&
				AccX == rhs.AccX &&
				AccY == rhs.AccY &&
				NumAsteroids == rhs.NumAsteroids &&
				NumAsteroidsStart == rhs.NumAsteroidsStart &&
				SaucerCountdown == rhs.SaucerCountdown &&
				SaucerCountdownStart == rhs.SaucerCountdownStart &&
				AsteroidDestroyedTimer == rhs.AsteroidDestroyedTimer &&
				InvisibleTimer == rhs.InvisibleTimer &&
				NewLevelStartCountdown == rhs.NewLevelStartCountdown &&
				Level == rhs.Level;
	}

	//Vereint zwei Zustnde, sodass this alle Mglichkeiten hat, die auch rhs hat.
	//Das funktioniert natrlich nur fr die Variablen, die "unscharf" sein knnen,
	//wie zum Beispiel der Randomseed oder der Timer.
	//Wir knnen aber sicher sein, dass Variablen wie zB der Score immer gleich sind,
	//weil diese direkt aus dem VRam ablesbar sind und deshalb die Spielzustnde,
	//die zB mit dem Score abweichen, nicht durch den Check des VRams kommen.
	//Es werden also nur Spiele vereint, die den gleichen VRam Output haben.
	void operator |=(const GameState& rhs)
	{
		assert(CanBeOredWith(rhs));
		//Zwei Bereiche in einem Ring zu vereinen ist echt schwierig. Ich hoffe mal, dass das hier immer funktioniert:
		byte Min1 = Min(ShipDirection, rhs.ShipDirection);
		byte Max1 = Max(MaxShipDirection, rhs.MaxShipDirection);
		byte Min2 = Min(ShipDirection+128, rhs.ShipDirection+128);
		byte Max2 = Max(MaxShipDirection+128, rhs.MaxShipDirection+128);
		if(Max1 - Min1 < Max2 - Min2)
		{
			ShipDirection = Min1;
			MaxShipDirection = Max1;
		}
		else
		{
			ShipDirection = Min2-128;
			MaxShipDirection = Max2-128;
		}

		TimerBitsKnown = Min(TimerBitsKnown, rhs.TimerBitsKnown);

		while(byte(Timer << (8-TimerBitsKnown)) != byte(rhs.Timer << (8-TimerBitsKnown)))
			TimerBitsKnown--;
		assert(TimerBitsKnown >= 2);

		RandomSeedDistribution |= rhs.RandomSeedDistribution;

		for(int i = 0; i < NumObjects; i++)
		{
			if(i >= AsteroidMinIndex && i <= AsteroidMaxIndex)
			{
				assert((Objects[i].Status&7) == (rhs.Objects[i].Status&7));
				//Es kann vorkommen, dass bei einer Asteroidenexplosion bei verschiedenen
				//Seeds die fast gleichen kleinen Asteroiden herauskommen, diese aber unterschiedliche
				//Anzeigetypen haben. Wir markieren den Fall einfach im 7. Bit (unbenutzt).
				if(Objects[i].Status>>3 != rhs.Objects[i].Status>>3)
					Objects[i].Status |= 0x40;
			}
			else
				assert(Objects[i].Status == rhs.Objects[i].Status);
			if(Objects[i].Status == 0)
				continue;
			for(int j = 0; j < rhs.Objects[i].cX; j++)
				Objects[i].AddLocationX(rhs.Objects[i].PX[j], rhs.Objects[i].VX[j]);
			for(int j = 0; j < rhs.Objects[i].cY; j++)
				Objects[i].AddLocationY(rhs.Objects[i].PY[j], rhs.Objects[i].VY[j]);
		}
	}

	bool NextObject_(int& Object, int MinIndex, int MaxIndex, bool& VRamInvalid)
	{
		for(Object--; Object >= MinIndex; Object--)
		{
			if(Objects[Object].Status)
			{
				if(Object > MaxIndex)
				{
					VRamInvalid = true;
					return true;
				}
				return false;
			}
		}
		VRamInvalid = true;
		return true;
	}

#define NextObject(a, b, c) do{ if(NextObject_(a, b, c, VRamInvalid)) return true; }while(false)

	//Prft, ob der Inhalt des Vektorrams mit diesem Spielzustand kompatibel ist
	//und grenzt dieses Zustand auch ein, sodass alle Variablen so genau wie mglich sind.
	bool CheckVRam(int* pVRamScore, int* pVRamNumShips, const word* VRam, bool& VRamInvalid, std::stack<MovePosition>& MovePositions)
	{
		assert(!VRamInvalid);
		assert(VRam != 0);
		int NumShips = 0;

		VRamAssert(VRam[0] == 0xe001 || VRam[0] == 0xe201, VRamInvalid);

		//Wir zhlen, wie oft eine Zahl gezeichnet wird
		bool NumberRead = false;
		int Number = 0;
		int CountNumbers = 0;

		int vx, vy, vs;//Wo sich der Strahl gerade befindet und welche Skalierung eingestellt ist

		int v1x = 0, v1y = 0;
		int shipdetect = 0;

		int Object = NumObjects;//Welches Objekt gerade gezeichnet wird

		//Ob wir im Men sind und nicht steuern knnen
		bool Preparing = false;

#ifdef DETECT_START_FOR_TIMERBITS
		//Wir prfen, ob Start angezeigt wird
		int StartCounter = 0;
		bool StartPrinted = false;
#endif

		if(NumPlayers == 0)
		{
			Object = AsteroidMaxIndex+1;

			for(int i = 0; i < NumObjects; i++)
				Objects[i].Status = 0;
		}


		for(int pc = 1; pc < 512;)
		{
			int op = VRam[pc] >> 12;
			int AsteroidType = 0;
			switch(op)
			{
			case 0xa://LABS (Strahl positionieren)
				vy = VRam[pc] & 0x3ff;
				vx = VRam[pc+1] & 0x3ff;
				vs = VRam[pc+1] >> 12;
				if(NumberRead)
				{
					if(CountNumbers++ == 0 && pVRamScore)
						*pVRamScore = Number;
					Number = 0;
				}
				break;
			case 0xb://H (Programmende)
			case 0xd://RTSL
			case 0xe://JMPL
				pc = 512;//Schleife beenden
				break;
			case 0xc://JSRL (Subroutine aufrufen)
				switch(VRam[pc] & 0x0FFF)//Welche Adresse springen wir an?
				{
				//Explosion
				case 0x880:
				case 0x896:
				case 0x8B5:
				case 0x8D0:
					if(NumPlayers)
					{
						if(Object > PlayerIndex && Objects[PlayerIndex].Status < 0 &&
							!(Object > SaucerIndex && Objects[SaucerIndex].Status < 0))
							NextObject(Object, PlayerIndex, PlayerIndex);//Die Schiffsexplosion fragen wir nicht ab (zu kompliziert und nutzlos)
						NextObject(Object, AsteroidMinIndex, SaucerIndex);
						VRamAssert(Objects[Object].Status < 0, VRamInvalid);
						if(Objects[Object].SetVRamLocation(vx, vy, VRamInvalid))
							return true;
					}
					break;

				//Asteroide (4 Anzeigetypen)
				case 0x91a: AsteroidType++;
				case 0x90d: AsteroidType++;
				case 0x8ff: AsteroidType++;
				case 0x8f3:
					if(NumPlayers)
					{
						if(Object > PlayerIndex && Objects[PlayerIndex].Status < 0)
							NextObject(Object, PlayerIndex, PlayerIndex);//Die Schiffsexplosion fragen wir nicht ab (zu kompliziert und nutzlos)
						NextObject(Object, AsteroidMinIndex, AsteroidMaxIndex);
						if(vs == 0)//gro
							VRamAssert((Objects[Object].Status & 0x04) != 0, VRamInvalid);
						else if(vs == 15)//mittel
							VRamAssert((Objects[Object].Status & 0x02) != 0, VRamInvalid);
						else if(vs == 14)//klein
							VRamAssert((Objects[Object].Status & 0x01) != 0, VRamInvalid);
						else
							VRamAssert(0, VRamInvalid);
						VRamAssert(Objects[Object].Status>>3 == AsteroidType || (Objects[Object].Status&0x40) != 0, VRamInvalid);
						if(Objects[Object].SetVRamLocation(vx, vy, VRamInvalid))
							return true;
					}
					else
					{
						Object--;
						VRamAssert(Object >= AsteroidMinIndex && Object <= AsteroidMaxIndex, VRamInvalid);
						if(vs == 0)//gro
							Objects[Object].Status = 0x04;
						else if(vs == 15)//mittel
							Objects[Object].Status = 0x02;
						else if(vs == 14)//klein
							Objects[Object].Status = 0x01;
						else
							VRamAssert(0, VRamInvalid);
						Objects[Object].Status |= AsteroidType<<3;
						Objects[Object].PositionX = vx*8;
						Objects[Object].PositionY = (vy-128)*8;
						Objects[Object].SetFixed();
					}
					break;

				case 0x929://UFO
					if(NumPlayers)
					{
						NextObject(Object, SaucerIndex, SaucerIndex);
						if(vs == 15)//gro
							VRamAssert(Objects[Object].Status == 2, VRamInvalid);
						else if(vs == 14)//klein
							VRamAssert(Objects[Object].Status == 1, VRamInvalid);
						else
							VRamAssert(0, VRamInvalid);
						if(Objects[Object].SetVRamLocation(vx, vy, VRamInvalid))
							return true;
					}
					break;

				case 0xa6d://Lebenanzeige
					NumShips++;
					break;

				//Ziffern:
				case 0xadd: NumberRead = true; Number = Number*10 + 0; break;
				case 0xb2e: NumberRead = true; Number = Number*10 + 1; break;
				case 0xb32: NumberRead = true; Number = Number*10 + 2; break;
				case 0xb3a: NumberRead = true; Number = Number*10 + 3; break;
				case 0xb41: NumberRead = true; Number = Number*10 + 4; break;
				case 0xb48: NumberRead = true; Number = Number*10 + 5; break;
				case 0xb4f: NumberRead = true; Number = Number*10 + 6; break;
				case 0xb56: NumberRead = true; Number = Number*10 + 7; break;
				case 0xb5b: NumberRead = true; Number = Number*10 + 8; break;
				case 0xb63: NumberRead = true; Number = Number*10 + 9; break;

				//Buchstabe 'E' abfangen. Es wird wahrscheinlich "Spieler", "Player", "Game Over" o.. angezeigt. Jedenfalls knnen wir nicht steuern
				case 0xA9B:
#ifdef DETECT_START_FOR_TIMERBITS
					StartCounter = 0;
#endif
					Preparing = true;
					break;

#ifdef DETECT_START_FOR_TIMERBITS
				//"START" aus zB "PUSH START" abfangen. (Kommt in allen Sprachen vor). Da die Anzeige synchron
				//mit dem Timer blinkt, knnen wir herausfinden, wie dieser intern ist.
				case 0xAFB: /*S*/ StartCounter = 1; break;
				case 0xB02: /*T*/ if(StartCounter == 1) StartCounter++; else if(StartCounter == 4) StartPrinted = true; else StartCounter = 0; break;
				case 0xA78: /*A*/ if(StartCounter == 2) StartCounter++; else StartCounter = 0; break;
				case 0xAF3: /*R*/ if(StartCounter == 3) StartCounter++; else StartCounter = 0; break;


				//Alle anderen Buchstaben
				case 0xA80://B
				case 0xA8D://C
				case 0xA93://D
				case 0xAA3://F
				case 0xAAA://G
				case 0xAB3://H
				case 0xABA://I
				case 0xAC1://J
				case 0xAC7://K
				case 0xACD://L
				case 0xAD2://M
				case 0xAD8://N
					//O wird durch 0 angezeigt
				case 0xAE3://P
				case 0xAEA://Q
				case 0xB08://U
				case 0xB0e://V
				case 0xB13://W
				case 0xB1a://X
				case 0xB1f://Y
				case 0xB26://Z
					StartCounter = 0;
					break;
#endif
				}
				break;
			default:
				{
					int dy = VRam[pc] & 0x3ff;
					if(VRam[pc] & 0x400)
						dy = -dy;
					int dx = VRam[pc+1] & 0x3ff;
					if(VRam[pc+1] & 0x400)
						dx = -dx;
					//sf = VRam[pc] >> 12;
					int vz = VRam[pc+1] >> 12;

					//Schsse abfragen
					if(NumPlayers && dx == 0 && dy == 0 && vz == 15)
					{
						NextObject(Object, SaucerShotMinIndex, PlayerShotMaxIndex);
						if(Objects[Object].SetVRamLocation(vx, vy, VRamInvalid))
							return true;
					}

					//Schiff
					if(op == 6 && vz == 12 && dx != 0 && dy != 0)
					{
						switch (shipdetect)
						{
						case 0:
							v1x = dx;
							v1y = dy;
							++shipdetect;
							break;
						case 1:
							if(NumPlayers)
							{
								NextObject(Object, PlayerIndex, PlayerIndex);
								VRamAssert(Objects[Object].Status == 1, VRamInvalid);
								if(Objects[Object].SetVRamLocation(vx, vy, VRamInvalid))
									return true;
							}
							else
								Objects[PlayerIndex].Status = 1;

							//Das Winkelbyte bestimmen
							int ship_dx = v1x - dx;
							int ship_dy = v1y - dy;
							if(ShipDirection == 0 && MaxShipDirection == 255)
							{
								//Die Richtung ist noch vllig unbekannt
								if(ship_dx == 1536 && ship_dy == 0)
								{
									//Diese Richtung braucht eine Extrabehandlung, weil der Max Index kleiner als der Min Index ist
									ShipDirection = 253;
									MaxShipDirection = 3;
								}
								else
								{
									ShipDirection = 255;
									MaxShipDirection = 0;
									for(int i = 0; i < 256; i++)
										if(VRamShipDirections[i][0] == ship_dx &&
											VRamShipDirections[i][1] == ship_dy)
										{
											ShipDirection = Min(ShipDirection, (byte)i);
											MaxShipDirection = Max(ShipDirection, (byte)i);
										}
								}
							}
							else
							{
								//Wir ziehen den Bereich immer weiter zu, bis wir den genauen Wert
								//kennen (ShipDirection==MaxShipDirection)
								while(VRamShipDirections[ShipDirection][0] != ship_dx || VRamShipDirections[ShipDirection][1] != ship_dy)
									ShipDirection++;
								while(VRamShipDirections[MaxShipDirection][0] != ship_dx || VRamShipDirections[MaxShipDirection][1] != ship_dy)
									MaxShipDirection--;
							}
							++shipdetect;
							break;
						}
					}
					else if(shipdetect == 1)
						shipdetect = 0;
					break;
				}
			}
			if(op <= 0xa)
				++pc;
			if(op != 0xe) // JMPL
				++pc;
		}
		if(NumPlayers)
		{
			//Alle anderen Objekte mssen auch bei uns weg sein:
			if(Object > PlayerIndex && Objects[PlayerIndex].Status < 0)
				NextObject(Object, PlayerIndex, PlayerIndex);//Die Schiffsexplosion fragen wir nicht ab (zu kompliziert und nutzlos)
			while(--Object >= 0)
				VRamAssert(Objects[Object].Status == 0, VRamInvalid);
		}
		else
		{
#ifdef DETECT_START_FOR_TIMERBITS
			if(TimerBitsKnown < 6 && StartPrinted && !StartPrintedLastFrame && CurrentTime)
			{
				if(StartSwapNoticed && (Timer&0x3F) == 0)
				{
					TimerBitsKnown = 6;
					printf("6 Timerbits\n");
				}
				else if((Timer&1) == 0)
				{
					Timer = 0;
					StartSwapNoticed = true;
				}
			}
			else if(TimerBitsKnown < 6 && !StartPrinted && StartPrintedLastFrame && CurrentTime)
			{
				if(StartSwapNoticed && (Timer&0x3F) == 0x20)
				{
					TimerBitsKnown = 6;
					printf("6 Timerbits\n");
				}
				else if((Timer&1) == 0)
				{
					Timer = 0x20;
					StartSwapNoticed = true;
				}
			}
			else
#endif
			if(TimerBitsKnown < 1)
			{
				//Das erste Byte zeigt auf den aktuellen Vektorpuffer, welcher jeden Frame synchron mit dem Timer wechselt.
				//Wir wissen also wenigstens, ob der Timer gerade oder ungerade ist.
				Timer = VRam[0] == 0xe001 ? 0 : 1;
				TimerBitsKnown = 1;
			}
			else
				assert((Timer%2 == 0) == (VRam[0] == 0xe001));
		}
#ifdef DETECT_START_FOR_TIMERBITS
		StartPrintedLastFrame = StartPrinted;
#endif
		if(pVRamNumShips)
			*pVRamNumShips = NumShips;
		//printf("Zahlen: %i\n", CountNumbers);
		if(CountNumbers == 3 || Preparing)
		{
			NumPlayers = 0;
			return false;
		}
		if(NumPlayers == 0)
		{
			if(Object != AsteroidMaxIndex+1-4 || Objects[PlayerIndex].Status != 1)
			{
				printf("Programm muss gestartet werden, bevor das Spiel beginnt.\n");
				exit(0);
			}

			printf("Starte neues Spiel! Timer: %i\n", Timer&3);
			GameStartedTime = CurrentTime;
			NumPlayers = 1;
			NumAsteroids = AsteroidMaxIndex+1-Object;
			NumAsteroidsStart = 4;
			InvisibleTimer = 0;
			SaucerCountdownStart = 0x92;
			SaucerCountdown = 0x7f;
			NewLevelStartCountdown = 0;
			Level = 6;
			ResetPlayerPosition();

			//Die Position des UFOs ist nicht bekannt und wird spter, wenn es erscheint,
			//nicht vollstndig gesetzt
			for(int p = 0; p < 32; p++)
			for(int v = -16; v <= 16; v += 16)
			{
				Objects[SaucerIndex].PY[Objects[SaucerIndex].cY] = p << 3;
				Objects[SaucerIndex].VY[Objects[SaucerIndex].cY] = v;
				Objects[SaucerIndex].cY++;
			}
			//Die leeren Asteroidslots sind natrlich auch nicht bekannt und werden
			//bei neuen Levels leider auch nicht komplett gesetzt
			//(Das untere Byte einer zuflligen Positionskomponente bleibt ungesetzt)
			for(int i = AsteroidMinIndex; i <= AsteroidMaxIndex; i++)
			{
				if(Objects[i].Status)
					continue;
				for(int j = 0; j < 256; j++)
				{
					Objects[i].PX[j] = j;
					Objects[i].PY[j] = j;
				}
				Objects[i].cX = Objects[i].cY = 256;
			}

			::Object CorrectAsteroids[4];
			for(int i = 0; i < 4; i++)
				CorrectAsteroids[i].SetEmpty();
			RandomSeedDistribution.ClearAll();
			for(int i = 0; i < NumSeedCombinations; i++)
			{
				int j = 0;
				for(; j < 4; j++)
				{
					if(Objects[AsteroidMaxIndex-4+1+j].Status == AsteroidStartPositions[i][j].Status &&
						!AsteroidStartPositions[i][j].XComponentExact &&
						IsInRingRange(Objects[AsteroidMaxIndex-4+1+j].PositionX/8, AsteroidStartPositions[i][j].MinComponent, AsteroidStartPositions[i][j].MaxComponent) &&
						Objects[AsteroidMaxIndex-4+1+j].PositionY/8 == AsteroidStartPositions[i][j].ExactComponent/8)
					{
//						CorrectAsteroids[j].Status = AsteroidStartPositions[i].Asteroids[j].Status;
//						CorrectAsteroids[j].PositionX = Objects[j+1+AsteroidMaxIndex-4].PositionX;
//						CorrectAsteroids[j].PositionY = AsteroidStartPositions[i].Asteroids[j].ExactComponent;
//						CorrectAsteroids[j].VelocityX = AsteroidStartPositions[i].Asteroids[j].VelocityX;
//						CorrectAsteroids[j].VelocityY = AsteroidStartPositions[i].Asteroids[j].VelocityY;
					}
					else if(Objects[AsteroidMaxIndex-4+1+j].Status == AsteroidStartPositions[i][j].Status &&
							AsteroidStartPositions[i][j].XComponentExact &&
							IsInRingRange(Objects[AsteroidMaxIndex-4+1+j].PositionY/8, AsteroidStartPositions[i][j].MinComponent, AsteroidStartPositions[i][j].MaxComponent) &&
							Objects[AsteroidMaxIndex-4+1+j].PositionX/8 == AsteroidStartPositions[i][j].ExactComponent/8)
					{
//						CorrectAsteroids[j].Status = AsteroidStartPositions[i].Asteroids[j].Status;
//						CorrectAsteroids[j].PositionX = Objects[j+1+AsteroidMaxIndex-4].PositionX;
//						CorrectAsteroids[j].PositionY = AsteroidStartPositions[i].Asteroids[j].ExactComponent;
//						CorrectAsteroids[j].VelocityX = AsteroidStartPositions[i].Asteroids[j].VelocityX;
//						CorrectAsteroids[j].VelocityY = AsteroidStartPositions[i].Asteroids[j].VelocityY;
					}
					else
						break;
				}
				if(j < 4)
					continue;
				printf("Seed gefunden! %02x %02x\n",
					   RandomSeeds[i][0],
					   RandomSeeds[i][1]);

				for(int j = 0; j < 4; j++)
				{
					RandomSeedDistribution.Set(i, true);
					CorrectAsteroids[j].Status = AsteroidStartPositions[i][j].Status;
					if(AsteroidStartPositions[i][j].XComponentExact)
					{
						CorrectAsteroids[j].AddLocationX(AsteroidStartPositions[i][j].ExactComponent, AsteroidStartPositions[i][j].VelocityX);
						for(int k = 0; k < 8; k++)
							CorrectAsteroids[j].AddLocationY(Objects[AsteroidMaxIndex-4+1+j].PositionY/8*8+k, AsteroidStartPositions[i][j].VelocityY);
					}
					else
					{
						CorrectAsteroids[j].AddLocationY(AsteroidStartPositions[i][j].ExactComponent, AsteroidStartPositions[i][j].VelocityY);
						for(int k = 0; k < 8; k++)
							CorrectAsteroids[j].AddLocationX(Objects[AsteroidMaxIndex-4+1+j].PositionX/8*8+k, AsteroidStartPositions[i][j].VelocityX);
					}
				}
			}
			if(!CorrectAsteroids[0].IsValid())
			{
				printf("Der Zufallsseed von Asteroids konnte nicht erkannt werden.\n"
				"Vermutlich wurde Mame oder das Rom so geaendert, dass der Zufallsgenerator\n"
				"andere Ergebnisse liefert. Leider funktioniert so dieses Programm nicht:(\n");
				exit(0);
			}
			for(int i = 0; i < 4; i++)
				Objects[AsteroidMaxIndex-4+1+i] = CorrectAsteroids[i];

			if(TimerBitsKnown < 2)
			{
				assert(TimerBitsKnown == 1);
				TimerBitsKnown = 2;

				MovePosition NewMovePosition(MPT_NewGame, false);
				NewMovePosition.Game = *this;
				NewMovePosition.Game.Timer += 2;
				if((NewMovePosition.Game.Timer&3) == 0)
					NewMovePosition.Game.SaucerCountdown--;
				MovePositions.push(NewMovePosition);
			}

			if((Timer&3) == 0)
				SaucerCountdown--;
		}
		return true;

	}

	static int IsInRingRange(int Value, int Min, int Max)
	{
		if(Max >= Min)
			return Value >= Min && Value <= Max;
		else
			return Value >= Min || Value <= Max;
	}

	void CheckRam(const byte* Ram) const
	{
		assert(RandomSeedDistribution.Get(GetRandomSeedIndex(Ram[0x5F], Ram[0x60])), RamInvalidException());

/*
		//Winkelbytetabelle
		static std::map<byte, std::pair<int, int>> ShipDirections;

		if(NumPlayers)
		{
			if(ShipDirections.find(Ram[0x61]) != ShipDirections.end())
				VRamAssert(ShipDirections[Ram[0x61]] == std::pair<int, int>(ship_dx, ship_dy));
			else
				ShipDirections[Ram[0x61]] = std::pair<int, int>(ship_dx, ship_dy);
			printf("ShipDirs: %i\n", ShipDirections.size());
			if(ShipDirections.size() == 256)
			{
				FILE* out = fopen("ShipDirections.txt", "w");
				for(int i = 0; i < 256; i++)
					fprintf(out, "\t{%i, %i},\n", ShipDirections[i].first, ShipDirections[i].second);
				fclose(out);
			}
		}*/

		byte i = ShipDirection;
		while(i != Ram[0x61])
		{
			if(i++ == MaxShipDirection)
				assert(0, RamInvalidException());
		}

		assert(byte(Timer << (8-TimerBitsKnown)) == byte(Ram[0x5C] << (8-TimerBitsKnown)), RamInvalidException());

		if(!NumPlayers)
			return;


		/*
		//Seedtabelle
		FILE* out = fopen("Seeds.txt", "w");
		byte s1 = RandomSeed1;
		byte s2 = RandomSeed2;
		Rand();
		int i = 0;
		while(s1 != RandomSeed1 || s2 != RandomSeed2)
		{
			fprintf(out, "\t{0x%02x, 0x%02x},\n", RandomSeed1, RandomSeed2);
			Rand();
		}
		fprintf(out, "\t{0x%02x, 0x%02x},\n", RandomSeed1, RandomSeed2);
		fclose(out);
		exit(0);*/

		assert(Score%100000 == DecimalToBin(Ram[0x53], Ram[0x52])*10, RamInvalidException());

		struct
		{
			const byte* pVariable;
			int Address;
		}
		VariableAddresses[] =
		{
			&NumPlayers,			   0x1C,
			//&NumShips,				   0x57,
			(byte*)&HyperSpaceStatus,  0x59,
			//&FireHyperspaceToggle,	   0x63,
			//&AccX,					   0x64,
			//&AccY,					   0x65,
			&NumAsteroidsStart,        0x02F5,
			&NumAsteroids,			   0x02F6,
			&SaucerCountdown,		   0x02F7,
			&SaucerCountdownStart,	   0x02F8,
			//&AsteroidDestroyedTimer,   0x02F9,
			&InvisibleTimer,		   0x02FA,
			&NewLevelStartCountdown,   0x02FB,
			&Level,                    0x02FD
		};


		for(int i = 0; i < _countof(VariableAddresses); i++)
			assert(*VariableAddresses[i].pVariable == Ram[VariableAddresses[i].Address], RamInvalidException());


		for(int i = 0; i < NumObjects; i++)
		{
			if(i >= AsteroidMinIndex && i <= AsteroidMaxIndex)
				assert((Objects[i].Status&~0x40) == char(Ram[0x200+i]) || (Objects[i].Status&0x40) != 0, RamInvalidException());
			else
				assert(Objects[i].Status == char(Ram[0x200+i]), RamInvalidException());
			if(Objects[i].Status)
				Objects[i].ValidatePosition(MakeWord(Ram[0x269+i], Ram[0x2AF+i]), MakeWord(Ram[0x28C+i], Ram[0x2D2+i]),
				char(Ram[0x223+i]), char(Ram[0x246+i]));
		}
	}

	void Render(HDC hdc, int cx, int cy)
	{
		SelectObject(hdc, GetStockObject(NULL_BRUSH));
		SelectObject(hdc, CreatePen(PS_SOLID, 0, RGB(255,255,0)));
		for(int Pass = 0; Pass < 2; Pass++)
		{
			for(int i = 0; i < NumObjects; i++)
			{
				if(Objects[i].Status==0)
					continue;
				if(Objects[i].Status < 0 && Pass != 0 || //Explosion im ersten Pass zeichnen
					Objects[i].Status >= 0 && Pass == 0)
					continue;
				int Size = 100;
				if(Objects[i].Status < 0)//Explosion
					Size = -Objects[i].Status;
				else if(i==PlayerIndex)
					Size = 12;
				else if(i==SaucerIndex && Objects[i].Status == 1)
					Size = -10;
				else if(i==SaucerIndex && Objects[i].Status == 2)
					Size = -20;
				else if(i<PlayerIndex && (Objects[i].Status&0x01))
					Size = 13;
				else if(i<PlayerIndex && (Objects[i].Status&0x02))
					Size = 20;
				else if(i<PlayerIndex && (Objects[i].Status&0x04))
					Size = 33;
				else if(i>SaucerIndex)
					Size = 4;
				else
					assert(0);
				for(int ax = 0; ax < Objects[i].cX; ax++)
				for(int ay = 0; ay < Objects[i].cY; ay++)
				{
					int x = int(Objects[i].PX[ax]) * cx / 0x2000;
					int y = int(Objects[i].PY[ay]) * cy / 0x1800;
					y = cy - y;
					if(Size > 0)
						Ellipse(hdc, x-Size*cx/1033, y-Size*cy/733, x+Size*cx/1033, y+Size*cy/733);
					else
						Rectangle(hdc, x+Size*cx/1033, y+Size*cy/733, x-Size*cx/1033, y-Size*cy/733);
					if(i==PlayerIndex)
					{
						MoveToEx(hdc, x, y, 0);
						LineTo(hdc, int(cos(float(ShipDirection)/255.f*6.283f)*20.0f)+x,
									int(sin(float(ShipDirection)/255.f*6.283f)*-20.0f)+y);
					}
					if(Objects[i].cX != 1 || Objects[i].cY != 1)
					{
						char Buffer[128];
						sprintf_s(Buffer, 128, "%ix%i", Objects[i].cX, Objects[i].cY);
						TextOut(hdc, x, y, Buffer, (int)strlen(Buffer));
					}
				}
			}
			//SelectObject(hdc, GetStockObject(WHITE_BRUSH));
			DeleteObject(SelectObject(hdc, GetStockObject(BLACK_PEN)));
		}

		for(std::multiset<ShotInfoList>::iterator j = ShotInfosVariety.begin();
			j != ShotInfosVariety.end();
			j++)
		{
			for(int i = 0; i < (int)j->size()-2; i++)
			{
				SelectObject(hdc, CreatePen(PS_SOLID, 0, RGB(i*255/int(j->size()-2), i*255/int(j->size()-2), i*255/int(j->size()-2))));
				assert((*j)[i].Time != MaxInt);
				int x = int((*j)[i].StartX) * cx / 0x2000;
				int y = int((*j)[i].StartY) * cy / 0x1800;
				y = cy - y;
				MoveToEx(hdc, x, y, 0);
				x = (*j)[i].TargetXEasy() * cx / 0x2000;
				y = (*j)[i].TargetYEasy() * cy / 0x1800;
				y = cy - y;
				LineTo(hdc, x, y);

				DeleteObject(SelectObject(hdc, GetStockObject(WHITE_PEN)));
			}
			break;
		}

		/*for(int x = 0; x < cx; x++)
		for(int y = x%2; y < cy; y+=2)
		{
			int xAst = x * 0x2000 / cx;
			int yAst = (cy-y) * 0x1800 / cy;
			for(int Object = SaucerIndex; Object >= 0; Object--)
			{
				if(Objects[Object].Status <= 0)
					continue;
				bool collision = AreObjectsNear(0x1F, xAst, yAst, 10,
												Object,
												Objects[Object].PositionX,
												Objects[Object].PositionY, Objects[Object].Status);
				if(collision)
					SetPixel(hdc, x, y, RGB(255,0,0));
			}
			if(PlayerPositionGoodForKI(xAst, yAst))
				SetPixel(hdc, x, y, RGB(0,0,255));
		}*/

		char Buffer[512];
		int len = sprintf_s(Buffer, 512,
			"Zeit: %i (%i:%02i) Score: %i.%03i Leben: %i Seeds: %i TimerBits: %i KI Shots: %i UFO: %i "
#ifdef USE_NETWORK_THREAD
			"NetDelay: %i "
#else
			"Blockierend "
#endif
			"Latenz: %i Qualitt %i%%",
			CurrentTime, (CurrentTime-GameStartedTime)/60/60, (CurrentTime-GameStartedTime)/60%60,
			Score/1000, Score%1000,
			NumShips,
			RandomSeedDistribution.GetNumSetBits(),
			TimerBitsKnown,
			ShotInfosVariety.begin()->size()-2,
			SaucerCountdown,
#ifdef USE_NETWORK_THREAD
			NetDelay,
#endif
			AverageLatency,
			NetworkQuality
			);
		TextOut(hdc, 0, 0, Buffer, len);
	}

	//Folgende Methoden sind in KI.h implementiert
	void CalculateNextShot(const ShotInfoList& ShotInfos, int MinShootTime, std::multiset<ShotInfoList>& ShotInfosVariety) const;
	void CalculateNextShot_(const ShotInfoList& ShotInfos, int MinShootTime, std::multiset<ShotInfoList>& ShotInfosVariety);
	//	void CalculateNextShot(std::vector<ShotInfo>& ShotInfos, int& MaxCollisionTime, int MinShootTime);
	void SimulateShot(ObjectsStateList& ObjectsStates, const ShotInfoList& ShotInfos, const int CurrentObjectsStates, const int CurrentShotInfo, const int cShotsShot, const int t, const int ShotIndex, const int DeltaDir, int& MinCollisionAtTime, std::multiset<ShotInfoList>& ShotInfosVariety, int RotationWasLockedAtTime);
	void CheckForErrors(const ShotInfoList& ShotInfos, int UntilTime);
};
