
//Diese Klasse ist sehr an dieses Projekt angepasst und ist alles andere als vollstndig
template<uint cBits>
class BitArray
{
	byte Bits[(cBits+7)/8];
	uint cSetBits;
	mutable uint FirstSetBit;
public:
	bool Get(uint Index) const
	{
		assert(Index < cBits);

		byte Mask = 1 << (Index - Index / 8 * 8);

		return (Bits[Index/8] & Mask) != 0;
	}

	void Set(uint Index, bool b)
	{
		if(Get(Index) == b)
			return;
		assert(Index < cBits);

		byte Mask = 1 << (Index - Index / 8 * 8);

		if(b)
		{
			Bits[Index/8] |= Mask;
			cSetBits++;
			if(Index < FirstSetBit)
				FirstSetBit = Index;
		}
		else
		{
			Bits[Index/8] &= ~Mask;
			cSetBits--;
		}
	}

	void SetAll()
	{
		for(uint i = 0; i < (cBits+7)/8; i++)
			Bits[i] = 0xFF;
		cSetBits = cBits;
		FirstSetBit = 0;
	}

	void ClearAll()
	{
		for(uint i = 0; i < (cBits+7)/8; i++)
			Bits[i] = 0;
		cSetBits = 0;
		FirstSetBit = cBits;
	}

	void RotateRight()
	{
		if(cSetBits == 1)
		{
			GetFirstSetIndex();
			Set(FirstSetBit, false);
			FirstSetBit = (FirstSetBit+1)%cBits;
			Set(FirstSetBit, true);
			assert(cSetBits == 1);
		}
		else if(cSetBits != cBits)
		{
			//Das kann man noch gewaltig optimieren...
			bool Last = Get(cBits-1);
			for(uint i = cBits-1; i >= 1; i--)
				Set(i, Get(i-1));
			Set(0, Last);
		}
	}

	int GetFirstSetIndex() const
	{
		assert(cSetBits != 0);
		while(!Get(FirstSetBit))
			FirstSetBit = (FirstSetBit+1) % cBits;
		return FirstSetBit;
		/*		if(cSetBits == 0)
		return -1;
		for(int i = 0; i < cBits; i++)
		if(Get(i))
		return i;
		assert(0);
		return -1;*/
	}

	int GetNumSetBits() const
	{
		return cSetBits;
	}

	//Achtung: Nach dem diese Methode aufgerufen wurde muss
	//unbedingt UpdateInternalData() aufgerufen werden!
	void operator |=(const BitArray& rhs)
	{
		for(int i = 0; i < (cBits+7)/8; i++)
			Bits[i] |= rhs.Bits[i];
	}

	void UpdateInternalData()
	{
		cSetBits = 0;
		FirstSetBit = 0;
		for(int i = 0; i < cBits; i++)
			if(Get(i))
			{
				cSetBits++;
				if(FirstSetBit == cSetBits)
					FirstSetBit = i;
			}
	}
};


