﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ct.Asteroid
{
    public class Asteroid
    {
	    public int x;    // Koordinaten des Mittelpunkts
	    public int y;
	    public int type; // 1 ... 4, äußere Form
        public int radius;
        public int DistanceToShip = 1000;
        public double AngleFromShip = 0;
        public double NeededShotAngleNow = 0;
	    public int sf;   // scale factor: 0 = groß, 15 = mittel, 14 = klein
        public int dx = 0;
        public int dy = 0;
        public DateTime motion_start;
        public int collision_time = 0;
        public bool dont_shoot_me = false;



        public void set(int x, int y, int type, int sf)
        {
	        this.x = x;
	        this.y = y;
	        this.type = type;
	        this.sf = sf;
            switch (sf)
            {	// den ungefähren Radius des Asteroiden eintragen
                case 0:  // großer Asteroid
                    radius = 40 ;
                    break;
                case 15: // mittlerer Asteroid
                    radius = 20;
                    break;
                case 14: // kleiner Asteroid
                    radius = 8;
                    break;
            }

        }
        public coordinate GetFuturePosition(double time_ms)
        {
            coordinate temp = new coordinate();
            double tracktime = (DateTime.Now - motion_start).TotalMilliseconds;
            //Falls die MotionTrack-Dauer noch keine Aussage zulässt, bewegt sich der Asteroid halt nicht
            if (tracktime < 1)
            {
                temp.x = x;
                temp.y = y;
                return temp;
            }

            double factor = time_ms / tracktime;
            temp.x = (int)(x + (factor * dx));
            temp.y = (int)(y + (factor * dy));
            return temp;
        }


    }
    public class statistics
    {
        public static int NrOfDontShoots = 0;
        public static double Angle = 0;
        public static Byte Winkelbyte = 0;
        public static double DxDyAngle = 0;
        public static int Dx = 0;
        public static int Dy = 0;
        public static byte ping = 0;
        public static byte pong = 0;




        public void clear()
        {
            NrOfDontShoots = 0;
            Angle = 0;
            Winkelbyte = 0;
            DxDyAngle = 0;
            Dx = 0;
            Dy = 0;
            ping = 0;
            pong = 0;
        }

        public void print()
        {
            Console.WriteLine("NrOfDontShoots: " + NrOfDontShoots);
            Console.WriteLine("Angle: " + Angle);
            Console.WriteLine(Winkelbyte + ";" + Angle + ";" + DxDyAngle + ";" + Dx + ";" + Dy + ";" + ping + ";" + pong + ";");

        }
    }

    public class Shot
    {
	    public int x;
	    public int y;
        public int dx;
        public int dy;
        public int radius = 1;
        public int DistanceToShip = 1000;
        public int collision_time = 1000;
        public DateTime motion_start;

        public void set(int x, int y)
        {
	        this.x = x;
	        this.y = y;
        }

    }

    public class Ship
    {
        public bool present;  // Schiff sichtbar
        public int x;         // Mittelpunkt des Schiffs
        public int y;
        public int dx;        // Blickrichtung des Schiffes
        public int dy;
        public int move_dx;    //Bewegungsrichtung des Schiffes
        public int move_dy;
        public int radius = 12;
        public double Angle;
        public DateTime motion_start;
        public Byte Winkelbyte = 0;
        public int[] Drehungen = new int[256];
        Winkeltabelle winkeltabelle = new Winkeltabelle();

        public int DistanceTo(int obj_x, int obj_y)
        {
            obj_x = NormalizeToX(obj_x);
            obj_y = NormalizeToY(obj_y);

            int dist = (int) Math.Sqrt(obj_x * obj_x + obj_y * obj_y);
            dist -= radius;
            //int dist = obj_x * obj_x + obj_y * obj_y;
            return dist;
        }
        public int NormalizeToX(int obj_x)
        {
            obj_x = obj_x - x;
            while (obj_x < -512) obj_x += 1024;
            while (obj_x > 511) obj_x -= 1024;
            return obj_x;
        }
        public int NormalizeToY(int obj_y)
        {
            obj_y = obj_y - y;
            while (obj_y < -384) obj_y += 768;
            while (obj_y > 383) obj_y -= 768;
            return obj_y;
        }

        public void HandlePostWinkelByte(KeysPacket keys)
        {
            //Drehungen merken
            Drehungen[keys.ping] = 0;
            if (keys.left())
                Drehungen[keys.ping] = 3;
            if (keys.right())
                Drehungen[keys.ping] = -3;
        }

        public void HandleWinkelByte( byte received_ping)
        {

            //Drehungen auswerten
            //Die Drehung von vor Latenz+1 Runden aufs Winkelbyte schreiben.
            //wegen unterschiedlicher Datentypen so komisch gelöst
            received_ping -= 1;
            if (Drehungen[received_ping] == 3)
                Winkelbyte += 3;
            if (Drehungen[received_ping] == -3)
                Winkelbyte -= 3;

            //jetzt das Winkelbyte synchronisieren, erstmal ganz einfach

            //if ((dx == 0) && (dy == 1536))
            //    Winkelbyte = 64;
            //if ((dx == 0) && (dy == -1536))
            //    Winkelbyte = 192;
            int temp = winkeltabelle.get_wb(dx, dy, Drehungen[received_ping]);
            if (temp < 256)
            {
                Winkelbyte = (byte)temp;
#if DEBUG
                Console.WriteLine(" SYNC!!!!!!!!!!!!!!!!!!!!!!!");
#endif
            }
             
            Angle = ((double)Winkelbyte) * 2.0 * Math.PI / 256.0;
            statistics.Angle = Angle;
            statistics.Winkelbyte = Winkelbyte;
            statistics.DxDyAngle = Math.Atan2(this.dy, this.dx);
            statistics.Dx = this.dx;
            statistics.Dy = this.dy;
            //statistics.ping = keys.ping;
            //statistics.pong = received_ping;

           
        }
    }

    public class Saucer
    {
        public bool present;// UFO sichtbar
        public int x;       // Mittelpunkt des UFOs
        public int y;
        public int dx;       // 
        public int dy;
        public DateTime motion_start;
        public int size;    // Größe: 15 = groß, 14 = klein
        public int radius;
        public int DistanceToShip = 1000;
        public bool dont_shoot_me = false;

        public coordinate GetFuturePosition(double time_ms)
        {
            coordinate temp = new coordinate();
            double tracktime = (DateTime.Now - motion_start).TotalMilliseconds;
            //Falls die MotionTrack-Dauer noch keine Aussage zulässt, bewegt sich der Asteroid halt nicht
            if (tracktime < 1)
            {
                temp.x = x;
                temp.y = y;
                return temp;
            }

            double factor = time_ms / tracktime;
            temp.x = (int)(x + (factor * dx));
            temp.y = (int)(y + (factor * dy));
            return temp;
        }
    }

    public struct coordinate
    {
        public int x;
        public int y;

        public coordinate(int def_x,int def_y)
        {
            x = def_x;
            y = def_y;
        }
    }

    public class GameStatus
    {

        public Saucer saucer = new Saucer();
        public Ship ship = new Ship();
	    public int nasteroids; // Anzahl Asteroiden
	    public Asteroid[] asteroids = new Asteroid[100];
	    public int nshots;     // Anzahl Schüsse
	    public Shot[] shots = new Shot[10];
        public int CurrentTarget = Player.NO_TARGET; //unschön...
	    public statistics stats = new statistics();
        public void clear(bool cleararrays)
        {
	        ship.present = false;
	        saucer.present = false;
	        nasteroids = 0;
	        nshots = 0;
            ship.move_dx = 0;
            ship.move_dy = 0;
            if (cleararrays)
            {
                for (int i = 0; i < 100; i++)
                    asteroids[i] = new Asteroid();

                for (int i = 0; i < 10; i++)
                    shots[i] = new Shot();
            }
        }
    }
   
    public class FramePacket
    {
        public byte[] vectorram = new byte[1026];
        public UInt16[] vectorram2 = new UInt16[513];
        public char frameno;  // wird bei jedem Frame inkrementiert
        public char ping;     // Der Server schickt das letzte empfangene ping-Byte zurück

        public static FramePacket FromByteArray(byte[] array)
        {
            FramePacket np = new FramePacket();

            for (int i = 0; i < 513; i++)
            {
                // Damit ich später nicht über einen Pointer auf das Vector-Ram zugreifen
                // muss, kopiere ich die Daten in ein ushort Array um.
                np.vectorram2[i] = (ushort)(array[2 * i] + array[(2 * i) + 1] * 256);
                np.vectorram[i] = array[i];
            }

            np.frameno = (char)array[1024];
            np.ping = (char)array[1025];

            return np;
        }
    }

    public class KeysPacket
    {
	    const int KEY_HYPERSPACE = 1;
        const int KEY_FIRE = 2;
        const int KEY_THRUST = 4;
        const int KEY_RIGHT = 8;
        const int KEY_LEFT = 16;
        const int KEY_START = 32;

        public int keys;

	    public byte ping;     // wird vom Server bei nächster Gelegenheit zurückgeschickt. Für Latenzmessung.

        public KeysPacket()
        {
	        keys = '@';
	        ping = 0;
        }

        public byte[] ToByteArray()
        {
            byte[] byts  = new byte[8];

            byts[0] = (byte)'c';
            byts[1] = (byte)'t';
            byts[2] = (byte)'m';
            byts[3] = (byte)'a';
            byts[4] = (byte)'m';
            byts[5] = (byte)'e';
            byts[6] = (byte)keys;
            byts[7] = (byte)ping;

            return byts;
        }

        public void clear()
        {
	        keys = '@';
        }

        public void start(bool b)
        {
            if (b)
                keys |= KEY_START;
            else
                keys &= ~KEY_START;
        }

        public void hyperspace(bool b)
        {
	        if (b)
		        keys |= KEY_HYPERSPACE;
	        else
		        keys &= ~KEY_HYPERSPACE;
        }

        public void fire(bool b)
        {
	        if (b)
		        keys |= KEY_FIRE;
	        else
                keys &= ~KEY_FIRE;
        }

        public void thrust(bool b)
        {
	        if (b)
		        keys |= KEY_THRUST;
	        else
                keys &= ~KEY_THRUST;
        }

        public void left(bool b)
        {
	        if (b)
	        {
		        keys |= KEY_LEFT;
		        right(false);
	        }
	        else
                keys &= ~KEY_LEFT;
        }

        public void right(bool b)
        {
	        if (b)
	        {
		        keys |= KEY_RIGHT;
		        left(false);
	        }
	        else
                keys &= ~KEY_RIGHT;
        }


        public bool left()
        {
            return (keys & KEY_LEFT) == KEY_LEFT;
        }
        public bool right()
        {
            return (keys & KEY_RIGHT) == KEY_RIGHT;
        }
    }

    public class Winkeltabelle
    {
        int last_x = 9999;
        int last_y = 9999;

        coordinate[] tabelle = new coordinate[256];

        public Winkeltabelle()
        {
            tabelle[0] = new coordinate(1536, 0);
            tabelle[1] = new coordinate(1536, 0);
            tabelle[2] = new coordinate(1536, 0);
            tabelle[3] = new coordinate(1536, 0);
            tabelle[4] = new coordinate(1528, 152);
            tabelle[5] = new coordinate(1528, 152);
            tabelle[6] = new coordinate(1528, 152);
            tabelle[7] = new coordinate(1528, 152);
            tabelle[8] = new coordinate(1504, 296);
            tabelle[9] = new coordinate(1504, 296);
            tabelle[10] = new coordinate(1504, 296);
            tabelle[11] = new coordinate(1504, 296);
            tabelle[12] = new coordinate(1472, 440);
            tabelle[13] = new coordinate(1472, 440);
            tabelle[14] = new coordinate(1472, 440);
            tabelle[15] = new coordinate(1472, 440);
            tabelle[16] = new coordinate(1416, 584);
            tabelle[17] = new coordinate(1416, 584);
            tabelle[18] = new coordinate(1416, 584);
            tabelle[19] = new coordinate(1416, 584);
            tabelle[20] = new coordinate(1360, 720);
            tabelle[21] = new coordinate(1360, 720);
            tabelle[22] = new coordinate(1360, 720);
            tabelle[23] = new coordinate(1360, 720);
            tabelle[24] = new coordinate(1280, 856);
            tabelle[25] = new coordinate(1280, 856);
            tabelle[26] = new coordinate(1280, 856);
            tabelle[27] = new coordinate(1280, 856);
            tabelle[28] = new coordinate(1192, 976);
            tabelle[29] = new coordinate(1192, 976);
            tabelle[30] = new coordinate(1192, 976);
            tabelle[31] = new coordinate(1192, 976);
            tabelle[32] = new coordinate(1088, 1088);
            tabelle[33] = new coordinate(1088, 1088);
            tabelle[34] = new coordinate(1088, 1088);
            tabelle[35] = new coordinate(1088, 1088);
            tabelle[36] = new coordinate(976, 1192);
            tabelle[37] = new coordinate(976, 1192);
            tabelle[38] = new coordinate(976, 1192);
            tabelle[39] = new coordinate(976, 1192);
            tabelle[40] = new coordinate(856, 1280);
            tabelle[41] = new coordinate(856, 1280);
            tabelle[42] = new coordinate(856, 1280);
            tabelle[43] = new coordinate(856, 1280);
            tabelle[44] = new coordinate(720, 1360);
            tabelle[45] = new coordinate(720, 1360);
            tabelle[46] = new coordinate(720, 1360);
            tabelle[47] = new coordinate(720, 1360);
            tabelle[48] = new coordinate(584, 1416);
            tabelle[49] = new coordinate(584, 1416);
            tabelle[50] = new coordinate(584, 1416);
            tabelle[51] = new coordinate(584, 1416);
            tabelle[52] = new coordinate(440, 1472);
            tabelle[53] = new coordinate(440, 1472);
            tabelle[54] = new coordinate(440, 1472);
            tabelle[55] = new coordinate(440, 1472);
            tabelle[56] = new coordinate(296, 1504);
            tabelle[57] = new coordinate(296, 1504);
            tabelle[58] = new coordinate(296, 1504);
            tabelle[59] = new coordinate(296, 1504);
            tabelle[60] = new coordinate(152, 1528);
            tabelle[61] = new coordinate(152, 1528);
            tabelle[62] = new coordinate(152, 1528);
            tabelle[63] = new coordinate(152, 1528);
            tabelle[64] = new coordinate(0, 1536);
            tabelle[65] = new coordinate(-152, 1528);
            tabelle[66] = new coordinate(-152, 1528);
            tabelle[67] = new coordinate(-152, 1528);
            tabelle[68] = new coordinate(-152, 1528);
            tabelle[69] = new coordinate(-296, 1504);
            tabelle[70] = new coordinate(-296, 1504);
            tabelle[71] = new coordinate(-296, 1504);
            tabelle[72] = new coordinate(-296, 1504);
            tabelle[73] = new coordinate(-440, 1472);
            tabelle[74] = new coordinate(-440, 1472);
            tabelle[75] = new coordinate(-440, 1472);
            tabelle[76] = new coordinate(-440, 1472);
            tabelle[77] = new coordinate(-584, 1416);
            tabelle[78] = new coordinate(-584, 1416);
            tabelle[79] = new coordinate(-584, 1416);
            tabelle[80] = new coordinate(-584, 1416);
            tabelle[81] = new coordinate(-720, 1360);
            tabelle[82] = new coordinate(-720, 1360);
            tabelle[83] = new coordinate(-720, 1360);
            tabelle[84] = new coordinate(-720, 1360);
            tabelle[85] = new coordinate(-856, 1280);
            tabelle[86] = new coordinate(-856, 1280);
            tabelle[87] = new coordinate(-856, 1280);
            tabelle[88] = new coordinate(-856, 1280);
            tabelle[89] = new coordinate(-976, 1192);
            tabelle[90] = new coordinate(-976, 1192);
            tabelle[91] = new coordinate(-976, 1192);
            tabelle[92] = new coordinate(-976, 1192);
            tabelle[93] = new coordinate(-1088, 1088);
            tabelle[94] = new coordinate(-1088, 1088);
            tabelle[95] = new coordinate(-1088, 1088);
            tabelle[96] = new coordinate(-1088, 1088);
            tabelle[97] = new coordinate(-1192, 976);
            tabelle[98] = new coordinate(-1192, 976);
            tabelle[99] = new coordinate(-1192, 976);
            tabelle[100] = new coordinate(-1192, 976);
            tabelle[101] = new coordinate(-1280, 856);
            tabelle[102] = new coordinate(-1280, 856);
            tabelle[103] = new coordinate(-1280, 856);
            tabelle[104] = new coordinate(-1280, 856);
            tabelle[105] = new coordinate(-1360, 720);
            tabelle[106] = new coordinate(-1360, 720);
            tabelle[107] = new coordinate(-1360, 720);
            tabelle[108] = new coordinate(-1360, 720);
            tabelle[109] = new coordinate(-1416, 584);
            tabelle[110] = new coordinate(-1416, 584);
            tabelle[111] = new coordinate(-1416, 584);
            tabelle[112] = new coordinate(-1416, 584);
            tabelle[113] = new coordinate(-1472, 440);
            tabelle[114] = new coordinate(-1472, 440);
            tabelle[115] = new coordinate(-1472, 440);
            tabelle[116] = new coordinate(-1472, 440);
            tabelle[117] = new coordinate(-1504, 296);
            tabelle[118] = new coordinate(-1504, 296);
            tabelle[119] = new coordinate(-1504, 296);
            tabelle[120] = new coordinate(-1504, 296);
            tabelle[121] = new coordinate(-1528, 152);
            tabelle[122] = new coordinate(-1528, 152);
            tabelle[123] = new coordinate(-1528, 152);
            tabelle[124] = new coordinate(-1528, 152);
            tabelle[125] = new coordinate(-1536, 0);
            tabelle[126] = new coordinate(-1536, 0);
            tabelle[127] = new coordinate(-1536, 0);
            tabelle[128] = new coordinate(-1536, 0);
            tabelle[129] = new coordinate(-1536, 0);
            tabelle[130] = new coordinate(-1536, 0);
            tabelle[131] = new coordinate(-1536, 0);
            tabelle[132] = new coordinate(-1528, -152);
            tabelle[133] = new coordinate(-1528, -152);
            tabelle[134] = new coordinate(-1528, -152);
            tabelle[135] = new coordinate(-1528, -152);
            tabelle[136] = new coordinate(-1504, -296);
            tabelle[137] = new coordinate(-1504, -296);
            tabelle[138] = new coordinate(-1504, -296);
            tabelle[139] = new coordinate(-1504, -296);
            tabelle[140] = new coordinate(-1472, -440);
            tabelle[141] = new coordinate(-1472, -440);
            tabelle[142] = new coordinate(-1472, -440);
            tabelle[143] = new coordinate(-1472, -440);
            tabelle[144] = new coordinate(-1416, -584);
            tabelle[145] = new coordinate(-1416, -584);
            tabelle[146] = new coordinate(-1416, -584);
            tabelle[147] = new coordinate(-1416, -584);
            tabelle[148] = new coordinate(-1360, -720);
            tabelle[149] = new coordinate(-1360, -720);
            tabelle[150] = new coordinate(-1360, -720);
            tabelle[151] = new coordinate(-1360, -720);
            tabelle[152] = new coordinate(-1280, -856);
            tabelle[153] = new coordinate(-1280, -856);
            tabelle[154] = new coordinate(-1280, -856);
            tabelle[155] = new coordinate(-1280, -856);
            tabelle[156] = new coordinate(-1192, -976);
            tabelle[157] = new coordinate(-1192, -976);
            tabelle[158] = new coordinate(-1192, -976);
            tabelle[159] = new coordinate(-1192, -976);
            tabelle[160] = new coordinate(-1088, -1088);
            tabelle[161] = new coordinate(-1088, -1088);
            tabelle[162] = new coordinate(-1088, -1088);
            tabelle[163] = new coordinate(-1088, -1088);
            tabelle[164] = new coordinate(-976, -1192);
            tabelle[165] = new coordinate(-976, -1192);
            tabelle[166] = new coordinate(-976, -1192);
            tabelle[167] = new coordinate(-976, -1192);
            tabelle[168] = new coordinate(-856, -1280);
            tabelle[169] = new coordinate(-856, -1280);
            tabelle[170] = new coordinate(-856, -1280);
            tabelle[171] = new coordinate(-856, -1280);
            tabelle[172] = new coordinate(-720, -1360);
            tabelle[173] = new coordinate(-720, -1360);
            tabelle[174] = new coordinate(-720, -1360);
            tabelle[175] = new coordinate(-720, -1360);
            tabelle[176] = new coordinate(-584, -1416);
            tabelle[177] = new coordinate(-584, -1416);
            tabelle[178] = new coordinate(-584, -1416);
            tabelle[179] = new coordinate(-584, -1416);
            tabelle[180] = new coordinate(-440, -1472);
            tabelle[181] = new coordinate(-440, -1472);
            tabelle[182] = new coordinate(-440, -1472);
            tabelle[183] = new coordinate(-440, -1472);
            tabelle[184] = new coordinate(-296, -1504);
            tabelle[185] = new coordinate(-296, -1504);
            tabelle[186] = new coordinate(-296, -1504);
            tabelle[187] = new coordinate(-296, -1504);
            tabelle[188] = new coordinate(-152, -1528);
            tabelle[189] = new coordinate(-152, -1528);
            tabelle[190] = new coordinate(-152, -1528);
            tabelle[191] = new coordinate(-152, -1528);
            tabelle[192] = new coordinate(0, -1536);
            tabelle[193] = new coordinate(152, -1528);
            tabelle[194] = new coordinate(152, -1528);
            tabelle[195] = new coordinate(152, -1528);
            tabelle[196] = new coordinate(152, -1528);
            tabelle[197] = new coordinate(296, -1504);
            tabelle[198] = new coordinate(296, -1504);
            tabelle[199] = new coordinate(296, -1504);
            tabelle[200] = new coordinate(296, -1504);
            tabelle[201] = new coordinate(440, -1472);
            tabelle[202] = new coordinate(440, -1472);
            tabelle[203] = new coordinate(440, -1472);
            tabelle[204] = new coordinate(440, -1472);
            tabelle[205] = new coordinate(584, -1416);
            tabelle[206] = new coordinate(584, -1416);
            tabelle[207] = new coordinate(584, -1416);
            tabelle[208] = new coordinate(584, -1416);
            tabelle[209] = new coordinate(720, -1360);
            tabelle[210] = new coordinate(720, -1360);
            tabelle[211] = new coordinate(720, -1360);
            tabelle[212] = new coordinate(720, -1360);
            tabelle[213] = new coordinate(856, -1280);
            tabelle[214] = new coordinate(856, -1280);
            tabelle[215] = new coordinate(856, -1280);
            tabelle[216] = new coordinate(856, -1280);
            tabelle[217] = new coordinate(976, -1192);
            tabelle[218] = new coordinate(976, -1192);
            tabelle[219] = new coordinate(976, -1192);
            tabelle[220] = new coordinate(976, -1192);
            tabelle[221] = new coordinate(1088, -1088);
            tabelle[222] = new coordinate(1088, -1088);
            tabelle[223] = new coordinate(1088, -1088);
            tabelle[224] = new coordinate(1088, -1088);
            tabelle[225] = new coordinate(1192, -976);
            tabelle[226] = new coordinate(1192, -976);
            tabelle[227] = new coordinate(1192, -976);
            tabelle[228] = new coordinate(1192, -976);
            tabelle[229] = new coordinate(1280, -856);
            tabelle[230] = new coordinate(1280, -856);
            tabelle[231] = new coordinate(1280, -856);
            tabelle[232] = new coordinate(1280, -856);
            tabelle[233] = new coordinate(1360, -720);
            tabelle[234] = new coordinate(1360, -720);
            tabelle[235] = new coordinate(1360, -720);
            tabelle[236] = new coordinate(1360, -720);
            tabelle[237] = new coordinate(1416, -584);
            tabelle[238] = new coordinate(1416, -584);
            tabelle[239] = new coordinate(1416, -584);
            tabelle[240] = new coordinate(1416, -584);
            tabelle[241] = new coordinate(1472, -440);
            tabelle[242] = new coordinate(1472, -440);
            tabelle[243] = new coordinate(1472, -440);
            tabelle[244] = new coordinate(1472, -440);
            tabelle[245] = new coordinate(1504, -296);
            tabelle[246] = new coordinate(1504, -296);
            tabelle[247] = new coordinate(1504, -296);
            tabelle[248] = new coordinate(1504, -296);
            tabelle[249] = new coordinate(1528, -152);
            tabelle[250] = new coordinate(1528, -152);
            tabelle[251] = new coordinate(1528, -152);
            tabelle[252] = new coordinate(1528, -152);
            tabelle[253] = new coordinate(1536, 0);
            tabelle[254] = new coordinate(1536, 0);
            tabelle[255] = new coordinate(1536, 0);

        }

        public int get_wb(int x, int y, int Drehung)
        {
            int ergebnis = 9999;

            //im ersten Durchlauf nur die Zahlen merken
            if (last_x != 9999)
            {

                //falls wir nicht im ersten Durchlauf sind, gucken ob 2 mal das gleiche kam und wir uns eigentlich Drehen wollten
                if ((last_x == x) && (last_y == y) && (Drehung != 0))
                {
                    //Die Sonderfälle ignorieren, bei denen wir 7 statt 4 Positionen haben
                    if (y != 0)
                    {
                        //Wir wollten uns nach links drehen, also suchen wir die Liste von rechts nach dem Wert
                        if (Drehung == 3)
                        {
                            for (int i = 255; i >= 0; i--)
                            {
                                if ((tabelle[i].x == x) && (tabelle[i].y == y))
                                {
                                    ergebnis = i;
                                    break;
                                }
                            }
                        }
                        //Wir wollten uns nach rechts drehen, also suchen wir die Liste von links nach dem Wert
                        if (Drehung == -3)
                        {
                            for (int i = 0; i <= 255; i++)
                            {
                                if ((tabelle[i].x == x) && (tabelle[i].y == y))
                                {
                                    ergebnis = i;
                                    break;
                                }
                            }
                        }

                    }


                }
            }
            last_x = x;
            last_y = y;

            return ergebnis;
        }
    }

}
