#include "Vector.h"
#include <math.h>

double Vector::DistanceToRay(Vector RayPos, Vector RayDir)
{
	RayPos.x-=x;
	RayPos.y-=y;
	RayPos.z-=z;
	//Jetzt ist dieser Vektor im Ursprung und der Strahl relativ richtig
	double u = ((RayPos.y*RayDir.y)/(-RayDir.x)-RayPos.x)/(RayDir.x+RayDir.y*RayDir.y/RayDir.x);
	Vector v=RayPos+RayDir*u;
	return v.GetLength();
}

bool Vector::isAbout(double dPercentage, Vector &v, int Compare)
{
	switch (Compare) {
		case C_ALL:
			if ((GetLength()>=v.GetLength()*dPercentage)&&
				(GetLength()<=v.GetLength()*(2-dPercentage))&&
				(GetAngle()>=v.GetAngle()*dPercentage)&&
				(GetAngle()<=v.GetAngle()*(2-dPercentage))) return true; 
			else return false;
		break;
		case C_ANGLE:
			if ((GetAngle()>=v.GetAngle()*dPercentage)&&
				(GetAngle()<=v.GetAngle()*(2-dPercentage))) return true; 
			else return false;
		break;
		case C_LENGTH:
			if ((GetLength()>=v.GetLength()*dPercentage)&&
				(GetLength()<=v.GetLength()*(2-dPercentage))) return true; 
			else return false;
		break;
	}
	return false;
}

double Vector::GetAngle()
{
	if ((y==0)&&(x==0)) return 0; else {
		if (y>0)	return atan2(y,x);
		if ((y==0)&&(x<0))	return PI;
		if ((y==0)&&(x>0))	return 0;
		if (y<0)	return 2*PI+atan2(y,x);
	}
	return 0;
}

void Vector::operator +=(const Vector &v)
{
	x+=v.x;
	y+=v.y;
	z+=v.z;
}

Vector Vector::operator + (const Vector &v) const
{
	return Vector(x+v.x,y+v.y,z+v.z);
}

void Vector::operator -=(const Vector &v)
{
	x-=v.x;
	y-=v.y;
	z-=v.z;
}

Vector Vector::operator - (const Vector &v) const
{
	return Vector(x-v.x,y-v.y,z-v.z);
}

void Vector::operator *=(double d)
{
	x*=d;
	y*=d;
	z*=d;
}

void Vector::operator /=(double d)
{
	x/=d;
	y/=d;
	z/=d;
}

Vector Vector::operator * (const double d) const
{
	return Vector(x*d,y*d,z*d);
}

Vector Vector::operator / (const double d) const
{
	return Vector(x/d,y/d,z/d);
}

double Vector::operator *(const Vector &v) const 
{
	return (x*v.x+y*v.y+z*v.z);
}

double Vector::GetSqrLength() const
{
	return(x*x+y*y+z*z);
}

Vector Vector::Negate()
{
	x=-x;
	y=-y;
	z=-z;

	return *this;
}

void Vector::Difference(const Vector &u, const Vector &v)
{
	x=u.x-v.x;
	y=u.y-v.y;
	z=u.z-v.z;
}

double Vector::AngleWith(Vector &v)
{
	return (double) acos( ( (*this) * v )/( (this->GetLength()) * (v.GetLength()) ) );
}

double Vector::GetLength()
{
	return sqrt(x*x+y*y+z*z);
}

Vector Vector::Normalize()
{
	double d=sqrt(x*x+y*y+z*z);
	if (d!=0) { x=x/d; y=y/d; z=z/d; }

	return *this;
}

void Vector::Cross(const Vector &u, const Vector &v)
{
	x=u.y*v.z-v.y*u.z;
	y=v.x*u.z-u.x*v.z;
	z=u.x*v.y-v.x*u.y;
}