#include "Player.h"
#include "lib\utils.h"
#include <fstream>
#include <string>

using namespace std;

CPlayer::CPlayer(void)
{
	dirVec.Set(1,0);
	iFrameCounter=0;
	iStartPoints=0;
	iLastPoints=0;
	iFrameLevel=0;

	for (int i=0; i<=MAX_ASTEROID; i++) 
	{
		iShotAt[i]=0;
		oldPriorities[i]=0;
	}

}

CPlayer::~CPlayer(void)
{
}

void CPlayer::TurnTo(Vector vAim, int iNum)
{
	//vRect rechtwinklig zu AngleVect
	Vector vRect(FrameInfo.vShipDir.y,-FrameInfo.vShipDir.x);
	Vector vToAim=(vAim-FrameInfo.Ship.vPos);
	vToAim.Normalize();
	double d=vToAim*vRect; //Skalarprodukt, d.h. Cos des Winkels zwischen vToAim und vRect
	double dAngle=acos(vToAim*FrameInfo.vShipDir); //Winkel zwischen Schiff und Asteroid
	double dLeft=acos(vToAim*Vector(cos(FrameInfo.dShipAngleLeft),sin(FrameInfo.dShipAngleLeft)));
	double dRight=acos(vToAim*Vector(cos(FrameInfo.dShipAngleRight),sin(FrameInfo.dShipAngleRight)));
	if (d<0) 
	{
		if (abs(dAngle-dLeft)<dAngle)
			MAME->TurnLeft();
		/*else 
		{
			FrameInfo.Asteroids[iNum].iNumShotAt++;
			MAME->Fire();
		}*/
	} else
	if (d>0) {
		if (abs(dAngle-dRight)<dAngle)
			MAME->TurnRight();
/*		else 
		{
			FrameInfo.Asteroids[iNum].iNumShotAt++;
			MAME->Fire();
		}*/
	} 
}

//Berechnet. wohin man schieen muss um "object" zu treffen (mit Schussgeschwindigkeit 8 (die 64))
Vector CPlayer::WhereToShoot(Vector vPos, Vector vDir)
{
	double dx=vDir.x;
	double dy=vDir.y;
	double x=vPos.x-FrameInfo.Ship.vPos.x;
	double y=vPos.y-FrameInfo.Ship.vPos.y;

	double radix=pow(((dx*x+dy*y)/(dx*dx+dy*dy-64)),2)-(x*x+y*y)/(dx*dx+dy*dy-64);
	
	double _t=0;
	if (radix>0) _t=-(dx*x+dy*y)/(dx*dx+dy*dy-64)+sqrt(radix);

	return (vPos+vDir*_t);
}

void CPlayer::DeleteShotAsteroids()
{
		for (int j=0;j<=MAX_ASTEROID;j++)
		{
				if (FrameInfo.Asteroids[j].iStatus==STAT_ASTEROID)
				{
					if ((FrameInfo.Asteroids[j].vPos.GetLength()>60*8)||
						(iShotAt[j]>=1)||
						(FrameInfo.Asteroids[j].iFramesAlive<3)) 
					{
						FrameInfo.Asteroids[j].iStatus=STAT_FREE;
						FrameInfo.iNumAsteroids--;
					}
				}
		}
		
/*	CFrameInfo temp=FrameInfo;
	for (int i=0;i<60;i++)
	{
		for (int j=0;j<MAX_ASTEROID;j++)
		{
			for (int k=0; k<6; k++)
			{
				if (temp.Asteroids[j].iStatus==STAT_ASTEROID)
				{
					if ((temp.Shots[k].vPos-temp.Asteroids[j].vPos).GetLength()<temp.Asteroids[j].dSize)
					{
						FrameInfo.Asteroids[j].iStatus=STAT_FREE;
						FrameInfo.iNumAsteroids--;
						temp.Shots[k].vPos.Set(10000,10000);
						temp.Shots[k].vDir.Set(0,0);
					}
				}
			}
		}
		temp=temp.NextFrame(1);
		temp.Normalize();
	}*/
/*	double t=0;
	double dDistance=0;
	double APosX, APosY, SPosX, SPosY, ADirX, ADirY, SDirX, SDirY;
	for (int i=0; i<FrameInfo.iNumShots; i++)
	{
		SPosX=FrameInfo.Shots[i].vPos.x;
		SPosY=FrameInfo.Shots[i].vPos.y;
		SDirX=FrameInfo.Shots[i].vDir.x;
		SDirY=FrameInfo.Shots[i].vDir.y;
		for (int j=0; j<MAX_ASTEROID; j++)
		{
			if (FrameInfo.Asteroids[j].iStatus==STAT_ASTEROID)
			{
				if (FrameInfo.Asteroids[j].vPos.GetLength()>60*8) FrameInfo.Asteroids[j].iStatus=STAT_FREE;
				if ((FrameInfo.Asteroids[j].vPos-FrameInfo.Shots[i].vPos)*FrameInfo.Shots[i].vDir>0)
				{
					APosX=FrameInfo.Asteroids[j].vPos.x;
					APosY=FrameInfo.Asteroids[j].vPos.y; 
					ADirX=FrameInfo.Asteroids[j].vDir.x;
					ADirY=FrameInfo.Asteroids[j].vDir.y; 
					t=-((ADirX-SDirX)*(APosX-SPosX)+(ADirY-SDirY)*(APosY-SPosY))/(pow(ADirX-SDirX,2.0)+pow(ADirY-SDirY,2.0));
					dDistance=sqrt(pow(t*(ADirX-SDirX)+(APosX-SPosX),2.0)+pow(t*(ADirY-SDirY)+(APosY-SPosY),2.0));
					if (abs(dDistance)<FrameInfo.Asteroids[j].dSize/2) 
					{
						FrameInfo.Asteroids[j].iStatus=STAT_FREE;
					}
				}
			}			
		}
	}*/
}
double CPlayer::CalcPriority(	double distShip, 
								double distShipRay, 
								double dAngle, 
								double inFront, 
								double isAttack, 
								double dSpeed,
								double dSize,
								double dDistToWhereToShoot,
								double isUfo,
								int iFrameNo,
								int LevelFrame,
								int iAstNo)
{
	if (inFront<1) 
		dAngle+=PI/2;

	double dPriority;
	
	dPriority=dAngle/dSize;
	dPriority*=dDistToWhereToShoot;
	if ((isAttack>1)&&(distShipRay<30)&&(distShip/dSpeed<150))
	{
		dPriority/=300*distShip/dSpeed;
	}
	if (isUfo>1) 
		dPriority/=20;

	//dPriority=Sigmoid(distShipRay*distShip,5);//*oldPriorities[iAstNo],1);

	oldPriorities[iAstNo]=dPriority;
	return oldPriorities[iAstNo];
}

void CPlayer::MakeTurn(CMAME *aMAME)
{
	MAME = aMAME;
	FrameInfo=MAME->GetFrameInfo();

	CFrameInfo temp=FrameInfo;
	/*for (int i=0;i<=MAX_ASTEROID;i++)
	{
		if (FrameInfo.Asteroids[i].reset) iShotAt[i]=0;
	}*/

	for (int i=0;i<=MAX_ASTEROID;i++)
	{
		if (((FrameInfo.iFrameNo-iShotAt[i])>70)&&(FrameInfo.Asteroids[i].iStatus==STAT_ASTEROID)) iShotAt[i]=0;
	}

	int iPriority=0;
	DeleteShotAsteroids();
	if ((FrameInfo.iNumAsteroids<=0)&&(temp.iNumAsteroids>0))
	{
		//MAME->Thrust();
	}
	if (FrameInfo.iNumAsteroids<=0)
	for (int i=0;i<=MAX_ASTEROID;i++)
	{
		iShotAt[i]=0;
		oldPriorities[i]=1;
	}
	double dPriority=1.e30;
	double dNearest=1.e30;
	SAsteroid PriorityAsteroid;
	SAsteroid NearestAsteroid;
	bool bAllMovingAway=true;
	for (int i=0;i<=MAX_ASTEROID;i++)
	{
		if (FrameInfo.Asteroids[i].iStatus==STAT_ASTEROID)
		{
			FrameInfo.Asteroids[i].dDistToShip=FrameInfo.Asteroids[i].vPos.GetLength()-FrameInfo.Asteroids[i].dSize;
			FrameInfo.Asteroids[i].isAttacking=(FrameInfo.Asteroids[i].vPos.GetLength()>(FrameInfo.Asteroids[i].vPos+FrameInfo.Asteroids[i].vDir).GetLength());
			//FrameInfo.Asteroids[i].dAngleToShip=acos(FrameInfo.Asteroids[i].vPos*FrameInfo.vShipDir/FrameInfo.Asteroids[i].vPos.GetLength());
			FrameInfo.Asteroids[i].dDistToWhereToShoot=WhereToShoot(FrameInfo.Asteroids[i].vPos,FrameInfo.Asteroids[i].vDir).GetLength();
			FrameInfo.Asteroids[i].dAngleToShip=acos(WhereToShoot(FrameInfo.Asteroids[i].vPos,FrameInfo.Asteroids[i].vDir)*FrameInfo.vShipDir/FrameInfo.Asteroids[i].dDistToWhereToShoot);
			FrameInfo.Asteroids[i].bInFrontOfShip=FrameInfo.Asteroids[i].vPos*FrameInfo.vShipDir>0;
			FrameInfo.Asteroids[i].dDistToShipRay=FrameInfo.Ship.vPos.DistanceToRay(FrameInfo.Asteroids[i].vPos+FrameInfo.Ship.vPos,FrameInfo.Asteroids[i].vDir)-FrameInfo.Asteroids[i].dSize;
			
			FrameInfo.Asteroids[i].dPriority=CalcPriority(	FrameInfo.Asteroids[i].dDistToShip,
															FrameInfo.Asteroids[i].dDistToShipRay,
															FrameInfo.Asteroids[i].dAngleToShip,
															FrameInfo.Asteroids[i].bInFrontOfShip+0.5,
															FrameInfo.Asteroids[i].isAttacking+0.5,
															FrameInfo.Asteroids[i].vDir.GetLength(),
															FrameInfo.Asteroids[i].dSize,
															FrameInfo.Asteroids[i].dDistToWhereToShoot,
															(i==MAX_ASTEROID)+0.5,
															iFrameCounter,
															iFrameLevel,
															i);

			bAllMovingAway=bAllMovingAway&&(!FrameInfo.Asteroids[i].isAttacking);
			if ((FrameInfo.Asteroids[i].dPriority<dPriority))
			{
				dPriority=FrameInfo.Asteroids[i].dPriority;
				PriorityAsteroid=FrameInfo.Asteroids[i];
				iPriority=i;
			}
			if (FrameInfo.Asteroids[i].dDistToShip<dNearest)
			{
				dNearest=FrameInfo.Asteroids[i].dDistToShip;
				NearestAsteroid=FrameInfo.Asteroids[i];
			}
		} 
	}

	this->TurnTo(WhereToShoot(PriorityAsteroid.vPos,PriorityAsteroid.vDir),iPriority);
	//MAME->TurnLeft();

	if ((NearestAsteroid.dDistToShip<15)&&(FrameInfo.iNumAsteroids>0)&&(NearestAsteroid.iStatus==STAT_ASTEROID)) MAME->HyperSpace();	
	//Schauen ob wegen UFO weggesprungen werden muss:
	for (int i=0;i<6;i++)
	{
		//Wenn der Schuss auf das UFO zukommt und nher als 50 Pixel ist...
		if ((FrameInfo.Shots[i].vPos.GetSqrLength()>(FrameInfo.Shots[i].vPos+FrameInfo.Shots[i].vDir).GetSqrLength())
			&&(FrameInfo.Shots[i].vPos.GetLength()<35)
			&&(FrameInfo.UfoPresent))
		{
			MAME->HyperSpace();
		}
	}

	for (int i=0;i<=MAX_ASTEROID;i++)
	{
		if (FrameInfo.Asteroids[i].iStatus==STAT_ASTEROID)
		{
			if (FrameInfo.Asteroids[i].bInFrontOfShip)
			{
				if (WhereToShoot(FrameInfo.Asteroids[i].vPos,FrameInfo.Asteroids[i].vDir).DistanceToRay(FrameInfo.Ship.vPos,FrameInfo.vShipDir)<FrameInfo.Asteroids[i].dSize) 
				{
					iShotAt[i]=FrameInfo.iFrameNo;
					if (FrameInfo.Asteroids[i].dSize>20) MAME->Fire(4,0);
					else if (FrameInfo.Asteroids[i].dSize>10) MAME->Fire(3,0); 
					else MAME->Fire(1,0);
				}
			}
		}
	}

	iFrameCounter++;
	iFrameLevel++;	
	if (FrameInfo.iNumAsteroids==0) iFrameLevel=0;
	if (FrameInfo.iPoints<iLastPoints)
	{
		iFrameCounter=0;
		iStartPoints=FrameInfo.iPoints;
	}
	if (iFrameCounter%1000==0) cout << "Frame: " << iFrameCounter << endl;
	iLastPoints=FrameInfo.iPoints;
}