#pragma once

#include "Communicator.h"
#include "Frame.h"
#include "WinkelByte.h"
#include <math.h>
#include <iostream>
#include <fstream>
#include <map>

using namespace std;

typedef struct pingEntry
{
	unsigned char cKeys;
	char cFramesGone;
	pingEntry()
	{
		cKeys='@';
		cFramesGone=0;
	}
};

class CMAME
{
private:
	CCommunicator UDP;
	CFrame Frame;

	SFramePack FramePack;
	SKeyPack KeyPack;

	ofstream OutFile;

	char cFramesGone, cPrevFrame;
	char cLatenz;
	unsigned char oldPing, oldoldPing;
	vWinkelBytes vPossibleWinkelBytes;

	pingEntry PingMap[256];
	bool firedLastTime;
	int FireCounter, FireTurn;
	SShot Shots[6];
	int iNumShots;
	int iFramesReceived;
	CFrameInfo FrameInfo;
public:
	void SendReceive();
	CFrameInfo GetFrameInfo() { return FrameInfo; }
	void TurnLeft() 
	{ 
		if (!Frame.Alive()) return;
		if (FireCounter==0)
		KeyPack.keys |= KEY_LEFT;
	};
	void TurnRight() 
	{ 
		if (!Frame.Alive()) return;
		if (FireCounter==0)
		KeyPack.keys |= KEY_RIGHT;
	};
	void Thrust() { KeyPack.keys |= KEY_THRUST; };
	void HyperSpace() { KeyPack.keys |= KEY_HYPERSPACE; };
	void Fire(int often,int turn) 
	{ 
		if (FireCounter>0) return;
		FireTurn=turn;
		FireCounter=often;
	};
	void Start() { KeyPack.keys |= KEY_START; };
	CMAME(const char* server_ip_str);
	~CMAME(void);
};
