#include "MAME.h"
#include "lib\utils.h"

CMAME::CMAME(const char* server_ip_str)
{
	UDP.Connect(server_ip_str);
	FrameInfo.iFrameNo=0;
	FrameInfo.cWinkelByte=0;

	iFramesReceived=0;
	for (int i=0; i<256; i++) WinkelBytes[i*3]=i-1;
	WinkelBytes[0]=255;
	OutFile.open("huhu.txt");
	iNumShots=0;

	oldPing=0;oldoldPing=0;

	FireCounter=0;

	firedLastTime=false;
	FireTurn=0;
}

CMAME::~CMAME(void)
{
	OutFile.close();
}

void CMAME::SendReceive()
{
	KeyPack.ping=FramePack.cPing+1;
	if (FireCounter>0)
	{
		if (!firedLastTime) 
		{
			KeyPack.keys |= KEY_FIRE;
			FireCounter--;
			firedLastTime=true;
		}	
	} else FireTurn=0;
	if ((firedLastTime)&&(!(KeyPack.keys&KEY_FIRE))) firedLastTime=false;
	if (FireTurn==1) KeyPack.keys|=KEY_LEFT;
	if (FireTurn==-1) KeyPack.keys|=KEY_RIGHT;
	PingMap[KeyPack.ping].cKeys=KeyPack.keys;
	UDP.SendPacket(KeyPack);
	KeyPack.keys='@';

	UDP.ReceivePacket(FramePack);
	iFramesReceived++;

	cFramesGone=FramePack.cFrameNo-cPrevFrame;
	cLatenz=KeyPack.ping-FramePack.cPing;
	cPrevFrame=FramePack.cFrameNo;

	PingMap[oldPing].cFramesGone=1;//cFramesGone;

	if ((cLatenz>=1)||(cFramesGone!=1))
	{
		cout << cFramesGone-1 << " Frames verloren! Latenz: " << cLatenz*1 << endl;
	}

	Frame.GetInfosFromVectorRam(cFramesGone, FramePack.vectorram);
	Frame.GetFrameInfo(FrameInfo);
	FrameInfo.iFrameNo+=cFramesGone;
	FrameInfo.cLatenz=cLatenz;
	FrameInfo.cFramesGone=cFramesGone;

	if ((FrameInfo.iNumAsteroids==0)||(cFramesGone!=1)) vPossibleWinkelBytes.clear();

	if (!Frame.Alive())
	{
		KeyPack.keys|=KEY_START;
		vPossibleWinkelBytes.clear();
	}

	if (Frame.Alive())
	{
		//oldPing ist das, was ich beim letzten mal empfangen habe, was jetzt also sichtbar sein sollte
		unsigned char temp=oldPing;//Tastenkombi
		if (PingMap[temp].cKeys&KEY_RIGHT)
		{
			if (vPossibleWinkelBytes.size()>=1)
			for (unsigned int i=0;i<vPossibleWinkelBytes.size();i++)
			{
				vPossibleWinkelBytes[i]-=PingMap[temp].cFramesGone;
			}	
		}
		if (PingMap[temp].cKeys&KEY_LEFT)
		{
			if (vPossibleWinkelBytes.size()>=1)
			for (unsigned int i=0;i<vPossibleWinkelBytes.size();i++)
			{
				vPossibleWinkelBytes[i]+=PingMap[temp].cFramesGone;
			}
		}
		if (vPossibleWinkelBytes.size()>1)
		{
			vWinkelBytes vNewPossibleWinkelBytes=GetWinkelBytesByDir(Frame.Ship.iDirX,Frame.Ship.iDirY);
			vPossibleWinkelBytes=Schnittmenge(vPossibleWinkelBytes,vNewPossibleWinkelBytes);
		}
		if (vPossibleWinkelBytes.size()==0)
		{
			vPossibleWinkelBytes=GetWinkelBytesByDir(Frame.Ship.iDirX,Frame.Ship.iDirY);
		}
		FrameInfo.cWinkelByte=vPossibleWinkelBytes[0];

		for (int i=0;i<1+cLatenz;i++)
		{
			temp=FramePack.cPing+i; //Tastenkombis, die noch ncht angewandt wurden
			if (PingMap[temp].cKeys&KEY_RIGHT)
			{
				FrameInfo.cWinkelByte--;
			}
			if (PingMap[temp].cKeys&KEY_LEFT)
			{
				FrameInfo.cWinkelByte++;
			}
		}
		//Setzen des Winkels entsprechend des Winkelbytes
		FrameInfo.dInternalShipAngle=WinkelByteToAngle(FrameInfo.cWinkelByte);
		FrameInfo.cWinkelByte++;
		FrameInfo.dShipAngleLeft=WinkelByteToAngle(FrameInfo.cWinkelByte);
		FrameInfo.cWinkelByte--;FrameInfo.cWinkelByte--;
		FrameInfo.dShipAngleRight=WinkelByteToAngle(FrameInfo.cWinkelByte);
		FrameInfo.cWinkelByte++;
		FrameInfo.vShipDir.Set(cos(FrameInfo.dInternalShipAngle),sin(FrameInfo.dInternalShipAngle));
	}

	FrameInfo=FrameInfo.NextFrame(2+cLatenz);
	FrameInfo.Normalize();

	oldoldPing=oldPing;
	oldPing=FramePack.cPing;
}
