﻿/*
 * Asteroids Player Client 
 * 2008 ct-Wettbewerb
 * 
 * by Stefc (stefan.boether@gmail.com) */

using System;

namespace stefc.asteroids
{
    
    /// <summary>
    /// Represents an object in space
    /// </summary>
    public class SpaceObject: IComparable<SpaceObject>
    {
        private static int idCounter = 0;

        private int frameCount;
        private int totalDx;
        private int totalDy;

        private SpaceObject previous;
        
        public SpaceObject(int x, int y, int size)
        {
            Id = -1;
        
            X = x;
            Y = y;
            Size = size;

            Dx = 0;
            Dy = 0;
            frameCount = 0;
            totalDx = 0;
            totalDy = 0;
        }

        public int Id { get; set; }

        public int X { get; set; }
        public int Y { get; set; }
        public int Size { get; set; }

        public double Dx { get; set; }
        public double Dy { get; set; }

        public void SetPrevious(SpaceObject prev, int latency)
        {
            Previous = prev;

            //Point delta = prev.GetDelta(this);
            //totalDx = prev.totalDx + delta.X;
            //totalDy = prev.totalDy + delta.Y;
            //frameCount = prev.frameCount + 1;
            //Id = prev.Id;

            //Dx = (double)totalDx / (double)frameCount;
            //Dy = (double)totalDy / (double)frameCount;             
        }

        public SpaceObject Previous 
        {
            get 
            { 
                return previous; 
            }
            private set
            {
                int deep = 16;
                if (this is Ufo)
                    deep = 4;
                else if (Size == 14)
                    deep = 64;
                else if (Size == 15)
                    deep = 32;
                    
                previous = value;
                if (value != null)
                    Id = previous.Id;

                SpaceObject first = null;
                int count = 1;
                while ((value != null) && (count<deep))
                {
                    first = value;
                    count++;
                    value = value.Previous;
                }

                if (first != null)
                {
                    Point delta = first.GetDelta(this);
                    Dx = (double)delta.X / (double)count;
                    Dy = (double)delta.Y / (double)count; 
                }
            }
        }

        public virtual int GetRadius()
        {
            return 0;
        }

        /// <summary>
        /// kürzesten Vector zwischen zwei Objekten bestimmen
        /// </summary>
        /// <param name="other"></param>
        /// <returns></returns>
        internal Point GetDelta(SpaceObject other)
        {
            int dx = other.X - X; ;
            while (dx < -(Const.WIDTH / 2)) dx += Const.WIDTH; // dx normalisieren auf -512 ... 511
            while (dx >= (Const.WIDTH / 2)) dx -= Const.WIDTH;

            int dy = other.Y - Y;
            while (dy < -(Const.HEIGHT / 2)) dy += Const.HEIGHT;  // dy normalisieren auf -384 ... 383
            while (dy >= (Const.HEIGHT / 2)) dy -= Const.HEIGHT;

            return new Point(dx, dy);
        }

        internal Vector Position
        {
            get { return Vector.CreateCartesian(X,Y); }
        }

        internal Vector NextPosition
        {
            get {
                return Vector.CreateCartesian(X + Dx, Y + Dy); 
            }
        }
        
        internal Vector Velocity
        {
            get { return Vector.CreateCartesian(Dx, Dy); }
        }

        public static int NextId
        {
            get
            {
                idCounter++;
                return idCounter;
            }
        }

        #region IComparable<SpaceObject> Members
        /// <summary>
        /// Objekte sind nach Größe sortiert
        /// </summary>
        /// <param name="other"></param>
        /// <returns></returns>
        public int CompareTo(SpaceObject other)
        {
            if (other == null)
                return +1;
            return Size.CompareTo(other.Size);
        }

        #endregion

           
    }
}
