package de.dkn.asteroids;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import de.caff.asteroid.MovingGameObject;
import de.dkn.asteroids.DknDecisionPreparer.ExpectedBulletInfo;
import de.dkn.asteroids.DknDecisionPreparer.ShotTargetInfo;
import de.dkn.asteroids.DknDecisionPreparer.TargetHitResult;

/**
 * <p>
 * Diese Klasse bewahrt die Entscheidung des DknDecisionPreparer und die Informationen zur
 * Entscheidungsfindung auf, um sie durch Anhngen an FrameInfo dem AnalysisDisplay zur Verfgung zu
 * stellen.
 * </p>
 * <p>
 * HINWEIS: Die Domain de.dkn gehrt nicht mir, aber ich benutze das Krzel dkn schon sehr lange und
 * meine, bzw. unsere Domain de.familie-damken ist nicht Java-fhig und damit ist de.dkn aus meiner
 * Sicht genauso geeignet wie jede abweichende Schreibweise von de.familie-damken.
 * </p>
 * <p>
 * (c) 2008, by Uwe Damken
 * </p>
 */
public class DknDecisionData {

	protected boolean fire;

	protected boolean hyper;

	protected boolean thrust;

	protected boolean left;

	protected boolean right;

	/** "Angeschossene" Asteroiden oder UFOs: Id -> ShotAsteroidInfo */
	protected Map<Integer, ShotTargetInfo> shotTargets = new HashMap<Integer, ShotTargetInfo>();

	/** Gefhrliche Targets, sortiert nach Entfernung zum Schiff */
	protected List<MovingGameObject> dangerousTargets;

	/** Sehr interessante potenzielle, aber nicht gefhrliche Targets, sortiert */
	protected List<MovingGameObject> highPrioTargets;

	/** Weniger interessante potenzielle, aber nicht gefhrliche Targets, sortiert */
	protected List<MovingGameObject> lowPrioTargets;

	/** Alle nicht angeschossenen Targets zusammen, sortiert */
	protected List<MovingGameObject> allNotShotTargets;

	/** Information vom DknShootingDirPreparer */
	protected String synchInfo;

	/** Welches Target wurde "angedreht"? */
	protected TargetHitResult turnThr;

	/** Welches Target wurde "angeschossen"? */
	protected TargetHitResult fireThr;

	/** Hyperspace eingeleitet? */
	protected boolean hyperInProgress;

	/** Wird beim nchsten Mal ein Treffer erwartet, weil es mit turns == 1 angedreht wurde? */
	protected boolean hitExpectedInNextFrame;

	/** Was fr eine Bullet wird vom Schuss in dieser Entscheidung erwartet? */
	protected ExpectedBulletInfo expectedBulletInfo;

	/**
	 * bernimmt Daten aus dem Stand des Vorgnger-Frames
	 */
	public void inherit(DknDecisionData previous) {
		if (previous != null) {
			for (Map.Entry<Integer, ShotTargetInfo> entry : previous.shotTargets.entrySet()) {
				shotTargets.put(entry.getKey(), (ShotTargetInfo) entry.getValue());
			}
		}
	}

	/**
	 * Liefert true, wenn der baldige Tod dieses Targets erwartet wird.
	 */
	public boolean isDeathExpected(Integer targetIdentity) {
		if (targetIdentity == null || shotTargets == null) {
			return false;
		} else {
			return shotTargets.get(targetIdentity) != null;
		}
	}

	/**
	 * Liefert den Farb-Code des Targets fr die Analyse.
	 */
	public int getColorCode(MovingGameObject target) {
		int code = 0;
		if (target != null) {
			if (isDeathExpected(target.getIdentity())) {
				code += 1;
			}
			if (target.isDangerous()) {
				code += 2;
			}
		}
		// 0-Alive, nicht gefhrlich
		// 1-Death, nicht gefhrlich
		// 2-Alive, gefhrlich
		// 3-Death, gefhrlich
		return code;
	}

	/** Ab hier nur generierte Getter und Setter */

	public String getSynchInfo() {
		return synchInfo;
	}

	public boolean isFire() {
		return fire;
	}

	public boolean isHyper() {
		return hyper;
	}

	public boolean isHitExpectedInNextFrame() {
		return hitExpectedInNextFrame;
	}

	public boolean isLeft() {
		return left;
	}

	public boolean isRight() {
		return right;
	}

	public TargetHitResult getTurnThr() {
		return turnThr;
	}

	public TargetHitResult getFireThr() {
		return fireThr;
	}

	public ExpectedBulletInfo getExpectedBulletInfo() {
		return expectedBulletInfo;
	}

}
