package de.dkn.asteroids;

import de.caff.asteroid.Communication;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.FramePreparerSequence;
import de.caff.asteroid.GameData;
import de.caff.asteroid.HallOfFameFiller;
import de.caff.asteroid.ScoreFixer;

/**
 * <p>
 * Player auf der Basis von rammis hervorragendem Framework, ohne dass ich nicht am Wettbewerb htte
 * teilnehmen knnen.
 * </p>
 * <p>
 * HINWEIS: Die Domain de.dkn gehrt nicht mir, aber ich benutze das Krzel dkn schon sehr lange und
 * meine, bzw. unsere Domain de.familie-damken ist nicht Java-fhig und damit ist de.dkn aus meiner
 * Sicht genauso geeignet wie jede abweichende Schreibweise von de.familie-damken.
 * </p>
 * <p>
 * (c) 2008, by Uwe Damken ... basierend auf einem Framework von Rammi (rammi@caff.de)
 * </p>
 */
public class DknAsteroidsPlayer implements FrameListener, GameData {

	/** The communication object. */
	private Communication com;

	/**
	 * Constructor.
	 */
	public DknAsteroidsPlayer(Communication com) {
		this.com = com;
		com.setFramePreparer(new FramePreparerSequence(new DknVelocityPreparer(), new ScoreFixer(),
				new DknShootingDirPreparer(), new DknDecisionPreparer()));
		com.addFrameListener(new HallOfFameFiller(com, "dkn"));
	}

	/**
	 * Called each time a frame is received.
	 */
	public void frameReceived(FrameInfo frame) {
		if (frame != null) {
			DknDecisionData decision = frame.getDecisionData();
			if (decision.isFire()) {
				com.pushButton(BUTTON_FIRE);
				DknStatistics.getInstance().incrementFirePushed();
			}
			if (decision.isHyper()) {
				com.pushButton(BUTTON_HYPERSPACE);
			}
			if (decision.thrust) {
				com.pushButton(BUTTON_THRUST);
			}
			if (decision.isLeft()) {
				com.pushButton(BUTTON_LEFT);
			}
			if (decision.isRight()) {
				com.pushButton(BUTTON_RIGHT);
			}
		}
	}

}
