// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;

/**
 *  Editable HTTP proxy settings.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public class SwingHttpProxyPropertySettings
        extends EditablePreferenceGroup
        implements PropertyChangeListener
{
  /** Suffix used for the HTTP port of the proxy. */
  public static final String PORT_SUFFIX = "-PORT";
  /** Suffix used for the HTTP host of the proxy. */
  public static final String HOST_SUFFIX = "-HOST";
  /** Suffix used to indicate whether the HTTP proxy is in use. */
  public static final String USED_SUFFIX = "-USED";
  /** Is a proxy used? */
  private final SwingBooleanPreferenceProperty useProxy;
  /** Proxy hostname. */
  private final SwingStringPreferenceProperty  proxyHost;
  /** Proxy port number. */
  private final SwingIntegerPreferenceProperty proxyPort;

  /**
   * Constructor.
   * @param basicName preference base name
   * @param baseTag   I18n resource base tag
   */
  public SwingHttpProxyPropertySettings(String basicName, String baseTag)
  {
    super(baseTag, false);
    useProxy = new SwingBooleanPreferenceProperty(basicName+USED_SUFFIX,
                                                  baseTag+USED_SUFFIX,
                                                  false);
    proxyHost = new SwingStringPreferenceProperty(basicName+HOST_SUFFIX,
                                                  baseTag+HOST_SUFFIX);
    proxyPort = new SwingIntegerPreferenceProperty(basicName+PORT_SUFFIX,
                                                   baseTag+PORT_SUFFIX,
                                                   80,
                                                   1, 65535);
    String pUsed = System.getProperty("proxySet");
    String pHost = System.getProperty("http.proxyHost");
    String pPort = System.getProperty("http.proxyPort");

    if (pUsed != null  &&  Boolean.valueOf(pUsed).booleanValue()) {
      useProxy.setValue(true);
      proxyHost.setValue(pHost);
      proxyPort.setValue(Integer.parseInt(pPort));
    }

    useProxy.addValueChangeListener(this);
    proxyHost.addValueChangeListener(this);
    proxyPort.addValueChangeListener(this);

    addProperty(useProxy);
    addProperty(proxyHost);
    addProperty(proxyPort);
  }

  /**
   * This method gets called when a bound property is changed.
   *
   * @param evt A PropertyChangeEvent object describing the event source
   *            and the property that has changed.
   */

  public void propertyChange(PropertyChangeEvent evt)
  {
    if (useProxy.getValue()) {
      System.setProperty("proxySet", "true");
      final String host = proxyHost.getValue();
      System.setProperty("http.proxyHost", host != null ? host : "");
      System.setProperty("http.proxyPort", Integer.toString(proxyPort.getValue()));
    }
    else {
      Properties properties = System.getProperties();
      properties.remove("http.proxyHost");
      properties.remove("http.proxyPort");
      properties.remove("proxySet");
      System.setProperties(properties);
    }
  }
}
