// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import de.caff.i18n.I18n;

import java.util.ListResourceBundle;

/**
 *  Default i18n resources for the swing package.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public class SettingsResourceBundle
        extends ListResourceBundle
{
  /**
   *  Get the contents of this bundle.
   *  @return  the contents
   */
   public Object[][] getContents() {
    return contents;
  }


  private static final Object[][] contents = {
    // LOCALIZE THIS
    // General
    { "Ok"+I18n.SUFFIX_TEXT,            "Ok" },
    { "Cancel"+I18n.SUFFIX_TEXT,        "Cancel" },

    { "Add"+I18n.SUFFIX_TEXT,           "Add" },
    { "Delete"+I18n.SUFFIX_TEXT,        "Delete" },
    { "Change"+I18n.SUFFIX_TEXT,        "Change" },
    { "Up"+I18n.SUFFIX_TEXT,            "Move Up" },
    { "Down"+I18n.SUFFIX_TEXT,          "Move Down" },


    // Toolbars
    { "tbAdd"+I18n.SUFFIX_TEXT,           "Add" },
    { "ttAdd"+I18n.SUFFIX_TOOLTIP,        "Add URL" },

    { "tbDelete"+I18n.SUFFIX_TEXT,        "Delete" },
    { "ttDelete"+I18n.SUFFIX_TOOLTIP,     "Delete selected URL from list" },

    { "tbChange"+I18n.SUFFIX_TEXT,        "Edit" },
    { "ttChange"+I18n.SUFFIX_TOOLTIP,     "Edit selected URL" },

    { "tbUp"+I18n.SUFFIX_TEXT,            "Move Up" },
    { "ttUp"+I18n.SUFFIX_TOOLTIP,         "Move selected URL one step up" },

    { "tbDown"+I18n.SUFFIX_TEXT,          "Move Down" },
    { "ttDownUrl"+I18n.SUFFIX_TOOLTIP,    "Move selected URL one step down" },

    // title
    { "tiFontUrl",                        "Choose Font URL" },   

    // labels
    { "lbFontUrl"+I18n.SUFFIX_TEXT,       "Font URL:" },

    // buttons
    { "btChangeColor"+I18n.SUFFIX_TEXT,   "Change Color..." },

    { "btFontUrl"+I18n.SUFFIX_TEXT,       "..." },
    { "btFontUrl"+I18n.SUFFIX_TOOLTIP,    "Select local directory" },

    // formats
    { "valueNameFormat", "%0:" },
  };
}
