// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings;

import de.caff.i18n.I18n;

import java.util.Locale;
import java.util.prefs.Preferences;

/**
 *  Enum value representing a locale.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public class LocaleEnumValue
        implements EnumValue
{
  /** The locale. */
  private final Locale locale;

  /**
   *  Create a locale enum value.
   *  @param locale locale to set
   */
  public LocaleEnumValue(Locale locale)
  {
    this.locale = locale;
  }

  /**
   * Get a human readable name for this enum value.
   *
   * @param l locale to use
   * @return human readable short name
   */
  public String getShortName(Locale l)
  {
    return locale == null ?  I18n.getString("localeDefault", l)  :  locale.getDisplayName(l);
  }

  /**
   * Get a longer description which describes this value.
   *
   * @param l locale to use
   * @return human readable description or <code>null</code> if no description is available
   */
  public String getLongName(Locale l)
  {
    return null;
  }

  /**
   * Store this value to the preferences under the given key.
   *
   * @param preferences preferences to store to
   * @param key         key under which to store
   */
  public void storeTo(Preferences preferences, String key)
  {
    if (locale == null) {
      preferences.remove(key);
    }
    else {
      preferences.put(key, locale.toString());
    }
  }

  /**
   * Is this value equal to the value which is stored in the preferences under the given key?
   *
   * @param preferences preferences where a enum value is stored
   * @param key         key under which the enum value is stored
   * @return <code>true</code> if the enum value is equal to the one stored in the preferences,
   *         <code>false</code> otherwise
   */
  public boolean isEqualTo(Preferences preferences, String key)
  {
    String value = preferences.get(key, null);
    return (locale == null  &&  value == null)  ||  (locale != null  &&  locale.toString().equals(value));
  }

  /**
   * Get the real value which is used in this enum.
   *
   * @return the real value
   */
  public Object getRealValue()
  {
    return locale;
  }

  /**
   *  Get the locale.
   *  @return locale (<code>null</code> for default locale
   */
  public Locale getLocale()
  {
    return locale;
  }
}
