// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;

import javax.swing.*;
import java.awt.*;
import java.util.Locale;
import java.util.MissingResourceException;

/**
 *  Localizable chackbox in Swing.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public class RJCheckBox
        extends JCheckBox
        implements Localizable
{
  protected String resTag;         // name of the resource of this menu's name

  /**
   * Creates a check box with text and specifies whether
   * or not it is initially selected.
   * @param resTag    resource tag for text
   * @param selected a boolean value indicating the initial selection
   */
  public RJCheckBox(String resTag, boolean selected)
  {
    super("", selected);
    setTag(resTag);
  }
  
  /**
   * Notifies this component that it now has a parent component.
   * When this method is invoked, the chain of parent components is
   * set up with <code>KeyboardAction</code> event listeners.
   */
  public void addNotify()
  {
    super.addNotify();
    I18n.addLocalizationChangeListener(this);
  }

  /**
   * Overrides <code>JComponent.removeNotify</code> to check if
   * this button is currently set as the default button on the
   * <code>RootPane</code>, and if so, sets the <code>RootPane</code>'s
   * default button to <code>null</code> to ensure the
   * <code>RootPane</code> doesn't hold onto an invalid button reference.
   */
  public void removeNotify()
  {
    I18n.removeLocalizationChangeListener(this);
    super.removeNotify();
  }


  /**
   *  Change the name tag.
   *  @param  tag       new resource tag for the name
   */
  public void setTag(String tag) {
    resTag = tag;
    setText(I18n.getString(resTag+I18n.SUFFIX_TEXT, getLocale()));
    try {
      setToolTipText(I18n.getString(resTag+I18n.SUFFIX_TOOLTIP, getLocale()));
    } catch (MissingResourceException x) {
    }
  }

  /**
   *  Change the locale.
   *  @param  l   new locale
   */
  public void setLocale(Locale l) {
    Locale oldLocale = getLocale();
    super.setLocale(l);
    if (oldLocale != null  &&  !oldLocale.equals(l)) {
      if (resTag != null) {
        setText(I18n.getString(resTag+I18n.SUFFIX_TEXT, l));
        try {
          setToolTipText(I18n.getString(resTag+I18n.SUFFIX_TOOLTIP, getLocale()));
        } catch (MissingResourceException x) {
        }
      }
    }
  }

  /**
   *  Get the locale. Instead of throwing an <code>IllegalComponentStateException</code>
   *  when there's no locale we just return null.
   *  @return the Locale of this Label or null
   */
  public Locale getLocale() {
    try {
      return super.getLocale();
    } catch (IllegalComponentStateException x) {
      return null;
    }
  }
}
