// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.analysis;

import java.util.Collection;

/**
 *  Listener called if dump file markers are changing.
 *  This happens only during read time.
 */
public interface DumpLoadingListener
{
  /**
   * Set the numbers of frames to expect.
   * @param frameCount the expected frame count
   */
  void setExpectedFrames(int frameCount);

  /**
   *  Called if the marks change.
   *  @param marks new list of marks
   */
  void marksChanged(Collection<DumpFile.Mark> marks);

  /**
   * Called if the number of frames changes.
   * @param frameCount new frame count
   */
  void frameCountChanged(int frameCount);
}
