/*
 * Decompiled with CFR 0.152.
 */
package de.dkn.asteroids;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DknStatistics {
    private static DknStatistics instance = new DknStatistics();
    private long sum = 0L;
    private int score = 0;
    private int firePushed = 0;
    private int bulletFits = 0;
    private int bulletAlmostFits = 0;
    private int bulletMissfits = 0;
    private List<Integer> values = new ArrayList<Integer>(18500);

    public static DknStatistics getInstance() {
        return instance;
    }

    public void addValue(int value) {
        this.values.add(value);
        this.sum += (long)value;
    }

    public void incrementFirePushed() {
        ++this.firePushed;
    }

    public void incrementBulletStatistics(boolean fits, boolean almostFits) {
        if (fits) {
            ++this.bulletFits;
        } else if (almostFits) {
            ++this.bulletAlmostFits;
        } else {
            ++this.bulletMissfits;
        }
    }

    public String toString() {
        Collections.sort(this.values);
        int n = this.values.size();
        int bulletsOccured = this.bulletFits + this.bulletAlmostFits + this.bulletMissfits;
        return String.format("Statistics: (n/min/avg/max/10/50/90)=(%d/%d/%d/%d/%d/%d/%d), (pushed/fits/almost/miss/fits ratio/almost ratio)=(%d/%d/%d/%d/%d/%d), score=%d", n, this.values.get(0), this.sum / (long)n, this.values.get(n - 1), this.values.get(n / 10), this.values.get(n / 2), this.values.get(n * 9 / 10), this.firePushed, this.bulletFits, this.bulletAlmostFits, this.bulletMissfits, bulletsOccured == 0 ? 0 : this.bulletFits * 100 / bulletsOccured, bulletsOccured == 0 ? 0 : (this.bulletFits + this.bulletAlmostFits) * 100 / bulletsOccured, this.score);
    }

    public void setScore(int score) {
        this.score = score;
    }

    public int getN() {
        return this.values.size();
    }
}

