/*
 * Decompiled with CFR 0.152.
 */
package de.dkn.asteroids;

import de.caff.asteroid.Communication;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.FramePreparerSequence;
import de.caff.asteroid.GameData;
import de.caff.asteroid.HallOfFameFiller;
import de.caff.asteroid.ScoreFixer;
import de.dkn.asteroids.DknDecisionData;
import de.dkn.asteroids.DknDecisionPreparer;
import de.dkn.asteroids.DknShootingDirPreparer;
import de.dkn.asteroids.DknStatistics;
import de.dkn.asteroids.DknVelocityPreparer;

public class DknAsteroidsPlayer
implements FrameListener,
GameData {
    private Communication com;

    public DknAsteroidsPlayer(Communication com) {
        this.com = com;
        com.setFramePreparer(new FramePreparerSequence(new FramePreparer[]{new DknVelocityPreparer(), new ScoreFixer(), new DknShootingDirPreparer(), new DknDecisionPreparer()}));
        com.addFrameListener(new HallOfFameFiller(com, "dkn"));
    }

    @Override
    public void frameReceived(FrameInfo frame) {
        if (frame != null) {
            DknDecisionData decision = frame.getDecisionData();
            if (decision.isFire()) {
                this.com.pushButton(2);
                DknStatistics.getInstance().incrementFirePushed();
            }
            if (decision.isHyper()) {
                this.com.pushButton(1);
            }
            if (decision.thrust) {
                this.com.pushButton(4);
            }
            if (decision.isLeft()) {
                this.com.pushButton(16);
            }
            if (decision.isRight()) {
                this.com.pushButton(8);
            }
        }
    }
}

