/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.swing.RJButton;
import de.caff.util.settings.BoundsPreferenceProperty;
import de.caff.util.settings.swing.EditorProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class SettingsDialog
extends JDialog {
    private final EditorProvider editorProvider;
    private boolean okay = false;

    static {
        I18n.addAppResourceBase("de.caff.util.settings.swing.SettingsResourceBundle");
    }

    public SettingsDialog(JComponent component, String title, final BoundsPreferenceProperty bpp, EditorProvider editorProvider) {
        super(SettingsDialog.getFrameAncestor(component), title, true);
        this.editorProvider = editorProvider;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)editorProvider.getEditor(), "Center");
        RJButton ok = new RJButton("Ok");
        RJButton cancel = new RJButton("Cancel");
        Box buttons = Box.createHorizontalBox();
        buttons.add(Box.createHorizontalGlue());
        buttons.add(ok);
        buttons.add(cancel);
        buttons.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)buttons, "South");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.ok(bpp);
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.cancel(bpp);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SettingsDialog.this.cancel(bpp);
            }
        });
        this.setDefaultCloseOperation(0);
        if (!bpp.setWindowBounds(this)) {
            this.pack();
            this.setLocationRelativeTo(component);
        }
    }

    private static Frame getFrameAncestor(JComponent comp) {
        Window window = SwingUtilities.getWindowAncestor(comp);
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private void ok(BoundsPreferenceProperty bpp) {
        this.okay = true;
        this.editorProvider.save();
        this.dispose(bpp);
    }

    private void cancel(BoundsPreferenceProperty bpp) {
        this.okay = false;
        this.dispose(bpp);
    }

    public void dispose(BoundsPreferenceProperty bpp) {
        bpp.setBounds(this);
        this.editorProvider.goodBye();
        super.dispose();
    }

    public boolean isUserCancelled() {
        return !this.okay;
    }
}

