/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import java.lang.reflect.Field;

public class ObjectInspector {
    static String getInfo(Object obj) {
        try {
            Class<?> c = obj.getClass();
            String ret = "Object: " + c.getName() + '@' + Integer.toHexString(obj.hashCode()) + '\n';
            ret = String.valueOf(ret) + ObjectInspector.getFields(c, obj);
            return ret;
        }
        catch (Exception x) {
            return "";
        }
    }

    private static String getFields(Class c, Object obj) {
        StringBuffer ret = new StringBuffer("{\n");
        Field[] fields = c.getDeclaredFields();
        int f = 0;
        while (f < fields.length) {
            ret.append('\t').append(fields[f].toString()).append(" = ").append(ObjectInspector.getValue(fields[f], obj)).append(";\n");
            ++f;
        }
        ret.append("}");
        return ret.toString();
    }

    private static String getValue(Field f, Object obj) {
        try {
            f.setAccessible(true);
            StringBuffer ret = new StringBuffer();
            Class<?> type = f.getType();
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    ret.append(f.getInt(obj));
                } else if (type == Boolean.TYPE) {
                    ret.append(f.getBoolean(obj));
                } else if (type == Byte.TYPE) {
                    ret.append(f.getByte(obj));
                } else if (type == Short.TYPE) {
                    ret.append(f.getShort(obj));
                } else if (type == Long.TYPE) {
                    ret.append(f.getLong(obj));
                } else if (type == Float.TYPE) {
                    ret.append(f.getFloat(obj));
                } else if (type == Double.TYPE) {
                    ret.append(f.getDouble(obj));
                }
            } else {
                ret.append(f.get(obj));
            }
            return ret.toString();
        }
        catch (IllegalAccessException x) {
            return "?";
        }
        catch (SecurityException x) {
            return "?";
        }
    }
}

