/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.util.debug.Debug;
import de.caff.util.debug.DebugConstants;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DebugLevelSwitchBoard
extends JPanel
implements Debug.ModeChangeListener,
DebugConstants {
    private JCheckBox _traceCB;
    private JCheckBox _messageCB;
    private JCheckBox _warningCB;
    private JCheckBox _errorCB;
    private JCheckBox _fatalCB;
    private JCheckBox _logCB;
    private JCheckBox _assertCB;
    private JCheckBox _stdoutCB;
    private JCheckBox _stderrCB;

    public DebugLevelSwitchBoard() {
        this.setLayout(new BoxLayout(this, 1));
        this._traceCB = new JCheckBox("Capture trace messages", Debug.getTraceMode());
        this._traceCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Debug.setTraceMode(e.getStateChange() == 1);
            }
        });
        this._traceCB.setToolTipText("Toggles the global setting for trace debug messages.");
        this.add(this._traceCB);
        this._messageCB = new JCheckBox("Capture standard messages", Debug.getStandardMode());
        this._messageCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Debug.setStandardMode(e.getStateChange() == 1);
            }
        });
        this._messageCB.setToolTipText("Toggles the global setting for standard debug messages.");
        this.add(this._messageCB);
        this._warningCB = new JCheckBox("Capture warnings", Debug.getWarningMode());
        this._warningCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Debug.setWarningMode(e.getStateChange() == 1);
            }
        });
        this._warningCB.setToolTipText("Toggles the global setting for warning debug messages.");
        this.add(this._warningCB);
        this._errorCB = new JCheckBox("Capture error messages", Debug.getErrorMode());
        this._errorCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Debug.setErrorMode(e.getStateChange() == 1);
            }
        });
        this._errorCB.setToolTipText("Toggles the global setting for error debug messages.");
        this.add(this._errorCB);
        this._fatalCB = new JCheckBox("Capture fatal error messages", Debug.getFatalMode());
        this._fatalCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Debug.setFatalMode(e.getStateChange() == 1);
            }
        });
        this._fatalCB.setToolTipText("Toggles the global setting for fatal error debug messages.");
        this.add(this._fatalCB);
        this._logCB = new JCheckBox("Capture logging messages", Debug.getLogMode());
        this._logCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Debug.setLogMode(e.getStateChange() == 1);
            }
        });
        this._logCB.setToolTipText("Toggles the global setting for logging messages.");
        this.add(this._logCB);
        this._assertCB = new JCheckBox("Capture failed assertions", Debug.getAssertionMode());
        this._assertCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Debug.setAssertionMode(e.getStateChange() == 1);
            }
        });
        this._assertCB.setToolTipText("Toggles the global setting for failed assertion messages.");
        this.add(this._assertCB);
        this._stdoutCB = new JCheckBox("Capture stdout", Debug.getStdoutCaptureMode());
        this._stdoutCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Debug.setStdoutCaptureMode(e.getStateChange() == 1);
            }
        });
        this._stdoutCB.setToolTipText("If set, messages to stdout are shown as standard messages");
        this.add(this._stdoutCB);
        this._stderrCB = new JCheckBox("Capture stderr", Debug.getStderrCaptureMode());
        this._stderrCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Debug.setStderrCaptureMode(e.getStateChange() == 1);
            }
        });
        this._stderrCB.setToolTipText("If set, messages to stderr are shown as error messages");
        this.add(this._stderrCB);
        Debug.addModeChangeListener(this);
    }

    @Override
    public void modeChanged(int modeID, boolean state) {
        final int id = modeID;
        final boolean st = state;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (id) {
                    case 0: {
                        DebugLevelSwitchBoard.this._traceCB.setSelected(st);
                        break;
                    }
                    case 1: {
                        DebugLevelSwitchBoard.this._messageCB.setSelected(st);
                        break;
                    }
                    case 2: {
                        DebugLevelSwitchBoard.this._warningCB.setSelected(st);
                        break;
                    }
                    case 3: {
                        DebugLevelSwitchBoard.this._errorCB.setSelected(st);
                        break;
                    }
                    case 4: {
                        DebugLevelSwitchBoard.this._fatalCB.setSelected(st);
                        break;
                    }
                    case 5: {
                        DebugLevelSwitchBoard.this._logCB.setSelected(st);
                        break;
                    }
                    case 6: {
                        DebugLevelSwitchBoard.this._assertCB.setSelected(st);
                    }
                }
            }
        });
    }

    @Override
    public void stdoutCaptureChanged(boolean state) {
        final boolean st = state;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebugLevelSwitchBoard.this._stdoutCB.setSelected(st);
            }
        });
    }

    @Override
    public void stderrCaptureChanged(boolean state) {
        final boolean st = state;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebugLevelSwitchBoard.this._stderrCB.setSelected(st);
            }
        });
    }
}

