/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class RJMenuBar
extends JMenuBar
implements Localizable {
    public RJMenuBar(Locale l) {
        this.setLocale(l);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener(this);
    }

    @Override
    public void removeNotify() {
        I18n.removeLocalizationChangeListener(this);
        super.removeNotify();
    }

    @Override
    public void setLocale(Locale l) {
        Locale oldLocale = this.getLocale();
        super.setLocale(l);
        if (oldLocale != null && !oldLocale.equals(l)) {
            int i = this.getMenuCount() - 1;
            while (i >= 0) {
                JMenu m = this.getMenu(i);
                if (m instanceof Localizable) {
                    ((Localizable)((Object)m)).setLocale(l);
                }
                --i;
            }
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException x) {
            return null;
        }
    }

    @Override
    public JMenu add(JMenu m) {
        Localizable l;
        if (m instanceof Localizable && (l = (Localizable)((Object)m)).getLocale() == null) {
            l.setLocale(this.getLocale());
        }
        return super.add(m);
    }
}

