/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.i18n.I18n;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class JDoubleTextField
extends JTextField {
    public static final String DEFAULT_FORMAT = "#####0.0#####";
    private static final Color INVALID_BACKGROUND = new Color(255, 128, 128);
    private Color defaultBG;
    private boolean valid = true;
    private double value;
    private DecimalFormat scanFormat;

    private void init(double initValue, String format) {
        this.value = initValue;
        this.scanFormat = new DecimalFormat(format, new DecimalFormatSymbols(I18n.getDefaultLocale()));
        this.setText(this.scanFormat.format(initValue));
        this.defaultBG = this.getBackground();
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                String text = JDoubleTextField.this.getText();
                ParsePosition pos = new ParsePosition(0);
                Number number = JDoubleTextField.this.scanFormat.parse(text, pos);
                if (number != null && pos.getIndex() == text.length()) {
                    JDoubleTextField.this.valid = true;
                    JDoubleTextField.this.value = number.doubleValue();
                } else {
                    JDoubleTextField.this.valid = false;
                }
                if (JDoubleTextField.this.valid) {
                    JDoubleTextField.this.setBackground(JDoubleTextField.this.defaultBG);
                } else {
                    JDoubleTextField.this.setBackground(INVALID_BACKGROUND);
                }
            }
        });
    }

    public JDoubleTextField() {
        this(0.0);
    }

    public JDoubleTextField(double value) {
        this.init(value, DEFAULT_FORMAT);
    }

    public JDoubleTextField(double value, String format) {
        if (format == null) {
            format = DEFAULT_FORMAT;
        }
        this.init(value, format);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public double getValue() {
        return this.isValid() ? this.value : 0.0;
    }

    public void setValue(double value) {
        this.setText(this.scanFormat.format(value));
    }
}

