/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.server;

import de.caff.asteroid.server.DatagramListener;
import de.caff.asteroid.server.DatagramSender;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketException;

public class Bridge
implements DatagramListener,
Runnable {
    private DatagramSocket socket;
    private DatagramSender sender;
    private SocketAddress clientAddress;

    public Bridge(int port, DatagramSender sender) throws SocketException {
        this.socket = new DatagramSocket(port);
        this.sender = sender;
    }

    @Override
    public void datagramReceived(DatagramPacket packet, DatagramSender sndr) {
        if (this.clientAddress != null) {
            try {
                packet.setSocketAddress(this.clientAddress);
                this.socket.send(packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void datagramSent(DatagramPacket packet) {
    }

    @Override
    public void run() {
        long lastErrorTime = 0L;
        DatagramPacket packet = new DatagramPacket(new byte[8], 8);
        while (true) {
            try {
                while (true) {
                    this.socket.receive(packet);
                    this.clientAddress = packet.getSocketAddress();
                    this.sender.sendDatagram(packet);
                }
            }
            catch (IOException e) {
                long now = System.currentTimeMillis();
                long delta = now - lastErrorTime;
                if (delta < 0L || delta >= 2L) {
                    lastErrorTime = now;
                    e.printStackTrace(System.err);
                    continue;
                }
                return;
            }
            break;
        }
    }
}

