/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Drawable;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.Glyph;
import de.caff.asteroid.Property;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class Text
extends GameObject
implements Drawable {
    public static final Color TEXT_COLOR = Color.gray;
    private static final Map<Character, Glyph> GLYPH_MAP = new HashMap<Character, Glyph>();
    public static final Glyph SPACE_GLYPH;
    public static final Font FONT;
    private final String text;
    private final int scale;

    static {
        byte[] byArray = new byte[21];
        byArray[1] = -8;
        byArray[2] = 7;
        byArray[3] = -4;
        byArray[4] = -12;
        byArray[5] = 7;
        byArray[6] = -8;
        byArray[7] = -8;
        byArray[8] = 7;
        byArray[9] = -8;
        byArray[11] = 7;
        byArray[13] = -4;
        byArray[15] = -8;
        byArray[16] = -4;
        byArray[17] = 7;
        byArray[18] = -12;
        GLYPH_MAP.put(Character.valueOf('A'), new Glyph(byArray));
        byte[] byArray2 = new byte[36];
        byArray2[1] = -12;
        byArray2[2] = 7;
        byArray2[3] = -6;
        byArray2[4] = -12;
        byArray2[5] = 7;
        byArray2[6] = -8;
        byArray2[7] = -10;
        byArray2[8] = 7;
        byArray2[9] = -8;
        byArray2[10] = -8;
        byArray2[11] = 7;
        byArray2[12] = -6;
        byArray2[13] = -6;
        byArray2[14] = 7;
        byArray2[16] = -6;
        byArray2[17] = 7;
        byArray2[18] = -6;
        byArray2[19] = -6;
        byArray2[21] = -8;
        byArray2[22] = -4;
        byArray2[23] = 7;
        byArray2[24] = -8;
        byArray2[25] = -2;
        byArray2[26] = 7;
        byArray2[27] = -6;
        byArray2[29] = 7;
        byArray2[32] = 7;
        byArray2[33] = -12;
        GLYPH_MAP.put(Character.valueOf('B'), new Glyph(byArray2));
        byte[] byArray3 = new byte[15];
        byArray3[1] = -12;
        byArray3[2] = 7;
        byArray3[3] = -8;
        byArray3[4] = -12;
        byArray3[5] = 7;
        byArray3[9] = -8;
        byArray3[11] = 7;
        byArray3[12] = -12;
        GLYPH_MAP.put(Character.valueOf('C'), new Glyph(byArray3));
        byte[] byArray4 = new byte[21];
        byArray4[1] = -12;
        byArray4[2] = 7;
        byArray4[3] = -4;
        byArray4[4] = -12;
        byArray4[5] = 7;
        byArray4[6] = -8;
        byArray4[7] = -8;
        byArray4[8] = 7;
        byArray4[9] = -8;
        byArray4[10] = -4;
        byArray4[11] = 7;
        byArray4[12] = -4;
        byArray4[14] = 7;
        byArray4[17] = 7;
        byArray4[18] = -12;
        GLYPH_MAP.put(Character.valueOf('D'), new Glyph(byArray4));
        byte[] byArray5 = new byte[21];
        byArray5[1] = -12;
        byArray5[2] = 7;
        byArray5[3] = -8;
        byArray5[4] = -12;
        byArray5[5] = 7;
        byArray5[6] = -6;
        byArray5[7] = -6;
        byArray5[10] = -6;
        byArray5[11] = 7;
        byArray5[15] = -8;
        byArray5[17] = 7;
        byArray5[18] = -12;
        GLYPH_MAP.put(Character.valueOf('E'), new Glyph(byArray5));
        byte[] byArray6 = new byte[18];
        byArray6[1] = -12;
        byArray6[2] = 7;
        byArray6[3] = -8;
        byArray6[4] = -12;
        byArray6[5] = 7;
        byArray6[6] = -6;
        byArray6[7] = -6;
        byArray6[10] = -6;
        byArray6[11] = 7;
        byArray6[15] = -12;
        GLYPH_MAP.put(Character.valueOf('F'), new Glyph(byArray6));
        byte[] byArray7 = new byte[24];
        byArray7[1] = -12;
        byArray7[2] = 7;
        byArray7[3] = -8;
        byArray7[4] = -12;
        byArray7[5] = 7;
        byArray7[6] = -8;
        byArray7[7] = -8;
        byArray7[8] = 7;
        byArray7[9] = -4;
        byArray7[10] = -4;
        byArray7[12] = -8;
        byArray7[13] = -4;
        byArray7[14] = 7;
        byArray7[15] = -8;
        byArray7[17] = 7;
        byArray7[20] = 7;
        byArray7[21] = -12;
        GLYPH_MAP.put(Character.valueOf('G'), new Glyph(byArray7));
        byte[] byArray8 = new byte[18];
        byArray8[1] = -12;
        byArray8[2] = 7;
        byArray8[4] = -6;
        byArray8[6] = -8;
        byArray8[7] = -6;
        byArray8[8] = 7;
        byArray8[9] = -8;
        byArray8[10] = -12;
        byArray8[12] = -8;
        byArray8[14] = 7;
        byArray8[15] = -12;
        GLYPH_MAP.put(Character.valueOf('H'), new Glyph(byArray8));
        byte[] byArray9 = new byte[18];
        byArray9[0] = -8;
        byArray9[2] = 7;
        byArray9[3] = -4;
        byArray9[6] = -4;
        byArray9[7] = -12;
        byArray9[8] = 7;
        byArray9[9] = -8;
        byArray9[10] = -12;
        byArray9[13] = -12;
        byArray9[14] = 7;
        byArray9[15] = -12;
        GLYPH_MAP.put(Character.valueOf('I'), new Glyph(byArray9));
        byte[] byArray10 = new byte[15];
        byArray10[1] = -4;
        byArray10[3] = -4;
        byArray10[5] = 7;
        byArray10[6] = -8;
        byArray10[8] = 7;
        byArray10[9] = -8;
        byArray10[10] = -12;
        byArray10[11] = 7;
        byArray10[12] = -12;
        GLYPH_MAP.put(Character.valueOf('J'), new Glyph(byArray10));
        byte[] byArray11 = new byte[15];
        byArray11[1] = -12;
        byArray11[2] = 7;
        byArray11[3] = -6;
        byArray11[4] = -12;
        byArray11[7] = -6;
        byArray11[8] = 7;
        byArray11[9] = -6;
        byArray11[11] = 7;
        byArray11[12] = -12;
        GLYPH_MAP.put(Character.valueOf('K'), new Glyph(byArray11));
        byte[] byArray12 = new byte[12];
        byArray12[1] = -12;
        byArray12[5] = 7;
        byArray12[6] = -8;
        byArray12[8] = 7;
        byArray12[9] = -12;
        GLYPH_MAP.put(Character.valueOf('L'), new Glyph(byArray12));
        byte[] byArray13 = new byte[15];
        byArray13[1] = -12;
        byArray13[2] = 7;
        byArray13[3] = -4;
        byArray13[4] = -8;
        byArray13[5] = 7;
        byArray13[6] = -8;
        byArray13[7] = -12;
        byArray13[8] = 7;
        byArray13[9] = -8;
        byArray13[11] = 7;
        byArray13[12] = -12;
        GLYPH_MAP.put(Character.valueOf('M'), new Glyph(byArray13));
        byte[] byArray14 = new byte[12];
        byArray14[1] = -12;
        byArray14[2] = 7;
        byArray14[3] = -8;
        byArray14[5] = 7;
        byArray14[6] = -8;
        byArray14[7] = -12;
        byArray14[8] = 7;
        byArray14[9] = -12;
        GLYPH_MAP.put(Character.valueOf('N'), new Glyph(byArray14));
        byte[] byArray15 = new byte[15];
        byArray15[1] = -12;
        byArray15[2] = 7;
        byArray15[3] = -8;
        byArray15[4] = -12;
        byArray15[5] = 7;
        byArray15[6] = -8;
        byArray15[8] = 7;
        byArray15[11] = 7;
        byArray15[12] = -12;
        GLYPH_MAP.put(Character.valueOf('0'), new Glyph(byArray15));
        byte[] byArray16 = new byte[18];
        byArray16[1] = -12;
        byArray16[2] = 7;
        byArray16[3] = -8;
        byArray16[4] = -12;
        byArray16[5] = 7;
        byArray16[6] = -8;
        byArray16[7] = -6;
        byArray16[8] = 7;
        byArray16[10] = -6;
        byArray16[11] = 7;
        byArray16[12] = -6;
        byArray16[15] = -12;
        GLYPH_MAP.put(Character.valueOf('P'), new Glyph(byArray16));
        byte[] byArray17 = new byte[24];
        byArray17[1] = -12;
        byArray17[2] = 7;
        byArray17[3] = -8;
        byArray17[4] = -12;
        byArray17[5] = 7;
        byArray17[6] = -8;
        byArray17[7] = -4;
        byArray17[8] = 7;
        byArray17[9] = -4;
        byArray17[11] = 7;
        byArray17[14] = 7;
        byArray17[15] = -4;
        byArray17[16] = -4;
        byArray17[18] = -8;
        byArray17[20] = 7;
        byArray17[21] = -12;
        GLYPH_MAP.put(Character.valueOf('Q'), new Glyph(byArray17));
        byte[] byArray18 = new byte[21];
        byArray18[1] = -12;
        byArray18[2] = 7;
        byArray18[3] = -8;
        byArray18[4] = -12;
        byArray18[5] = 7;
        byArray18[6] = -8;
        byArray18[7] = -6;
        byArray18[8] = 7;
        byArray18[10] = -6;
        byArray18[11] = 7;
        byArray18[12] = -2;
        byArray18[13] = -6;
        byArray18[15] = -8;
        byArray18[17] = 7;
        byArray18[18] = -12;
        GLYPH_MAP.put(Character.valueOf('R'), new Glyph(byArray18));
        byte[] byArray19 = new byte[18];
        byArray19[0] = -8;
        byArray19[2] = 7;
        byArray19[3] = -8;
        byArray19[4] = -6;
        byArray19[5] = 7;
        byArray19[7] = -6;
        byArray19[8] = 7;
        byArray19[10] = -12;
        byArray19[11] = 7;
        byArray19[12] = -8;
        byArray19[13] = -12;
        byArray19[14] = 7;
        byArray19[15] = -12;
        GLYPH_MAP.put(Character.valueOf('S'), new Glyph(byArray19));
        byte[] byArray20 = new byte[15];
        byArray20[0] = -4;
        byArray20[3] = -4;
        byArray20[4] = -12;
        byArray20[5] = 7;
        byArray20[7] = -12;
        byArray20[9] = -8;
        byArray20[10] = -12;
        byArray20[11] = 7;
        byArray20[12] = -12;
        GLYPH_MAP.put(Character.valueOf('T'), new Glyph(byArray20));
        byte[] byArray21 = new byte[15];
        byArray21[1] = -12;
        byArray21[5] = 7;
        byArray21[6] = -8;
        byArray21[8] = 7;
        byArray21[9] = -8;
        byArray21[10] = -12;
        byArray21[11] = 7;
        byArray21[12] = -12;
        GLYPH_MAP.put(Character.valueOf('U'), new Glyph(byArray21));
        byte[] byArray22 = new byte[12];
        byArray22[1] = -12;
        byArray22[3] = -4;
        byArray22[5] = 7;
        byArray22[6] = -8;
        byArray22[7] = -12;
        byArray22[8] = 7;
        byArray22[9] = -12;
        GLYPH_MAP.put(Character.valueOf('V'), new Glyph(byArray22));
        byte[] byArray23 = new byte[18];
        byArray23[1] = -12;
        byArray23[5] = 7;
        byArray23[6] = -4;
        byArray23[7] = -4;
        byArray23[8] = 7;
        byArray23[9] = -8;
        byArray23[11] = 7;
        byArray23[12] = -8;
        byArray23[13] = -12;
        byArray23[14] = 7;
        byArray23[15] = -12;
        GLYPH_MAP.put(Character.valueOf('W'), new Glyph(byArray23));
        byte[] byArray24 = new byte[12];
        byArray24[0] = -8;
        byArray24[1] = -12;
        byArray24[2] = 7;
        byArray24[4] = -12;
        byArray24[6] = -8;
        byArray24[8] = 7;
        byArray24[9] = -12;
        GLYPH_MAP.put(Character.valueOf('X'), new Glyph(byArray24));
        byte[] byArray25 = new byte[18];
        byArray25[0] = -4;
        byArray25[3] = -4;
        byArray25[4] = -8;
        byArray25[5] = 7;
        byArray25[7] = -12;
        byArray25[8] = 7;
        byArray25[9] = -8;
        byArray25[10] = -12;
        byArray25[12] = -4;
        byArray25[13] = -8;
        byArray25[14] = 7;
        byArray25[15] = -12;
        GLYPH_MAP.put(Character.valueOf('Y'), new Glyph(byArray25));
        byte[] byArray26 = new byte[15];
        byArray26[1] = -12;
        byArray26[3] = -8;
        byArray26[4] = -12;
        byArray26[5] = 7;
        byArray26[8] = 7;
        byArray26[9] = -8;
        byArray26[11] = 7;
        byArray26[12] = -12;
        GLYPH_MAP.put(Character.valueOf('Z'), new Glyph(byArray26));
        byte[] byArray27 = new byte[3];
        byArray27[0] = -12;
        GLYPH_MAP.put(Character.valueOf(' '), new Glyph(byArray27, new Rectangle(0, 0, 8, 12)));
        byte[] byArray28 = new byte[9];
        byArray28[0] = -4;
        byArray28[3] = -4;
        byArray28[4] = -12;
        byArray28[5] = 7;
        byArray28[6] = -12;
        GLYPH_MAP.put(Character.valueOf('1'), new Glyph(byArray28));
        byte[] byArray29 = new byte[21];
        byArray29[1] = -12;
        byArray29[3] = -8;
        byArray29[4] = -12;
        byArray29[5] = 7;
        byArray29[6] = -8;
        byArray29[7] = -6;
        byArray29[8] = 7;
        byArray29[10] = -6;
        byArray29[11] = 7;
        byArray29[14] = 7;
        byArray29[15] = -8;
        byArray29[17] = 7;
        byArray29[18] = -12;
        GLYPH_MAP.put(Character.valueOf('2'), new Glyph(byArray29));
        byte[] byArray30 = new byte[18];
        byArray30[0] = -8;
        byArray30[2] = 7;
        byArray30[3] = -8;
        byArray30[4] = -12;
        byArray30[5] = 7;
        byArray30[7] = -12;
        byArray30[8] = 7;
        byArray30[10] = -6;
        byArray30[12] = -8;
        byArray30[13] = -6;
        byArray30[14] = 7;
        byArray30[15] = -12;
        GLYPH_MAP.put(Character.valueOf('3'), new Glyph(byArray30));
        byte[] byArray31 = new byte[18];
        byArray31[1] = -12;
        byArray31[4] = -6;
        byArray31[5] = 7;
        byArray31[6] = -8;
        byArray31[7] = -6;
        byArray31[8] = 7;
        byArray31[9] = -8;
        byArray31[10] = -12;
        byArray31[12] = -8;
        byArray31[14] = 7;
        byArray31[15] = -12;
        GLYPH_MAP.put(Character.valueOf('4'), new Glyph(byArray31));
        byte[] byArray32 = new byte[18];
        byArray32[0] = -8;
        byArray32[2] = 7;
        byArray32[3] = -8;
        byArray32[4] = -6;
        byArray32[5] = 7;
        byArray32[7] = -6;
        byArray32[8] = 7;
        byArray32[10] = -12;
        byArray32[11] = 7;
        byArray32[12] = -8;
        byArray32[13] = -12;
        byArray32[14] = 7;
        byArray32[15] = -12;
        GLYPH_MAP.put(Character.valueOf('5'), new Glyph(byArray32));
        byte[] byArray33 = new byte[18];
        byArray33[1] = -6;
        byArray33[3] = -8;
        byArray33[4] = -6;
        byArray33[5] = 7;
        byArray33[6] = -8;
        byArray33[8] = 7;
        byArray33[11] = 7;
        byArray33[13] = -12;
        byArray33[14] = 7;
        byArray33[15] = -12;
        GLYPH_MAP.put(Character.valueOf('6'), new Glyph(byArray33));
        byte[] byArray34 = new byte[12];
        byArray34[1] = -12;
        byArray34[3] = -8;
        byArray34[4] = -12;
        byArray34[5] = 7;
        byArray34[6] = -8;
        byArray34[8] = 7;
        byArray34[9] = -12;
        GLYPH_MAP.put(Character.valueOf('7'), new Glyph(byArray34));
        byte[] byArray35 = new byte[21];
        byArray35[0] = -8;
        byArray35[2] = 7;
        byArray35[3] = -8;
        byArray35[4] = -12;
        byArray35[5] = 7;
        byArray35[7] = -12;
        byArray35[8] = 7;
        byArray35[11] = 7;
        byArray35[13] = -6;
        byArray35[15] = -8;
        byArray35[16] = -6;
        byArray35[17] = 7;
        byArray35[18] = -12;
        GLYPH_MAP.put(Character.valueOf('8'), new Glyph(byArray35));
        byte[] byArray36 = new byte[18];
        byArray36[0] = -8;
        byArray36[3] = -8;
        byArray36[4] = -12;
        byArray36[5] = 7;
        byArray36[7] = -12;
        byArray36[8] = 7;
        byArray36[10] = -6;
        byArray36[11] = 7;
        byArray36[12] = -8;
        byArray36[13] = -6;
        byArray36[14] = 7;
        byArray36[15] = -12;
        GLYPH_MAP.put(Character.valueOf('9'), new Glyph(byArray36));
        byte[] byArray37 = new byte[9];
        byArray37[0] = -4;
        byArray37[1] = -8;
        byArray37[3] = -4;
        byArray37[4] = -12;
        byArray37[5] = 7;
        byArray37[6] = -12;
        GLYPH_MAP.put(Character.valueOf('\''), new Glyph(byArray37));
        SPACE_GLYPH = GLYPH_MAP.get(Character.valueOf(' '));
        FONT = new Font("Monospaced", 0, 14);
    }

    public Text(String text, int x, int y, int scale) {
        super(x, y);
        this.text = text;
        this.scale = (int)Math.pow(2.0, scale);
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return String.format("Text(%s)@(%d,%d)", this.text, this.x, this.y);
    }

    public boolean hasLocation(int px, int py) {
        return px == this.x && py == this.y;
    }

    public boolean hasLocation(Point p) {
        return this.hasLocation(p.x, p.y);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bounds = null;
        AffineTransform trafo = AffineTransform.getScaleInstance(this.scale, this.scale);
        Point offset = new Point(this.x, this.y);
        char[] cArray = this.text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            Glyph glyph = GLYPH_MAP.get(Character.valueOf(ch));
            if (glyph == null) {
                glyph = SPACE_GLYPH;
            }
            Rectangle glyphBounds = glyph.getBounds(trafo);
            glyphBounds.translate(offset.x, offset.y);
            bounds = bounds == null ? glyphBounds : bounds.union(glyphBounds);
            Point glyphOffset = glyph.getOffset();
            offset.x += this.scale * glyphOffset.x;
            offset.y += this.scale * glyphOffset.y;
            ++n2;
        }
        if (bounds == null) {
            bounds = new Rectangle(this.x, this.y, 1, 1);
        }
        return bounds;
    }

    public int getScale() {
        return this.scale;
    }

    public Font getFont() {
        return FONT.deriveFont((float)(FONT.getSize() * this.scale));
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<String>("Text", this.getText()));
        props.add(new Property<Integer>("Scale", this.getScale()));
        return props;
    }

    @Override
    public String getObjectType() {
        return "Text";
    }

    @Override
    public void draw(Graphics2D g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(this.x, this.y);
        g2.setColor(TEXT_COLOR);
        Text.drawText(g2, this.text, this.scale);
    }

    public static void drawText(Graphics2D g, String text, double scale) {
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            Glyph glyph = GLYPH_MAP.get(Character.valueOf(ch));
            if (glyph == null) {
                glyph = SPACE_GLYPH;
            }
            glyph.drawAndTranslate(g, scale);
            ++n2;
        }
    }

    public static Glyph getGlyph(char ch) {
        return GLYPH_MAP.get(Character.valueOf(ch));
    }

    public static Glyph getGlyph(char ch, Glyph fallback) {
        Glyph glyph = Text.getGlyph(ch);
        return glyph == null ? fallback : glyph;
    }

    public static Rectangle getTextBounds(String text, double scale) {
        Rectangle bounds = null;
        AffineTransform trafo = AffineTransform.getScaleInstance(scale, scale);
        Point offset = new Point();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            Glyph glyph = GLYPH_MAP.get(Character.valueOf(ch));
            if (glyph == null) {
                glyph = SPACE_GLYPH;
            }
            Rectangle glyphBounds = glyph.getBounds(trafo);
            glyphBounds.translate(offset.x, offset.y);
            bounds = bounds == null ? glyphBounds : bounds.union(glyphBounds);
            Point glyphOffset = glyph.getOffset();
            offset.x = (int)((double)offset.x + scale * (double)glyphOffset.x);
            offset.y = (int)((double)offset.y + scale * (double)glyphOffset.y);
            ++n2;
        }
        return bounds;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Render text in asteroids font.");
            System.out.println("  Understanding the following arguments:");
            System.out.println("  [-a] [-b <border>] [-s <scale>] [-r <radius>] [-l <width>] <filename> text ...");
            System.out.println("\t-a             use antialias [Default: off]");
            System.out.println("\t-b <border>    border around text [Default: 20]");
            System.out.println("\t-s <scale>     scaling for text [Default: 1 (12 pixel)]");
            System.out.println("\t-r <radius>    corner radius [Default: 0]");
            System.out.println("\t-l <width>     line width");
            System.out.println("\t<filename>     name of output file (in PNG format)");
            System.out.println("\ttext           text to render");
            System.exit(0);
        }
        boolean antialias = false;
        String filename = null;
        String text = null;
        double scale = 1.0;
        int border = 20;
        int roundness = 0;
        int lineWidth = 1;
        int a = 0;
        while (a < args.length) {
            if ("-a".equals(args[a])) {
                antialias = true;
            } else if ("-b".equals(args[a])) {
                border = Integer.parseInt(args[++a]);
            } else if ("-s".equals(args[a])) {
                scale = Double.parseDouble(args[++a]);
            } else if ("-r".equals(args[a])) {
                roundness = Integer.parseInt(args[++a]);
            } else if ("-l".equals(args[a])) {
                lineWidth = Integer.parseInt(args[++a]);
            } else if (filename == null) {
                filename = args[a];
            } else {
                text = text == null ? args[a] : String.valueOf(text) + " " + args[a];
            }
            ++a;
        }
        text = FrameInfo.canonize(text);
        Rectangle bounds = Text.getTextBounds(text, scale);
        BufferedImage image = new BufferedImage(2 * border + bounds.width, 2 * border + bounds.height, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(Color.black);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        System.out.println("bounds=" + bounds);
        System.out.println("image: " + image.getWidth() + "x" + image.getHeight());
        if (roundness > 0) {
            g.fillRoundRect(0, 0, image.getWidth(), image.getHeight(), roundness, roundness);
        } else {
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        Point offset = new Point(bounds.x + (image.getWidth() - bounds.width) / 2, bounds.y + (image.getHeight() - bounds.height) / 2 + bounds.height);
        g.translate(offset.x, offset.y);
        g.scale(1.0, -1.0);
        g.setStroke(new BasicStroke(lineWidth, 1, 1));
        g.setColor(Color.gray);
        Text.drawText(g, text, scale);
        ImageIO.write((RenderedImage)image, "PNG", new File(filename));
        System.out.println("Written '" + text + "' to " + filename);
    }
}

