/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.GameObject;
import de.caff.asteroid.Property;
import de.caff.asteroid.SpaceShip;
import de.caff.util.Tools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Collection;

public abstract class MovingGameObject
extends GameObject {
    public static final int NO_SCORE = 0;
    protected static final boolean WATCH_VELOCITIES = false;
    private static int minY = Integer.MAX_VALUE;
    private static int maxY = Integer.MIN_VALUE;
    private static final int ARROW_HEAD_SIZE = 8;
    private static final GeneralPath ARROW_HEAD = new GeneralPath();
    private double vx;
    private double vy;
    private int lifetime;
    private Integer identity;
    private int originX;
    private int originY;
    private int squaredDistanceToShip;
    private int hitShipInFrames;
    private int lastHitShipInFrames;
    private int dangerousDetected;
    private boolean dangerous;

    static {
        ARROW_HEAD.moveTo(0.0f, 0.0f);
        ARROW_HEAD.lineTo(-8.0f, 8.0f);
        ARROW_HEAD.lineTo(-8.0f, -8.0f);
        ARROW_HEAD.closePath();
    }

    protected MovingGameObject(int x, int y) {
        super(x, y);
    }

    public Point getCenter() {
        return new Point(this.x, this.y);
    }

    public abstract int getSize();

    @Override
    public void draw(Graphics2D g) {
        g.setColor(Color.white);
        int size = this.getSize();
        g.drawOval(this.x - size, this.y - size, 2 * size, 2 * size);
        this.drawVelocityVector(g, Color.red);
    }

    public int getSquaredSize() {
        int size = this.getSize();
        return size * size;
    }

    public void setVelocity(double x, double y) {
        this.vx = x;
        this.vy = y;
    }

    public void setVelocity(Point2D v) {
        this.setVelocity(v.getX(), v.getY());
    }

    public void setVelocityFromDelta(MovingGameObject obj) {
        if (obj != null) {
            this.setVelocity(obj.getDelta(this));
        }
    }

    public double getVelocityX() {
        return this.vx;
    }

    public double getVelocityY() {
        return this.vy;
    }

    public Point2D getVelocity() {
        return new Point2D.Double(this.vx, this.vy);
    }

    public double getVelocityAngle() {
        return this.vx != 0.0 || this.vy != 0.0 ? Math.atan2(this.vy, this.vx) : -Math.PI;
    }

    public boolean hasKnownVelocity() {
        return this.vx != 0.0 || this.vy != 0.0;
    }

    protected void drawVelocityVector(Graphics2D g, Color color) {
        if (this.vx != 0.0 || this.vy != 0.0) {
            int scale = 16;
            g.setColor(color);
            g.drawLine(this.x, this.y, this.x + (int)((double)scale * this.vx), this.y + (int)((double)scale * this.vy));
            double angle = Math.atan2(this.vy, this.vx);
            AffineTransform at = AffineTransform.getTranslateInstance((double)this.x + (double)scale * this.vx, (double)this.y + (double)scale * this.vy);
            at.concatenate(AffineTransform.getRotateInstance(angle));
            g.fill(at.createTransformedShape(ARROW_HEAD));
        }
    }

    @Override
    public Rectangle getBounds() {
        Point center = this.getCenter();
        int size = this.getSize();
        return new Rectangle(center.x - size, center.y - size, 2 * size, 2 * size);
    }

    public Point getNextLocation() {
        return new Point(this.getX() + (int)this.getVelocityX(), this.getY() + (int)this.getVelocityY());
    }

    public Point getPredictedLocation(int nrFrames) {
        return new Point(this.getX() + (int)((double)nrFrames * this.getVelocityX()), this.getY() + (int)((double)nrFrames * this.getVelocityY()));
    }

    public Point2D getPredictedLocation(double nrFrames) {
        return new Point2D.Double((double)this.getX() + nrFrames * this.getVelocityX(), (double)this.getY() + nrFrames * this.getVelocityY());
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<Integer>("ID", this.getIdentity()));
        props.add(new Property<Integer>("Size", this.getSize()));
        props.add(new Property<Rectangle>("Bounds", this.getBounds()));
        props.add(new Property<Point2D>("Velocity", this.getVelocity()));
        props.add(new Property<Double>("Velocity Angle (\u00b0)", 180.0 * this.getVelocityAngle() / Math.PI));
        props.add(new Property<Point>("Origin", new Point(this.originX, this.originY)));
        props.add(new Property<Integer>("Lifetime", this.getLifetime()));
        props.add(new Property<Integer>("Hit ship in frames", this.hitShipInFrames));
        props.add(new Property<Integer>("dangerousDetected", this.dangerousDetected));
        return props;
    }

    public int getScore() {
        return 0;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public Integer getIdentity() {
        return this.identity;
    }

    public void setIdentity(Integer identity) {
        this.identity = identity;
    }

    public void inheret(MovingGameObject obj) {
        this.setIdentity(obj.getIdentity());
        this.originX = obj.getOriginX();
        this.originY = obj.getOriginY();
        this.dangerous = obj.isDangerous();
        this.dangerousDetected = obj.getDangerousDetected();
    }

    public boolean isHitting(MovingGameObject other, int frames) {
        Point delta = MovingGameObject.getTorusDelta(this.getPredictedLocation(frames), other.getPredictedLocation(frames));
        return (double)(delta.x * delta.x + delta.y * delta.y) < Tools.square(this.getSize() + other.getSize());
    }

    public int hitInFrames(MovingGameObject other, int fromFrames, int toFrames) {
        int f = fromFrames;
        while (f < toFrames + 1) {
            if (this.isHitting(other, f)) {
                return f;
            }
            ++f;
        }
        return 0;
    }

    public int hitInFrames(MovingGameObject other, int toFrames) {
        return this.hitInFrames(other, 1, toFrames);
    }

    public void setShipRelatedValues(SpaceShip ship, int toFrames) {
        this.squaredDistanceToShip = this.getSquaredDistance(ship);
        this.hitShipInFrames = this.hitInFrames(ship, toFrames);
        if (this.hitShipInFrames > 0) {
            this.lastHitShipInFrames = this.hitShipInFrames;
            this.dangerousDetected = 10;
            this.dangerous = true;
        } else if (this.dangerous && --this.dangerousDetected <= 0) {
            this.lastHitShipInFrames = this.hitShipInFrames;
            this.dangerous = false;
        }
    }

    public void setDangerous(boolean dangerous) {
        this.dangerous = dangerous;
        this.dangerousDetected = 0;
    }

    public int getOriginX() {
        return this.originX;
    }

    public void setOriginX(int originX) {
        this.originX = originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public void setOriginY(int originY) {
        this.originY = originY;
    }

    public Point getOrigin() {
        return new Point(this.originX, this.originY);
    }

    public int getSquaredDistanceToShip() {
        return this.squaredDistanceToShip;
    }

    public boolean isDangerous() {
        return this.dangerous;
    }

    public int getHitShipInFrames() {
        return this.hitShipInFrames;
    }

    public int getDangerousDetected() {
        return this.dangerousDetected;
    }

    public int getLastHitShipInFrames() {
        return this.lastHitShipInFrames;
    }
}

