/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.GameObject;
import de.caff.asteroid.Glyph;
import de.caff.asteroid.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Collection;

public class Explosion
extends GameObject {
    private static final Color EXPLOSION_COLOR = new Color(128, 128, 128);
    public static final Glyph XXL_GLYPH;
    public static final Glyph XL_GLYPH;
    public static final Glyph L_GLYPH;
    public static final Glyph S_GLYPH;
    private Type type;
    private int scale;

    static {
        byte[] byArray = new byte[60];
        byArray[0] = 16;
        byArray[3] = 16;
        byArray[5] = 7;
        byArray[6] = 32;
        byArray[7] = 16;
        byArray[9] = 32;
        byArray[10] = 16;
        byArray[11] = 7;
        byArray[12] = 16;
        byArray[13] = 32;
        byArray[15] = 16;
        byArray[16] = 32;
        byArray[17] = 7;
        byArray[18] = -8;
        byArray[19] = 24;
        byArray[21] = -8;
        byArray[22] = 24;
        byArray[23] = 7;
        byArray[24] = -24;
        byArray[25] = 32;
        byArray[27] = -24;
        byArray[28] = 32;
        byArray[29] = 7;
        byArray[30] = -24;
        byArray[31] = 16;
        byArray[33] = -24;
        byArray[34] = 16;
        byArray[35] = 7;
        byArray[36] = -32;
        byArray[37] = -8;
        byArray[39] = -32;
        byArray[40] = -8;
        byArray[41] = 7;
        byArray[42] = -24;
        byArray[43] = -32;
        byArray[45] = -24;
        byArray[46] = -32;
        byArray[47] = 7;
        byArray[48] = 8;
        byArray[49] = -24;
        byArray[51] = 8;
        byArray[52] = -24;
        byArray[53] = 7;
        byArray[54] = 32;
        byArray[55] = -32;
        byArray[57] = 32;
        byArray[58] = -32;
        byArray[59] = 7;
        XXL_GLYPH = new Glyph(byArray);
        byte[] byArray2 = new byte[60];
        byArray2[0] = 14;
        byArray2[3] = 14;
        byArray2[5] = 7;
        byArray2[6] = 28;
        byArray2[7] = 14;
        byArray2[9] = 28;
        byArray2[10] = 14;
        byArray2[11] = 7;
        byArray2[12] = 14;
        byArray2[13] = 28;
        byArray2[15] = 14;
        byArray2[16] = 28;
        byArray2[17] = 7;
        byArray2[18] = -7;
        byArray2[19] = 21;
        byArray2[21] = -7;
        byArray2[22] = 21;
        byArray2[23] = 7;
        byArray2[24] = -21;
        byArray2[25] = 28;
        byArray2[27] = -21;
        byArray2[28] = 28;
        byArray2[29] = 7;
        byArray2[30] = -21;
        byArray2[31] = 14;
        byArray2[33] = -21;
        byArray2[34] = 14;
        byArray2[35] = 7;
        byArray2[36] = -28;
        byArray2[37] = -7;
        byArray2[39] = -28;
        byArray2[40] = -7;
        byArray2[41] = 7;
        byArray2[42] = -21;
        byArray2[43] = -28;
        byArray2[45] = -21;
        byArray2[46] = -28;
        byArray2[47] = 7;
        byArray2[48] = 7;
        byArray2[49] = -21;
        byArray2[51] = 7;
        byArray2[52] = -21;
        byArray2[53] = 7;
        byArray2[54] = 28;
        byArray2[55] = -28;
        byArray2[57] = 28;
        byArray2[58] = -28;
        byArray2[59] = 7;
        XL_GLYPH = new Glyph(byArray2);
        byte[] byArray3 = new byte[60];
        byArray3[0] = 12;
        byArray3[3] = 12;
        byArray3[5] = 7;
        byArray3[6] = 24;
        byArray3[7] = 12;
        byArray3[9] = 24;
        byArray3[10] = 12;
        byArray3[11] = 7;
        byArray3[12] = 12;
        byArray3[13] = 24;
        byArray3[15] = 12;
        byArray3[16] = 24;
        byArray3[17] = 7;
        byArray3[18] = -6;
        byArray3[19] = 18;
        byArray3[21] = -6;
        byArray3[22] = 18;
        byArray3[23] = 7;
        byArray3[24] = -18;
        byArray3[25] = 24;
        byArray3[27] = -18;
        byArray3[28] = 24;
        byArray3[29] = 7;
        byArray3[30] = -18;
        byArray3[31] = 12;
        byArray3[33] = -18;
        byArray3[34] = 12;
        byArray3[35] = 7;
        byArray3[36] = -24;
        byArray3[37] = -6;
        byArray3[39] = -24;
        byArray3[40] = -6;
        byArray3[41] = 7;
        byArray3[42] = -18;
        byArray3[43] = -24;
        byArray3[45] = -18;
        byArray3[46] = -24;
        byArray3[47] = 7;
        byArray3[48] = 6;
        byArray3[49] = -18;
        byArray3[51] = 6;
        byArray3[52] = -18;
        byArray3[53] = 7;
        byArray3[54] = 24;
        byArray3[55] = -24;
        byArray3[57] = 24;
        byArray3[58] = -24;
        byArray3[59] = 7;
        L_GLYPH = new Glyph(byArray3);
        byte[] byArray4 = new byte[60];
        byArray4[0] = 10;
        byArray4[3] = 10;
        byArray4[5] = 7;
        byArray4[6] = 20;
        byArray4[7] = 10;
        byArray4[9] = 20;
        byArray4[10] = 10;
        byArray4[11] = 7;
        byArray4[12] = 10;
        byArray4[13] = 20;
        byArray4[15] = 10;
        byArray4[16] = 20;
        byArray4[17] = 7;
        byArray4[18] = -5;
        byArray4[19] = 15;
        byArray4[21] = -5;
        byArray4[22] = 15;
        byArray4[23] = 7;
        byArray4[24] = -15;
        byArray4[25] = 20;
        byArray4[27] = -15;
        byArray4[28] = 20;
        byArray4[29] = 7;
        byArray4[30] = -15;
        byArray4[31] = 10;
        byArray4[33] = -15;
        byArray4[34] = 10;
        byArray4[35] = 7;
        byArray4[36] = -20;
        byArray4[37] = -5;
        byArray4[39] = -20;
        byArray4[40] = -5;
        byArray4[41] = 7;
        byArray4[42] = -15;
        byArray4[43] = -20;
        byArray4[45] = -15;
        byArray4[46] = -20;
        byArray4[47] = 7;
        byArray4[48] = 5;
        byArray4[49] = -15;
        byArray4[51] = 5;
        byArray4[52] = -15;
        byArray4[53] = 7;
        byArray4[54] = 20;
        byArray4[55] = -20;
        byArray4[57] = 20;
        byArray4[58] = -20;
        byArray4[59] = 7;
        S_GLYPH = new Glyph(byArray4);
    }

    public Explosion(int x, int y, int scale, Type type) {
        super(x, y);
        this.type = type;
        switch (scale) {
            case 0: {
                this.scale = 1;
                break;
            }
            case 15: {
                this.scale = 2;
                break;
            }
            case 14: {
                this.scale = 4;
                break;
            }
            case 13: {
                this.scale = 8;
                break;
            }
            case 12: {
                this.scale = 16;
                break;
            }
            case 11: {
                this.scale = 32;
                break;
            }
            default: {
                System.out.println("Unexpected explosion scaling: " + scale);
                this.scale = 1;
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    public int getSize() {
        return this.type.getShape().getBounds().width / (2 * this.scale);
    }

    public String toString() {
        return String.format("Explosion(%s)@(%d,%d)*%d", new Object[]{this.type, this.x, this.y, this.getSize()});
    }

    @Override
    public void draw(Graphics2D g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(EXPLOSION_COLOR);
        g2.draw(this.getExplosionShape());
    }

    public Shape getExplosionShape() {
        AffineTransform trafo = new AffineTransform(1.0 / (double)this.scale, 0.0, 0.0, 1.0 / (double)this.scale, (double)this.x, (double)this.y);
        return trafo.createTransformedShape(this.type.getShape());
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<Type>("Explosion Type", this.getType()));
        props.add(new Property<Integer>("Scale", this.scale));
        return props;
    }

    @Override
    public Rectangle getBounds() {
        return this.getExplosionShape().getBounds();
    }

    @Override
    public String getObjectType() {
        return "Explosion";
    }

    public static enum Type {
        XXL(XXL_GLYPH),
        XL(XL_GLYPH),
        L(L_GLYPH),
        S(S_GLYPH);

        private final Shape shape;

        private Type(Glyph glyph) {
            this.shape = glyph.getPath();
        }

        public Shape getShape() {
            return this.shape;
        }
    }
}

