/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Collection;

public class Asteroid
extends MovingGameObject {
    private static final Color[] ASTEROID_COLOR = new Color[]{new Color(128, 128, 128), new Color(48, 48, 48), new Color(192, 0, 0), new Color(96, 0, 96)};
    private static final int[] SCORES;
    private static int NORMAL_SCALE;
    private int scale;
    private int type;
    private final int index;
    private int colorCode;
    private static final GeneralPath PATH0;
    private static final GeneralPath PATH1;
    private static final GeneralPath PATH2;
    private static final GeneralPath PATH3;
    private static final Shape[] SHAPES;

    static {
        int[] nArray = new int[9];
        nArray[2] = 100;
        nArray[4] = 50;
        nArray[8] = 20;
        SCORES = nArray;
        NORMAL_SCALE = 8;
        PATH0 = new GeneralPath();
        PATH1 = new GeneralPath();
        PATH2 = new GeneralPath();
        PATH3 = new GeneralPath();
        PATH0.moveTo(1.0f, 0.0f);
        PATH0.lineTo(4.0f, 1.0f);
        PATH0.lineTo(4.0f, 2.0f);
        PATH0.lineTo(1.0f, 4.0f);
        PATH0.lineTo(-2.0f, 4.0f);
        PATH0.lineTo(-1.0f, 3.0f);
        PATH0.lineTo(-4.0f, 3.0f);
        PATH0.lineTo(-4.0f, -1.0f);
        PATH0.lineTo(-2.0f, -4.0f);
        PATH0.lineTo(1.0f, -3.0f);
        PATH0.lineTo(2.0f, -4.0f);
        PATH0.lineTo(4.0f, -2.0f);
        PATH0.closePath();
        PATH1.moveTo(3.0f, 0.0f);
        PATH1.lineTo(4.0f, 2.0f);
        PATH1.lineTo(2.0f, 4.0f);
        PATH1.lineTo(0.0f, 2.0f);
        PATH1.lineTo(-2.0f, 4.0f);
        PATH1.lineTo(-4.0f, 2.0f);
        PATH1.lineTo(-4.0f, -2.0f);
        PATH1.lineTo(-2.0f, -4.0f);
        PATH1.lineTo(1.0f, -4.0f);
        PATH1.lineTo(4.0f, -2.0f);
        PATH1.closePath();
        PATH2.moveTo(4.0f, 1.0f);
        PATH2.lineTo(2.0f, 4.0f);
        PATH2.lineTo(-1.0f, 4.0f);
        PATH2.lineTo(-4.0f, 1.0f);
        PATH2.lineTo(-2.0f, 0.0f);
        PATH2.lineTo(-4.0f, -1.0f);
        PATH2.lineTo(-2.0f, -4.0f);
        PATH2.lineTo(0.0f, -1.0f);
        PATH2.lineTo(0.0f, -4.0f);
        PATH2.lineTo(2.0f, -4.0f);
        PATH2.lineTo(4.0f, -1.0f);
        PATH2.closePath();
        PATH3.moveTo(2.0f, 1.0f);
        PATH3.lineTo(4.0f, 2.0f);
        PATH3.lineTo(2.0f, 4.0f);
        PATH3.lineTo(0.0f, 3.0f);
        PATH3.lineTo(-2.0f, 4.0f);
        PATH3.lineTo(-4.0f, 2.0f);
        PATH3.lineTo(-3.0f, 0.0f);
        PATH3.lineTo(-4.0f, -2.0f);
        PATH3.lineTo(-2.0f, -4.0f);
        PATH3.lineTo(-1.0f, -3.0f);
        PATH3.lineTo(2.0f, -4.0f);
        PATH3.lineTo(4.0f, -1.0f);
        PATH3.closePath();
        SHAPES = new Shape[]{PATH1, PATH3, PATH2, PATH0};
    }

    public Asteroid(int index, int x, int y, int size, int type) {
        super(x, y);
        switch (size) {
            case 0: {
                this.scale = NORMAL_SCALE;
                break;
            }
            case 15: {
                this.scale = NORMAL_SCALE / 2;
                break;
            }
            case 14: {
                this.scale = NORMAL_SCALE / 4;
            }
        }
        assert (type >= 0 && type < SHAPES.length);
        this.type = type;
        this.index = index;
    }

    @Override
    public int getSize() {
        return 4 * this.scale;
    }

    public int getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(ASTEROID_COLOR[this.colorCode]);
        AffineTransform trafo = new AffineTransform(this.scale, 0.0f, 0.0f, this.scale, this.x, this.y);
        g.draw(trafo.createTransformedShape(SHAPES[this.type]));
        this.drawVelocityVector(g, Color.red);
    }

    public String toString() {
        return String.format("Asteroid(%s)@(%d,%d)*%d?%d", this.getIdentity() == null ? "" : this.getIdentity().toString(), this.x, this.y, 4 * this.scale, this.type);
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<Integer>("Asteroid Type", this.getType()));
        props.add(new Property<Integer>("Scale Factor", this.scale));
        return props;
    }

    @Override
    public String getObjectType() {
        return "Asteroid";
    }

    @Override
    public int getScore() {
        return SCORES[this.scale];
    }

    public void setColor(int color) {
        this.colorCode = color;
    }
}

