/*
 * Decompiled with CFR 0.152.
 */
package de.wens02;

import de.wens02.Asteroid;
import de.wens02.AsteroidApp;
import de.wens02.Debug;
import de.wens02.Explosion;
import de.wens02.Log;
import java.awt.Point;
import java.util.Vector;

public class VectorObject {
    protected int x;
    protected int y;
    protected int s;
    protected int type;
    protected boolean isExplosion = false;
    protected boolean isAsteroid = false;
    protected static final int MaxNewAsteroid = 8;
    protected static Asteroid[] oldAsteroid = new Asteroid[8];
    protected static Point[] newPoint = new Point[8];
    protected static Point tmpPoint = new Point();
    protected static String sLastVectorObjects = "";
    protected static String sSeenVectorObjects = "";

    static {
        int i = 0;
        while (i < 8) {
            VectorObject.newPoint[i] = new Point(0, 0);
            ++i;
        }
    }

    VectorObject(int x, int y, int s, int type) {
        this.set(x, y, s, type);
    }

    protected void set(int x, int y, int s, int type) {
        this.x = x;
        this.y = y;
        this.s = s;
        this.type = type;
    }

    protected void setExplosion(int x, int y, int s, int type) {
        this.isExplosion = true;
        this.isAsteroid = false;
        this.set(x, y, s, type);
    }

    protected void setAsteroid(int x, int y, int s, int type) {
        this.isAsteroid = true;
        this.isExplosion = false;
        this.set(x, y, s, type);
    }

    protected static void debug(VectorObject[] vram_objects, VectorObject[] vram_objects_new, int new_cnt, boolean force) {
        String sLastObjects = "";
        String sSeenObjects = "";
        int i = 0;
        while (i < vram_objects.length) {
            VectorObject obj = vram_objects[i];
            if (obj == null) {
                sLastObjects = String.valueOf(sLastObjects) + "|__";
            } else if (obj instanceof Asteroid) {
                switch (((Asteroid)obj).sizeType) {
                    case 3: {
                        sLastObjects = String.valueOf(sLastObjects) + "|L ";
                        break;
                    }
                    case 2: {
                        sLastObjects = String.valueOf(sLastObjects) + "|M ";
                        break;
                    }
                    case 1: {
                        sLastObjects = String.valueOf(sLastObjects) + "|S ";
                    }
                }
            } else if (obj instanceof Explosion) {
                sLastObjects = String.valueOf(sLastObjects) + "|ex";
            }
            ++i;
        }
        i = 0;
        while (i < new_cnt) {
            VectorObject vo = vram_objects_new[i];
            if (vo.isAsteroid) {
                switch (vo.s) {
                    case 0: {
                        sSeenObjects = String.valueOf(sSeenObjects) + "|L ";
                        break;
                    }
                    case 15: {
                        sSeenObjects = String.valueOf(sSeenObjects) + "|M ";
                        break;
                    }
                    case 14: {
                        sSeenObjects = String.valueOf(sSeenObjects) + "|S ";
                    }
                }
            }
            if (vo.isExplosion) {
                sSeenObjects = String.valueOf(sSeenObjects) + "|ex";
            }
            ++i;
        }
        if (force || !sLastVectorObjects.equals(sLastObjects) || !sSeenVectorObjects.equals(sSeenObjects)) {
            Log.debug(String.format("Frame#%5d: " + sLastObjects + "\n             " + sSeenObjects, AsteroidApp.frame_cnt));
            sLastVectorObjects = sLastObjects;
            sSeenVectorObjects = sSeenObjects;
        }
    }

    protected static void sync(Vector<Asteroid> asteroids, VectorObject[] vram_objects, VectorObject[] vram_objects_new, int new_cnt) {
        if (Debug.sync) {
            VectorObject.debug(vram_objects, vram_objects_new, new_cnt, false);
        }
        boolean empty = true;
        int i = 0;
        while (empty && i < vram_objects.length) {
            if (vram_objects[i] != null) {
                empty = false;
            }
            ++i;
        }
        if (empty) {
            i = 0;
            while (i < new_cnt) {
                VectorObject vo = vram_objects_new[i];
                if (vo.isAsteroid) {
                    Asteroid a = new Asteroid(vo.x, vo.y, vo.s, vo.type);
                    vram_objects[i] = a;
                    asteroids.add(a);
                }
                ++i;
            }
            return;
        }
        int new_ast_cnt = 0;
        int i2 = 0;
        while (i2 < new_cnt) {
            VectorObject vo = vram_objects_new[i2];
            if (vo.isExplosion && Debug.explosions) {
                Log.debug(String.format("Frame#%5d: Explosion 0x%03x at (%3d,%3d)", AsteroidApp.frame_cnt, vo.type, vo.x, vo.y));
            }
            if (vo.isAsteroid && Debug.asteroids) {
                Log.debug(String.format("Frame#%5d: Asteroid Typ 0x%03x at (%3d,%3d) [vs=%3d]", AsteroidApp.frame_cnt, vo.type, vo.x, vo.y));
            }
            if (vo.isExplosion && vo.type == 2229 && vo.s == 11) {
                int j = 0;
                while (j < vram_objects.length) {
                    VectorObject obj = vram_objects[j];
                    if (obj != null && obj instanceof Asteroid && obj.x == vo.x && obj.y == vo.y) {
                        Asteroid a = (Asteroid)obj;
                        if (Debug.asteroid_explosion) {
                            Log.debug(String.format("Frame#%5d: [%2d] Asteroid Size %2d at [%4d,%4d] explodiert [Exp 0x%03x vs=%2d]", AsteroidApp.frame_cnt, j, obj.s, vo.x, vo.y, vo.type, vo.s));
                        }
                        if (a.sizeType != 1) {
                            VectorObject.oldAsteroid[new_ast_cnt++] = a;
                            VectorObject.oldAsteroid[new_ast_cnt++] = a;
                        }
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int new_i = 0;
        int old_i = 0;
        int ast_i = 0;
        while (new_i < new_cnt && old_i < vram_objects.length) {
            Asteroid a;
            VectorObject vo_old = vram_objects[old_i];
            VectorObject vo_new = vram_objects_new[new_i];
            if (vo_old instanceof Asteroid) {
                a = (Asteroid)vo_old;
                if (vo_new.isAsteroid) {
                    if (vo_new.s != a.s || vo_new.type != a.type) {
                        Log.error(String.format("Frame#%5d: [%2d,%2d] ALT: 0x%3x,%2d NEU: 0x%3x,%2d", AsteroidApp.frame_cnt, old_i, new_i, a.type, a.s, vo_new.type, vo_new.s));
                        VectorObject.debug(vram_objects, vram_objects_new, new_cnt, true);
                        vram_objects[old_i++] = new Asteroid(vo_new.x, vo_new.y, vo_new.s, vo_new.type);
                        ++new_i;
                        continue;
                    }
                    tmpPoint.setLocation(vo_new.x, vo_new.y);
                    if (Debug.asteroids && a.getSquaredTorusDistance(tmpPoint, 1) > 6.0) {
                        Log.warn(String.format("Frame#%5d: [%2d] a.frames=%3d, Distanz = %5f", AsteroidApp.frame_cnt, old_i, a.frames, a.getSquaredTorusDistance(tmpPoint, 1)));
                    }
                    a.update(tmpPoint);
                    ++old_i;
                    ++new_i;
                    continue;
                }
                if (vo_new.x != a.x || vo_new.y != a.y) {
                    Log.error(String.format("Frame#%5d: [%2d,%2d] Explosion Typ 0x%03x Size %2d at [%4d,%4d] != Asteroid [%4d,%4d]", AsteroidApp.frame_cnt, old_i, new_i, vo_new.type, vo_new.s, vo_new.x, vo_new.y, a.x, a.y));
                    VectorObject.debug(vram_objects, vram_objects_new, new_cnt, true);
                    ++new_i;
                    continue;
                }
                a.exploding = true;
                vram_objects[old_i++] = new Explosion(vo_new.x, vo_new.y, vo_new.s, vo_new.type);
                ++new_i;
                continue;
            }
            if (vo_old instanceof Explosion) {
                if (vo_new.isExplosion && vo_new.x == vo_old.x && vo_new.y == vo_old.y) {
                    ++old_i;
                    ++new_i;
                    continue;
                }
                if (Debug.explosions) {
                    Log.debug(String.format("Frame#%5d: [%2d] Explosion verpufft", AsteroidApp.frame_cnt, old_i));
                }
                vram_objects[old_i++] = null;
                continue;
            }
            if (vo_new.isExplosion || ast_i >= new_ast_cnt) {
                if (old_i >= vram_objects.length) {
                    VectorObject.debug(vram_objects, vram_objects_new, new_cnt, true);
                }
                while (old_i < vram_objects.length && vram_objects[old_i] == null) {
                    ++old_i;
                }
                continue;
            }
            a = new Asteroid(vo_new.x, vo_new.y, vo_new.s, vo_new.type);
            if (Debug.asteroid_new) {
                Asteroid father = oldAsteroid[ast_i];
                int dx = a.x - father.x;
                int dy = a.y - father.y;
                double alpha = Math.toDegrees(Math.atan2(dx, dy));
                double speed = Math.sqrt(dx * dx + dy * dy);
                Log.debug(String.format("Frame#%5d: ID%5d[%4d,%4d,s%2d] dx,dy=%5f,%5f (a=%5f,s=%5f) -> ID%5d[%4d,%4d,s%2d] (alpha=%5f,speed=%5f)", AsteroidApp.frame_cnt, father.id, father.x, father.y, father.s, father.dx, father.dy, father.getAlpha(), father.getSpeed(), a.id, a.x, a.y, a.s, alpha, speed));
            }
            vram_objects[old_i++] = a;
            ++new_i;
            ++ast_i;
        }
        int i3 = 0;
        while (i3 < old_i) {
            VectorObject obj = vram_objects[i3];
            if (obj != null && obj instanceof Asteroid) {
                asteroids.add((Asteroid)obj);
            }
            ++i3;
        }
        while (old_i < vram_objects.length) {
            vram_objects[old_i++] = null;
        }
    }
}

