/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingDoublePreferenceProperty;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class DoubleEditor
extends AbstractBasicEditorProvider
implements PropertyChangeListener {
    private final SwingDoublePreferenceProperty propertySwing;
    private final JSpinner spinner;

    public DoubleEditor(SwingDoublePreferenceProperty propertySwing, Locale l) {
        super(propertySwing, l);
        this.propertySwing = propertySwing;
        this.spinner = new JSpinner(new SpinnerNumberModel(propertySwing.getValue(), propertySwing.getMinValue(), propertySwing.getMaxValue(), propertySwing.getStep()));
        Dimension size = this.spinner.getPreferredSize();
        if (size.width > 1000) {
            this.spinner.setPreferredSize(new Dimension(100, size.height));
        }
        propertySwing.addValueChangeListener(this);
    }

    @Override
    public JComponent getEditor() {
        return this.spinner;
    }

    @Override
    public void reset() {
        this.spinner.setValue(new Double(this.propertySwing.getValue()));
    }

    @Override
    public void save() {
        this.propertySwing.setValue(((Number)this.spinner.getValue()).doubleValue());
    }

    @Override
    public void goodBye() {
        this.propertySwing.removeValueChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int newValue = ((Number)evt.getNewValue()).intValue();
        if (newValue != ((Number)this.spinner.getValue()).intValue()) {
            this.spinner.setValue(evt.getNewValue());
        }
    }
}

