/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.util.KnockOffListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class Worker
implements Runnable {
    private Throwable catched;
    private List<KnockOffListener> knockOffListeners = new LinkedList<KnockOffListener>();
    private boolean stopped = false;

    public Worker() {
    }

    public Worker(KnockOffListener listener) {
        this.addKnockOffListener(listener);
    }

    @Override
    public void run() {
        try {
            try {
                this.execute();
            }
            catch (Throwable x) {
                this.catched = x;
                this.informKnockOffListeners();
            }
        }
        finally {
            this.informKnockOffListeners();
        }
    }

    protected abstract void execute() throws Throwable;

    public Throwable getCatched() {
        return this.catched;
    }

    public void rethrow() throws Throwable {
        if (this.catched != null) {
            throw this.catched;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKnockOffListener(KnockOffListener listener) {
        if (listener != null) {
            List<KnockOffListener> list = this.knockOffListeners;
            synchronized (list) {
                this.knockOffListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKnockOffListener(KnockOffListener listener) {
        if (listener != null) {
            List<KnockOffListener> list = this.knockOffListeners;
            synchronized (list) {
                this.knockOffListeners.remove(listener);
            }
        }
    }

    protected void informKnockOffListeners() {
        Worker.invokeInEventDispatchThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList knockOffListenersCopy;
                List list = Worker.this.knockOffListeners;
                synchronized (list) {
                    knockOffListenersCopy = new ArrayList(Worker.this.knockOffListeners);
                }
                for (KnockOffListener listener : knockOffListenersCopy) {
                    listener.knockedOff(Worker.this);
                }
            }
        });
    }

    public void stop() {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean removeListeners) {
        Object object;
        if (removeListeners) {
            object = this.knockOffListeners;
            synchronized (object) {
                this.knockOffListeners.clear();
            }
        }
        object = this;
        synchronized (object) {
            this.stopped = true;
        }
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public static void invokeInEventDispatchThread(Runnable run) {
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }
}

