/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.util.Utility;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public abstract class ResourcedAction
extends AbstractAction
implements Localizable {
    protected static final String RESOURCE_PREFIX = "i18n.";
    private static final int RESOURCE_PREFIX_LENGTH = "i18n.".length();
    protected static final String ICON_PREFIX = "i18n.icon.";
    private static final int ICON_PREFIX_LENGTH = "i18n.icon.".length();
    public static final String ACCELERATOR_KEY_RESOURCE = "i18n.AcceleratorKey";
    public static final String ACTION_COMMAND_KEY_RESOURCE = "i18n.ActionCommandKey";
    public static final String LONG_DESCRIPTION_RESOURCE = "i18n.LongDescription";
    public static final String MNEMONIC_KEY_RESOURCE = "i18n.MnemonicKey";
    public static final String NAME_RESOURCE = "i18n.Name";
    public static final String SHORT_DESCRIPTION_RESOURCE = "i18n.ShortDescription";
    public static final String SMALL_ICON_RESOURCE = "i18n.icon.SmallIcon";
    private Locale locale;

    protected ResourcedAction(String baseTag) {
        this(baseTag, (Locale)null);
    }

    protected ResourcedAction(String baseTag, Locale l) {
        this.setLocale(l);
        try {
            this.putValue(NAME_RESOURCE, String.valueOf(baseTag) + "-TEXT");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            this.putValue(SHORT_DESCRIPTION_RESOURCE, String.valueOf(baseTag) + "-TTT");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            this.putValue(LONG_DESCRIPTION_RESOURCE, String.valueOf(baseTag) + "-DESCR");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            this.putValue(ACCELERATOR_KEY_RESOURCE, String.valueOf(baseTag) + "-ACCEL");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            this.putValue(MNEMONIC_KEY_RESOURCE, String.valueOf(baseTag) + "-MNEMO");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            this.putValue(SMALL_ICON_RESOURCE, String.valueOf(baseTag) + "-ICON");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        I18n.addLocalizationChangeListener(this);
    }

    @Override
    public void setLocale(Locale l) {
        if (l == null) {
            l = I18n.getDefaultLocale();
        }
        if (!l.equals(this.locale)) {
            this.locale = l;
            Object[] keys = this.getKeys();
            if (keys != null) {
                int k = 0;
                while (k < keys.length) {
                    String key = keys[k].toString();
                    if (key.startsWith(RESOURCE_PREFIX)) {
                        this.putValue(key, this.getValue(key));
                    }
                    ++k;
                }
            }
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void putValue(String key, Object newValue) {
        if (key.startsWith(RESOURCE_PREFIX)) {
            String resolved = I18n.getString(newValue.toString(), this.locale);
            if (key.startsWith(ICON_PREFIX)) {
                super.putValue(key.substring(ICON_PREFIX_LENGTH), new ImageIcon(Utility.loadImage(resolved)));
            } else if (MNEMONIC_KEY_RESOURCE.equals(key)) {
                super.putValue("MnemonicKey", new Integer(resolved.charAt(0)));
            } else if (ACCELERATOR_KEY_RESOURCE.equals(key)) {
                super.putValue("AcceleratorKey", KeyStroke.getKeyStroke(resolved));
            } else {
                super.putValue(key.substring(RESOURCE_PREFIX_LENGTH), resolved);
            }
        }
        super.putValue(key, newValue);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

