/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.analysis.DumpFile;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Collection;
import javax.swing.JComponent;

public abstract class AbstractBasicTimeLine
extends JComponent {
    protected static final int MARKER_BORDER_Y = 8;
    protected static final int MARKER_BORDER_X = 6;
    protected static final Color BACKGROUND_COLOR = Color.white;
    protected static final Color NO_SHIP_COLOR = Color.blue;
    protected static final Color WITH_SHIP_COLOR = new Color(64, 64, 255);
    protected static final Color BETWEEN_GAMES_COLOR = Color.orange;
    protected static final Color AFTER_DUMP_END_COLOR = Color.gray;

    protected int indexToScreen(int index) {
        return this.isValid() ? (int)((double)index * this.getScale() + 6.0) : -1;
    }

    private static final Color getColor(DumpFile.Mark mark) {
        switch (mark.getMarkType()) {
            case SHIP_APPEARS: {
                return WITH_SHIP_COLOR;
            }
            case GAME_START: 
            case SHIP_VANISHES: {
                return NO_SHIP_COLOR;
            }
            case GAME_END: {
                return BETWEEN_GAMES_COLOR;
            }
            case DUMP_END: {
                return AFTER_DUMP_END_COLOR;
            }
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.getFrameCount() == 0) {
            return;
        }
        DumpFile.Mark prevMark = null;
        for (DumpFile.Mark mark : this.getMarks()) {
            if (prevMark != null) {
                int left = this.indexToScreen(prevMark.getFrameIndex());
                int right = this.indexToScreen(mark.getFrameIndex());
                g.setColor(AbstractBasicTimeLine.getColor(prevMark));
                g.fillRect(left, 8, right - left, this.getHeight() - 16);
            }
            prevMark = mark;
        }
        if (prevMark != null) {
            int left = this.indexToScreen(prevMark.getFrameIndex());
            int right = this.indexToScreen(this.getFrameCount());
            g.setColor(AbstractBasicTimeLine.getColor(prevMark));
            g.fillRect(left, 8, right - left, this.getHeight() - 16);
        }
    }

    protected abstract Collection<DumpFile.Mark> getMarks();

    public abstract int getFrameCount();

    protected double getScale() {
        int size = this.getFrameCount();
        return size > 0 ? (double)(this.getWidth() - 12) / (double)size : -1.0;
    }
}

