///////////////////////////////////////////////////////////////////////////////
// @ Eduard Heidt                                                            //
///////////////////////////////////////////////////////////////////////////////


#ifndef STATISTICSH
#define STATISTICSH

#include "game.h"
#include "player.h"

static int snp = 0;

static void MakeStat(GameStatus& s, bool end = false)
{
	static int nObjects[2];
	nObjects[2] = nObjects[1];
	nObjects[1] = s.nObjects;

	static int level = 0;
	static int t_begin = 0;
	static int t_end = 0;
	static int p_begin = 0;
	static int max_a = 0;
	static int max_s = 0;
	static int a_begin = 0;
	static VDC moved = 0;
	static unsigned ship_not_present = 0;
	static unsigned endphase = 0;
	static int new_shots = 0;
	static int new_shots_by_ufo = 0;
	static int new_aster = 0;

	static int no_objects = 0;

	if(s.t < 160 && !s.ship.IsPresent())
	{
		level = 0;
		t_begin = 0;
		t_end = 0;
		p_begin = 0;
		max_a = 0;
		max_s = 0;
		a_begin = 0;
		endphase = 0;
		snp = 0;
		new_shots_by_ufo = new_shots = new_aster = 0;
		return;
	}

	if(s.nAsteroids > max_a)
		max_a = s.nAsteroids;

	if(s.nSmallAsteroids > max_s)
		max_s = s.nSmallAsteroids;

	if(nObjects[2] == 0 && nObjects[1] > 0) //LevelBeginn
	{
		if( nObjects[1] > 1)
		{
			s.hash = s.crc;
		}
		
		t_begin = s.t;
		p_begin = s.score;
		a_begin = s.nAsteroids;
		moved = 0;
		endphase = 0;
		ship_not_present = 0;
		
		new_shots = s.new_shots;
		new_aster = s.new_aster;
		new_shots_by_ufo = s.new_shots_by_ufo;

		printf(" NO: %3d", no_objects);
		no_objects = 0;
		level++;

	}

	if(s.nObjects == 1)
		endphase++;

	moved += s.ship.GetDir().Len();
	if(!s.ship.IsPresent())
	{
		ship_not_present++;
		snp++;
	}

	if(s.nObjects == 0)
		no_objects++;

	if((nObjects[2] > 0 && nObjects[1] == 0) || end) //LevelEnde
	{
		int T = s.t-t_begin+t_begin-t_end;
		int S = s.score-p_begin;
		if(1)
		{
			printf("\n");
			//printf(" %5d", t_begin);
			printf(" %2d", level);
			printf(" %5d", t_begin);
			printf(" T:%4d", T);
			printf(" SnP: %3d", ship_not_present);
			//printf(" O1: %3d", endphase);
			printf(" P:%4d", S);
			printf(" ->%6.0f", ((float)S)/T*18000);
			printf(" ->%6.0f", ((float)s.score)/s.t*18000);
			//printf(" | L:%2d, A:%2d MA:%2d(%2d), SCR: %d", s.lifes, a_begin, max_a, max_s, s.score);
			//printf(" nF:%3d nUF: %d nA: %3d", s.new_shots-new_shots, s.new_shots_by_ufo - new_shots_by_ufo, s.new_aster-new_aster);

	
			printf(" V: %4.0f", moved);
			printf("");
		}
		max_a = max_s = 0;
		t_end = s.t;
	}
}


static 	std::map<unsigned,int> scores;

static void stat_gameover(GameStatus& s)
{

	if(s.score == 0)
		return;

	MakeStat(s, true);
	
	scores[s.hash] = s.score;

	int min_score = 200000;
	int max_score = 0;
	float mean_score = 0;

	for(std::map<unsigned,int>::iterator it = scores.begin(); it!=scores.end(); it++)
	{
		if(min_score > it->second) min_score = it->second;
		if(max_score < it->second) max_score = it->second;
		mean_score += ((float)it->second)/scores.size();
	}

	//clrscr();

	printf("\n\n");
	for(int i = 0; i < 80; i++)
		putchar('=');
	
	printf("\nHASH: %d", s.hash);
	printf(         "\nSCORE %6d Mtw: %6.0f Lifes: %6d Snp: %4d Fired %4d", s.score, mean_score, s.lifes, snp, s.new_shots);
	fprintf(stderr, "\nSCORE %6d Mtw: %6.0f Lifes: %6d Snp: %4d Fired %4d", s.score, mean_score, s.lifes, snp, s.new_shots);

	printf("\nMax: %6d", max_score);
	printf("\tMin: %6d" , min_score);

	printf("\n\n");
	for(std::map<unsigned,int>::iterator it = scores.begin(); it!=scores.end(); it++)
		printf("\n%8x %6d",it->first, it->second);

	printf("\nMtw: %6.2f of %d Games", mean_score, scores.size());
	printf("\n\n");

	s.score = 0;
	snp = 0;

	printf("\n\n");
	for(int i = 0; i < 80; i++)
		putchar('#');
	

	//if(game.GetState()->score == max_score || game.GetState()->score == min_score)
	//	printf("%c",7);

}

#endif

