///////////////////////////////////////////////////////////////////////////////
// @ Eduard Heidt                                                            //
///////////////////////////////////////////////////////////////////////////////


#ifndef gameH
#define gameH

#include "connection.h"
#include "player.h"
#include "math2d.h"
#include "object.h"

#include <stdio.h>
#include <algorithm>
#include <vector>
#include <map>
#include "ship.h"

static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS = 10;



class Asteroid: public Object
{
public:
   int type;      // 1 ... 4, uere Form
   int sf;        // scale factor: 0 = gro, 15 = mittel, 14 = klein
   void set(int x, int y, int type, int sf);

	bool IsBig(){return sf == 0;}
	bool IsMiddle(){return sf == 15;}
	bool IsSmall(){return sf == 14;}
	bool IsUnReal(){return type == 0;}
};

class Saucer: public Object
{
public:
	int size;      // Gre: 15 = gro, 14 = klein, 0 = nicht sichtbar
	bool present;  // Schiff sichtbar
	bool IsPresent (void){ return size>0; }
	void set(int x, int y, int sf);

};

class GameStatus
{
	friend class Game;
public:
	Ship ship;              // Schiff
	Saucer saucer;          // UFO

	unsigned hash;

	Object* pObjects[MAX_ASTEROIDS];
	int nObjects;
	int nAsteroids;
	Asteroid asteroids[MAX_ASTEROIDS];
	Asteroid notreal[MAX_ASTEROIDS];
	Asteroid explosions[MAX_SHOTS*2];
	int nexplosions;
	int nNotReal;
	int nSmallAsteroids;

	int nshots;             // Anzahl Schsse
	Shot shots[MAX_SHOTS];
	static unsigned int t;         // Anzahl Durchlufe
	static unsigned int frameno;   // aktuelle Framezahl; ohne Frameverlust == t
	int lifes;
	unsigned int score;     // erreichte Punktzahl
	unsigned int new_shots;
	unsigned int new_shots_by_ufo;
	unsigned int new_aster;

	__int8 ping;
	unsigned int crc;

	GameStatus (void);
	void clear(void);
};

class Game
{
	friend class Emulator;
public:
   bool running;
   inline Game(Connection &con, Player &pl);
   
   void Run(void);
   void PlayRecord(char* file);
   
   void End();

   static GameStatus* GetState(){return &state;}
protected:
   void InterpretScreen(const FramePacket &packet, GameStatus& game);
private:
   Connection &connection;
   Player &player;
   static GameStatus state;
};


inline Game::Game(Connection &con, Player &pl)
:  connection(con),
   player(pl),
   running(false)
{
}

#endif
