package structures;

import objects.CombatObject;
import objects.Ship;
import utils.Utils;

public class TargetInformation {
	
	public double distance;
	
	public double angle;
	
	public double angleDif;	
	
	public int difX;
	
	public int difY;
	
	public TargetInformation()
	{
		distance = 0.0;
		angle = 0.0;
		angleDif = 0.0;
		difX = 0;
		difY = 0;	
	}
	
	public void setInfo(Ship ship, CombatObject object)
	{
		difX = Utils.getXDif(ship.getPosX(), object.getPosX());
		difY = Utils.getYDif(ship.getPosY(), object.getPosY());
		distance = Utils.TABLES.dist(difX, difY);
		angle = Utils.TABLES.atan2(difY, difX);
		angleDif = Utils.getAngleDif(ship.getMovementAngle(), angle); 
	}
	
	public void setInfo(TargetInformation other)
	{
		distance = other.distance;
		angle = other.angle;
		angleDif = other.angleDif;
		difX = other.difX;
		difY = other.difY;	
	}
	
	public String toString()
	{
		StringBuffer buf = new StringBuffer();		
		buf.append("TargetInformation[difX=");
		buf.append(difX);
		buf.append(", difY=");
		buf.append(difY);
		buf.append(", dist=");
		buf.append(distance);
		buf.append(", angle=");
		buf.append(angle);
		buf.append(", angleDif=");
		buf.append(angleDif);
		buf.append("]");
		return buf.toString();
	}
}
