/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Point;
import java.awt.geom.Point2D;

public class Tables {
    public static final double EE = 0.0;
    public static final double NE = 0.7853981633974483;
    public static final double NN = 1.5707963267948966;
    public static final double NW = 2.356194490192345;
    public static final double WW = Math.PI;
    public static final double SW = -2.356194490192345;
    public static final double SS = -1.5707963267948966;
    public static final double SE = -0.7853981633974483;
    public static final int[] SAUCER_SPAWN_DELAY = new int[]{507, 597, 573, 549, 525, 501, 477, 453, 429, 405, 381, 357, 333, 309, 285, 261, 237, 213, 189, 165};
    public static final int[] SPEED_BORDERS = new int[]{26, 41, 68, 96, 125, 155, 187, 218};
    private Point2D.Double[] shotOffsets = new Point2D.Double[256];
    private Point2D.Double[] shotBaseDirections = new Point2D.Double[256];
    private Point[] directions = new Point[]{new Point(1536, 0), new Point(1536, 0), new Point(1536, 0), new Point(1536, 0), new Point(1528, 152), new Point(1528, 152), new Point(1528, 152), new Point(1528, 152), new Point(1504, 296), new Point(1504, 296), new Point(1504, 296), new Point(1504, 296), new Point(1472, 440), new Point(1472, 440), new Point(1472, 440), new Point(1472, 440), new Point(1416, 584), new Point(1416, 584), new Point(1416, 584), new Point(1416, 584), new Point(1360, 720), new Point(1360, 720), new Point(1360, 720), new Point(1360, 720), new Point(1280, 856), new Point(1280, 856), new Point(1280, 856), new Point(1280, 856), new Point(1192, 976), new Point(1192, 976), new Point(1192, 976), new Point(1192, 976), new Point(1088, 1088), new Point(1088, 1088), new Point(1088, 1088), new Point(1088, 1088), new Point(976, 1192), new Point(976, 1192), new Point(976, 1192), new Point(976, 1192), new Point(856, 1280), new Point(856, 1280), new Point(856, 1280), new Point(856, 1280), new Point(720, 1360), new Point(720, 1360), new Point(720, 1360), new Point(720, 1360), new Point(584, 1416), new Point(584, 1416), new Point(584, 1416), new Point(584, 1416), new Point(440, 1472), new Point(440, 1472), new Point(440, 1472), new Point(440, 1472), new Point(296, 1504), new Point(296, 1504), new Point(296, 1504), new Point(296, 1504), new Point(152, 1528), new Point(152, 1528), new Point(152, 1528), new Point(152, 1528), new Point(0, 1536), new Point(-152, 1528), new Point(-152, 1528), new Point(-152, 1528), new Point(-152, 1528), new Point(-296, 1504), new Point(-296, 1504), new Point(-296, 1504), new Point(-296, 1504), new Point(-440, 1472), new Point(-440, 1472), new Point(-440, 1472), new Point(-440, 1472), new Point(-584, 1416), new Point(-584, 1416), new Point(-584, 1416), new Point(-584, 1416), new Point(-720, 1360), new Point(-720, 1360), new Point(-720, 1360), new Point(-720, 1360), new Point(-856, 1280), new Point(-856, 1280), new Point(-856, 1280), new Point(-856, 1280), new Point(-976, 1192), new Point(-976, 1192), new Point(-976, 1192), new Point(-976, 1192), new Point(-1088, 1088), new Point(-1088, 1088), new Point(-1088, 1088), new Point(-1088, 1088), new Point(-1192, 976), new Point(-1192, 976), new Point(-1192, 976), new Point(-1192, 976), new Point(-1280, 856), new Point(-1280, 856), new Point(-1280, 856), new Point(-1280, 856), new Point(-1360, 720), new Point(-1360, 720), new Point(-1360, 720), new Point(-1360, 720), new Point(-1416, 584), new Point(-1416, 584), new Point(-1416, 584), new Point(-1416, 584), new Point(-1472, 440), new Point(-1472, 440), new Point(-1472, 440), new Point(-1472, 440), new Point(-1504, 296), new Point(-1504, 296), new Point(-1504, 296), new Point(-1504, 296), new Point(-1528, 152), new Point(-1528, 152), new Point(-1528, 152), new Point(-1528, 152), new Point(-1536, 0), new Point(-1536, 0), new Point(-1536, 0), new Point(-1536, 0), new Point(-1536, 0), new Point(-1536, 0), new Point(-1536, 0), new Point(-1528, -152), new Point(-1528, -152), new Point(-1528, -152), new Point(-1528, -152), new Point(-1504, -296), new Point(-1504, -296), new Point(-1504, -296), new Point(-1504, -296), new Point(-1472, -440), new Point(-1472, -440), new Point(-1472, -440), new Point(-1472, -440), new Point(-1416, -584), new Point(-1416, -584), new Point(-1416, -584), new Point(-1416, -584), new Point(-1360, -720), new Point(-1360, -720), new Point(-1360, -720), new Point(-1360, -720), new Point(-1280, -856), new Point(-1280, -856), new Point(-1280, -856), new Point(-1280, -856), new Point(-1192, -976), new Point(-1192, -976), new Point(-1192, -976), new Point(-1192, -976), new Point(-1088, -1088), new Point(-1088, -1088), new Point(-1088, -1088), new Point(-1088, -1088), new Point(-976, -1192), new Point(-976, -1192), new Point(-976, -1192), new Point(-976, -1192), new Point(-856, -1280), new Point(-856, -1280), new Point(-856, -1280), new Point(-856, -1280), new Point(-720, -1360), new Point(-720, -1360), new Point(-720, -1360), new Point(-720, -1360), new Point(-584, -1416), new Point(-584, -1416), new Point(-584, -1416), new Point(-584, -1416), new Point(-440, -1472), new Point(-440, -1472), new Point(-440, -1472), new Point(-440, -1472), new Point(-296, -1504), new Point(-296, -1504), new Point(-296, -1504), new Point(-296, -1504), new Point(-152, -1528), new Point(-152, -1528), new Point(-152, -1528), new Point(-152, -1528), new Point(0, -1536), new Point(152, -1528), new Point(152, -1528), new Point(152, -1528), new Point(152, -1528), new Point(296, -1504), new Point(296, -1504), new Point(296, -1504), new Point(296, -1504), new Point(440, -1472), new Point(440, -1472), new Point(440, -1472), new Point(440, -1472), new Point(584, -1416), new Point(584, -1416), new Point(584, -1416), new Point(584, -1416), new Point(720, -1360), new Point(720, -1360), new Point(720, -1360), new Point(720, -1360), new Point(856, -1280), new Point(856, -1280), new Point(856, -1280), new Point(856, -1280), new Point(976, -1192), new Point(976, -1192), new Point(976, -1192), new Point(976, -1192), new Point(1088, -1088), new Point(1088, -1088), new Point(1088, -1088), new Point(1088, -1088), new Point(1192, -976), new Point(1192, -976), new Point(1192, -976), new Point(1192, -976), new Point(1280, -856), new Point(1280, -856), new Point(1280, -856), new Point(1280, -856), new Point(1360, -720), new Point(1360, -720), new Point(1360, -720), new Point(1360, -720), new Point(1416, -584), new Point(1416, -584), new Point(1416, -584), new Point(1416, -584), new Point(1472, -440), new Point(1472, -440), new Point(1472, -440), new Point(1472, -440), new Point(1504, -296), new Point(1504, -296), new Point(1504, -296), new Point(1504, -296), new Point(1528, -152), new Point(1528, -152), new Point(1528, -152), new Point(1528, -152), new Point(1536, 0), new Point(1536, 0), new Point(1536, 0)};
    private double[][] atan2 = new double[769][1025];
    private double[][] dist = new double[1025][769];
    private double[] sin = new double[(int)Math.ceil(50391.46111021222)];
    private double[] astSin = new double[256];
    private double[] astCos = new double[256];
    private double[][] preparationDirections = new double[][]{{2.356194490192345, 2.356194490192345, 1.5707963267948966, 1.5707963267948966, 1.5707963267948966, 1.5707963267948966, 0.7853981633974483, 0.7853981633974483}, {2.356194490192345, 2.356194490192345, 1.5707963267948966, 1.5707963267948966, 1.5707963267948966, 1.5707963267948966, 0.7853981633974483, 0.7853981633974483}, {Math.PI, Math.PI, 2.356194490192345, 1.5707963267948966, 1.5707963267948966, 0.7853981633974483, 0.0, 0.0}, {Math.PI, Math.PI, Math.PI, 2.356194490192345, 0.7853981633974483, 0.0, 0.0, 0.0}, {Math.PI, Math.PI, Math.PI, -2.356194490192345, -0.7853981633974483, 0.0, 0.0, 0.0}, {Math.PI, Math.PI, -2.356194490192345, -1.5707963267948966, -1.5707963267948966, -0.7853981633974483, 0.0, 0.0}, {-2.356194490192345, -2.356194490192345, -1.5707963267948966, -1.5707963267948966, -1.5707963267948966, -1.5707963267948966, -0.7853981633974483, -0.7853981633974483}, {-2.356194490192345, -2.356194490192345, -1.5707963267948966, -1.5707963267948966, -1.5707963267948966, -1.5707963267948966, -0.7853981633974483, -0.7853981633974483}};

    public Tables() {
        double y;
        double x;
        int i = 0;
        while (i < 256) {
            this.astSin[i] = Math.round(127.0 * Math.sin((double)i * Math.PI / 128.0));
            this.astCos[i] = Math.round(127.0 * Math.cos((double)i * Math.PI / 128.0));
            ++i;
        }
        i = 0;
        while (i < 256) {
            x = Math.floor(this.astCos[i] / 2.0);
            y = Math.floor(this.astSin[i] / 2.0);
            this.shotBaseDirections[i] = new Point2D.Double(x / 8.0, y / 8.0);
            ++i;
        }
        i = 0;
        while (i < 256) {
            x = 2.0 * Math.floor(this.astCos[i] / 2.0) + Math.floor(Math.floor(this.astCos[i] / 2.0) / 2.0);
            y = 2.0 * Math.floor(this.astSin[i] / 2.0) + Math.floor(Math.floor(this.astSin[i] / 2.0) / 2.0);
            this.shotOffsets[i] = new Point2D.Double(x / 8.0, y / 8.0);
            ++i;
        }
        i = 0;
        while (i < 769) {
            int j = 0;
            while (j < 1025) {
                this.atan2[i][j] = Math.atan2(i - 384, j - 512);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 1025) {
            int j = 0;
            while (j < 769) {
                int x2 = (i - 512) * (i - 512);
                int y2 = (j - 384) * (j - 384);
                this.dist[i][j] = Math.sqrt(x2 + y2);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.sin.length) {
            this.sin[i] = Math.sin((double)i / 64000.0);
            ++i;
        }
    }

    public double getPreparationDirection(int x, int y) {
        int i = 0;
        int j = 0;
        i = x * 8 / 1024;
        j = (896 - y) * 8 / 768;
        return this.preparationDirections[Math.min(7, j)][Math.min(7, i)];
    }

    public Point2D.Double getShotBaseDirection(int index) {
        return this.shotBaseDirections[index];
    }

    public Point2D.Double getShotOffset(int index) {
        return this.shotOffsets[index];
    }

    public double getShotSpeed(int index) {
        return this.dist[(int)(this.shotBaseDirections[index].x * 8.0) + 512][(int)(this.shotBaseDirections[index].y * 8.0) + 384] / 8.0;
    }

    public double getSpeed(double directionX, double directionY) {
        return this.dist[(int)(directionX * 8.0) + 512][(int)(directionY * 8.0) + 384] / 8.0;
    }

    public double getAngle(int index) {
        return this.atan2[(int)(this.shotBaseDirections[index].y * 8.0) + 384][(int)(this.shotBaseDirections[index].x * 8.0) + 512];
    }

    public double getAngle(double directionX, double directionY) {
        return this.atan2[(int)(directionY * 8.0) + 384][(int)(directionX * 8.0) + 512];
    }

    public Point getDirection(int index) {
        return this.directions[index];
    }

    public double dist(int x, int y) {
        return this.dist[x + 512][y + 384];
    }

    public double atan2(int y, int x) {
        return this.atan2[y + 384][x + 512];
    }

    public double sin(double a) {
        return this.sin[(int)Math.round(a * 64000.0)];
    }

    public double astSin(int index) {
        return this.astSin[index];
    }

    public double astCos(int index) {
        return this.astCos[index];
    }
}

