/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ControlPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton serverButton;
    private JButton startButton;
    private JCheckBox autoStartBox;
    private JCheckBox autoStopBox;

    public ControlPanel(ActionListener listener) {
        this.setBorder(new TitledBorder(new EtchedBorder(), "Control"));
        this.setLayout(new BoxLayout(this, 3));
        this.serverButton = this.createControlButton("Select Server", listener);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.startButton = this.createControlButton("Activate Bot", listener);
        this.autoStartBox = this.createCheckBox("Activate and start automaticly", true, listener);
        this.autoStopBox = this.createCheckBox("Automatic deactivation after 5 min", true, listener);
    }

    public boolean isServerButtonClicked(ActionEvent e) {
        return e.getSource() == this.serverButton;
    }

    public boolean isStartButtonClicked(ActionEvent e) {
        return e.getSource() == this.startButton;
    }

    public boolean isAutoStartBoxToggled(ActionEvent e) {
        return e.getSource() == this.autoStartBox;
    }

    public boolean isAutoStopBoxToggled(ActionEvent e) {
        return e.getSource() == this.autoStopBox;
    }

    public void updateButtons(boolean started) {
        if (started) {
            this.startButton.setText("Deactivate Bot");
        } else {
            this.startButton.setText("Activate Bot");
        }
    }

    public void updateAutoStart(boolean autoStart) {
        this.autoStartBox.setSelected(autoStart);
    }

    public void updateAutoStop(boolean autoStop) {
        this.autoStopBox.setSelected(autoStop);
    }

    public JCheckBox createCheckBox(String text, boolean checked, ActionListener listener) {
        JCheckBox result = new JCheckBox(text, checked);
        result.addActionListener(listener);
        result.setAlignmentX(0.0f);
        this.add(result);
        return result;
    }

    public JButton createControlButton(String text, ActionListener listener) {
        JButton result = new JButton(text);
        result.addActionListener(listener);
        result.setAlignmentX(0.0f);
        result.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.add(result);
        return result;
    }
}

