// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import de.caff.util.Sequence;

import java.util.LinkedList;

/**
 *  A sequence of frame preparers.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>.
 */
public class FramePreparerSequence
  extends Sequence<FramePreparer>
  implements FramePreparer
{
  /**
   *  Default constructor.
   */
  public FramePreparerSequence()
  {
  }

  /**
   *  Constructor.
   *  @param preparers preparers to add in the given sequence
   */
  public FramePreparerSequence(FramePreparer ... preparers)
  {
    super(preparers);
  }

  /**
   * Prepare the frame(s).
   *
   * @param frameInfos the collected frame infos
   */
  public void prepareFrames(LinkedList<FrameInfo> frameInfos)
  {
    for (FramePreparer prep: sequence) {
      prep.prepareFrames(frameInfos);
    }
  }
}
