/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.GameData;

public class Buttons
implements GameData {
    private byte keys;

    public Buttons() {
        this(0);
    }

    public Buttons(int keyMask) {
        this.keys = (byte)keyMask;
    }

    public synchronized void setKey(int key, boolean on) {
        this.keys = on ? (byte)(this.keys | key) : (byte)(this.keys & ~key);
    }

    public synchronized void clearKeys() {
        this.keys = 0;
    }

    public synchronized byte extractKeys() {
        byte ret = this.keys;
        this.keys = 0;
        return ret;
    }

    public synchronized byte getKeys() {
        return this.keys;
    }

    public synchronized boolean isAnyPressed(int keyMask) {
        return (this.keys & keyMask) != 0;
    }

    public synchronized boolean isPressed(int keyMask) {
        int combined = this.keys & keyMask;
        return combined == this.keys && combined == keyMask;
    }

    public synchronized boolean isFirePressed() {
        return this.isAnyPressed(2);
    }

    public synchronized boolean isHyperspacePressed() {
        return this.isAnyPressed(1);
    }

    public synchronized boolean isThrustPressed() {
        return this.isAnyPressed(4);
    }

    public synchronized boolean isLeftPressed() {
        return this.isAnyPressed(16);
    }

    public synchronized boolean isRightPressed() {
        return this.isAnyPressed(8);
    }

    public synchronized boolean isStartPressed() {
        return this.isAnyPressed(32);
    }

    public String toString() {
        if (this.keys == 0) {
            return "<>";
        }
        StringBuilder builder = new StringBuilder();
        if ((this.keys & 2) != 0) {
            builder.append("<FIRE>");
        }
        if ((this.keys & 1) != 0) {
            builder.append("<HYPER>");
        }
        if ((this.keys & 0x10) != 0) {
            builder.append("<LEFT>");
        }
        if ((this.keys & 8) != 0) {
            builder.append("<RIGHT>");
        }
        if ((this.keys & 4) != 0) {
            builder.append("<THRUST>");
        }
        if ((this.keys & 0x20) != 0) {
            builder.append("<START>");
        }
        return builder.toString();
    }
}

