// player.cpp: Bot fr Asteroids
// Arne Binder (Harald Bgeholz / c't)

#include <winsock2.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string>
#include <math.h>
#include <iostream>
#include <fstream>

#include "player.h"

// Logfile
static FILE *logfile;

static int t = 0;

int sqr(int arg) { return arg*arg; }
double sqr(double arg) { return arg*arg; }
int norm(int arg, int intvl) { while (arg>=intvl/2) arg-=intvl; while (arg<-intvl/2) arg+=intvl; return arg; }
double norm(double arg, double intvl) { while (arg>=intvl/2) arg-=intvl; while (arg<-intvl/2) arg+=intvl; return arg; }

void ClearConsole()
{
  //Get the handle to the current output buffer...
  HANDLE hStdOut = GetStdHandle(STD_OUTPUT_HANDLE);
  //This is used to reset the carat/cursor to the top left.
  COORD coord = {0, 0};
  DWORD count;
  //This is a structure containing all of the console info
  // it is used here to find the size of the console.
  CONSOLE_SCREEN_BUFFER_INFO csbi;
  //Here we will set the current color
  if(GetConsoleScreenBufferInfo(hStdOut, &csbi))
  {
    //This fills the buffer with a given character (in this case 32=space).
    FillConsoleOutputCharacter(hStdOut, (TCHAR) 32, csbi.dwSize.X * csbi.dwSize.Y, coord, &count);
    SetConsoleCursorPosition(hStdOut, coord);
  }
}

void Player::PrintStatus()
{
  ClearConsole();
  printf("Status: Points %d, Lives %d, Gametime %.1lf%%, avg. latency %d.\n",
    game->score+100000*game->score_of, game->lives, (double)(100*game->frame_count)/(double)(GAMETIME*FRAMERATE), game->avg_latency);
  if (game->score_fin>0)
    printf("Final Score: %d Points.\n\n", game->score_fin);
  else
    printf("Missing to 100k: %d Points.\n\n", 100000*game->frame_count/(GAMETIME*FRAMERATE)-(game->score+100000*game->score_of));

  int sx=0, sy=0;
  for (int i=0; i<OBJ_MEANSPEED; ++i)
  {
    sx += obj->ship.sxm[i];
    sy += obj->ship.sym[i];
  }
  double spd = sqrt(sx * sx + sy * sy) / OBJ_MEANSPEED;
  printf("Tactical: Pts %d, Objects %d, Ship: age=%d, v=%lf, ang=%lf [%s].\n",
    max_pts, obj->ndests, obj->ship.age, spd, SHOTDIR[game->ShotAngle], obj->ship.hit?"!":" ");
  
  std::string bar;
  for (int i=0; i<obj->nshots; ++i)
  {
    int sx=0, sy=0;
    for (int j=0; j<OBJ_MEANSPEED; ++j)
    {
      sx += obj->shots[i].sxm[j];
      sy += obj->shots[i].sym[j];
    }  
    double spd = sqrt(sx * sx + sy * sy) / OBJ_MEANSPEED;
    double phi = (sy>0?acos(sx/sqrt(sx * sx + sy * sy)):(2*M_PI-acos(sx/sqrt(sx * sx + sy * sy))));
    bar = "";
    for (int j=0; j<spd; ++j) bar += "#";
    printf("Shot %d: v=%s (%lf), age=%d, ang=%lf (%lf).\n",
      i, bar.c_str(), spd, obj->shots[i].age, phi, 180./M_PI*phi);
  }
  for (int i=0; i<7-obj->nshots; ++i)
    printf("\n");
  for (int i=0; i<targets->ntargets; ++i)
  {
    char timef[] = "INF";
    if (targets->targets[i].time<MAX_INT)
      sprintf(timef, "%3d", targets->targets[i].time); 
		int size = 0;
    switch (game->asteroids[i].sf)
		{
			case 0:  // groer Asteroid
			  size = 3;
				break;
			case 15: // mittlerer Asteroid
				size = 2;
				break;
			case 14: // kleiner Asteroid
				size = 1;
				break;
		}
    printf("Target: %4d, %4d, angle=%lf, omega=%9lf, time=%s [%d%d%s%s]\n",
      targets->targets[i].x, targets->targets[i].y, targets->targets[i].angle,
      targets->targets[i].link->omega, timef, size, targets->targets[i].link->nshots,
      targets->targets[i].link->hit?"x":" ", (i == seltarget)?"*":" ");
  }

  printf("\nShot: [");
  for (unsigned char i=0; i<SHP_HSTSIZE; ++i)
  {
    printf("%3d,", game->HstShotAngle[(game->HstPtr+i)%SHP_HSTSIZE]);
  }
  printf("] - akt. %d\n", game->ShotAngle);
  printf("Theo: [");
  for (unsigned char i=0; i<SHP_HSTSIZE; ++i)
  {
    printf("%3d,", SHIPDIR[game->HstShotAngle[(game->HstPtr+i)%SHP_HSTSIZE]]);
  }
  printf("]\n");
  printf("Ship: [");
  for (unsigned char i=0; i<SHP_HSTSIZE; ++i)
  {
    printf("%3d,", game->HstShipAngle[(game->HstPtr+i+1)%SHP_HSTSIZE]);
  }
  printf("]\n");
}

void Player::Run()
{
	FramePacket frame;
	game = new GameStatus();
	obj = new GameObjects();
	targets = new GameTargets();
	char prevframe = 0;   // Nummer letzter Frame

  bool fire = 0;        // Feuer gedrckt
  double progress;      // Spielfortschritt

  // logfile ffnen
  logfile = fopen("astbot.log", "w");
	if (logfile == NULL)
	{
		fprintf(stderr, "Kann astbot.log nicht ffnen.\n");
		exit(2);
	}

	for (;;)
	{
		++t;
		ReceivePacket(frame);
		#if defined(SENDNAME)
		if (t==1)
		{
      name.setname(MYNAME);
      SendPacket(&name, sizeof(name));
    }
    #endif

    // Frame dump (Disassembler)
    // file_op.write(frame.vectorram, 1024);  

    // Latenz, Frameausflle & Zeit
    int dt = (unsigned char)(frame.frameno - prevframe);
		if (frame.frameno != ++prevframe)
		{
			if (t>1) game->frame_lost += (unsigned char)(frame.frameno - prevframe);
			prevframe = frame.frameno;
		}
		if (game->latency = (unsigned char)(keys.ping - frame.ping))
		{
      fprintf(logfile, "Latency: %d\n", game->latency);
    }

		game->InterpretScreen(frame);
		game->CalcLatency();
		GameObjects *newobj = new GameObjects(*game, *obj, dt);
		delete obj;
    obj = newobj;
    obj->DetectHit();

    // Spielzeit Counter
    game->frame_count += dt;
    progress = (double)(100*game->frame_count)/(double)(GAMETIME*FRAMERATE);
    if (progress>=100 && game->score_fin==0)
      game->score_fin = game->score+100000*game->score_of;
    // Neues Spiel
    if (game->lives == 0)
      game->new_game();
    // Score berlauf Analyse (Frameausfall & Startverzgerung 1s)
    if (game->score > 0 && game->frame_count>FRAMERATE)
    {
      if (game->score < game->score_old) game->score_of++;
      game->score_old = game->score;
    }

    // Taktische Steuerung
		keys.clear();       // alle Tasten loslassen
    int critical = 0;   // kritische Annherung

		if (game->ship_present)
		{
  		// Drehwinkel synchronisieren
      game->SyncShipAngle();
  
  		// Ziele neu generieren
      targets = new GameTargets(*obj, game->avg_latency);

			for (int i=0; i<game->nasteroids; ++i)
			{
				int dx = norm(game->asteroids[i].x - game->ship_x, MAX_X);
				int dy = norm(game->asteroids[i].y - game->ship_y, MAX_Y);
				int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
				switch (game->asteroids[i].sf)
				{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
					case 0:  // groer Asteroid
						dist -= 40*40;
						break;
					case 15: // mittlerer Asteroid
						dist -= 20*20;
						break;
					case 14: // kleiner Asteroid
						dist -= 8*8;
						break;
				}
				if (dist < KI_SECDIST) critical = 1;
			}
			if (game->saucer_present)
			{
        int dx = norm(game->saucer_x - game->ship_x, MAX_X);
				int dy = norm(game->saucer_y - game->ship_y, MAX_Y);
				int dist = dx*dx+dy*dy;
				switch (game->saucer_size)
				{	// Abstand um den ungefhren Radius des UFOs korrigieren
				case 15: // groes UFO
					dist -= 20*20;
					break;
				case 14: // kleines UFO
					dist -= 10*10;
					break;
				}
				if (dist < KI_SECDIST) critical = 1;
			}
  		for (int i=0; i<obj->nshots; ++i)
			{
        if (obj->shots[i].age > 1)
        {
          int dx = norm(game->ship_x - (obj->shots[i].x + obj->shots[i].sx * (game->latency + TIMEADVANCE)), MAX_X);
  				int dy = norm(game->ship_y - (obj->shots[i].y + obj->shots[i].sy * (game->latency + TIMEADVANCE)), MAX_Y);
  				int dist = dx*dx+dy*dy;
  				if (dist < KI_SECDIST) critical = 1;
        }
      }
      
      // geeignetes Ziel suchen
      max_pts = -1;
   		seltarget = -1;
   		for (int i=0; i<targets->ntargets; ++i)
			{
        int pts = targets->targets[i].getpts(SHOTDIR[game->ShotAngle]);
        if (pts > max_pts)
        {
				  max_pts = pts;
	        seltarget = i;
        }
      }

      // Flucht bei bevorstehender Kollision unausweichlich
      if (critical)
				keys.hyperspace(true);
      // Aktion nur, falls Ziel ausgewhlt
      else if (seltarget > -1)
      {
  			// Anvisierung
        targets->targets[seltarget].link->aim = 1;
  			
        // Winkelabweichung berechnen
        double trad = targets->targets[seltarget].link->radius[1];
        double a_tgt = norm(targets->targets[seltarget].angle - SHOTDIR[game->ShotAngle], 2*M_PI);

        if (fire == 0)
        {
	  		  // Feuer, wenn Ausrichtung innerhalb Fenster + Schsse mglich
    			double win = atan2(trad, targets->targets[seltarget].adist);
    		  if (fabs(a_tgt) <= win && (game->nshots < 4 || game->saucer_present))
	   		  {
            fire = 1;
            keys.fire(true);
            targets->targets[seltarget].link->nshots++;
          }
          targets->targets[seltarget].link->shot = targets->targets[seltarget].link->age;
        }
        else
        {
          fire = 0;
        }
        
        // Schiff in Richtung auf das ausgewhlte Objekt drehen
        double a_lft = norm(targets->targets[seltarget].angle - SHOTDIR[(unsigned char)(game->ShotAngle+3)], 2*M_PI);
        double a_rgt = norm(targets->targets[seltarget].angle - SHOTDIR[(unsigned char)(game->ShotAngle-3)], 2*M_PI);
        if (fabs(a_lft) < fabs(a_tgt))
  			{
	 		  	keys.left(true);
	 		  	game->ShotAngle += 3;
        }
  			else if (fabs(a_rgt) < fabs(a_tgt))
  			{
		  		keys.right(true);
	 		  	game->ShotAngle -= 3;
        }
        
        // Beschleunigung
        int shipspeed = obj->ship.sx*obj->ship.sx + obj->ship.sy*obj->ship.sy;
			  if (shipspeed < (game->saucer_present?KI_SPEED_SAUC:KI_SPEED_NORM))
			 	  keys.thrust(true);
      }
		}
		else
		{
      targets = new GameTargets();
    }

    ++keys.ping; // Latenzmessung
		SendPacket(&keys, sizeof(keys));
    
    // Status Anzeige
    #if !defined(SILENT)
    PrintStatus();
    #endif

    delete targets;
    fflush (logfile);
	}
}

void Asteroid::set(int x, int y, int type, int sf)
{
	this->x = x;
	this->y = y;
	this->type = type;
	this->sf = sf;
}

void Shot::set(int x, int y)
{
	this->x = x;
	this->y = y;
}

void Target::set(int x, int y, double angle, int adist, int dist, int time, GObject *link)
{
	this->x = x;
	this->y = y;
	this->angle = angle;
	this->adist = adist;
	this->dist = dist;
	this->time = time;
	this->link = link;
}

int Target::getpts(double ship_angle)
{
  // Getroffene: 0 Punkte
  if (link->hit)
    return 0;
  
  // kleines UFO: 20.000 Punkte
  else if (link->type == 0 && link->nshots == 0 && link->sf == 14)
    return 20000;
  
  // Alle anderen nach Gewichtung
  else
  {
		int shots, ptime;
    switch (link->sf)
		{
			case 0:  // groer Asteroid
				shots = KI_FIRE_LARGE;
				ptime = KI_PROXIMITY_LA;
				break;
			case 15: // mittlerer Asteroid
				shots = KI_FIRE_MEDIUM;
				ptime = KI_PROXIMITY_ME;
				break;
			case 14: // kleiner Asteroid
				shots = KI_FIRE_SMALL;
				ptime = KI_PROXIMITY_SM;
				break;
		}

    // Beschossene: 0 Punkte
    if (link->nshots >= shots)
      return 0;

    // Kollisionskurs: 30.000 - 40.000 Punkte
    if (dist <= KI_SECDIST_CA && time<MAX_INT && time<ptime)
    {
      // Anvisierte haben Prioritt
      if (link->aim) return 40000;
      return 40000 - time;
    }

    // Zu langsame Winkelgeschwindigkeit: 0 Punkte (nur kleine A.)
    if (link->sf==14 && fabs(link->omega)<KI_OMEGA_MIN) return 0;

    // normal: 0 - 10000 Punkte
    double diffangle = norm(angle-ship_angle, 2*M_PI)/M_PI*64*8;
    if (diffangle*link->omega>0)
      diffangle *= KI_OMEGA_WEIGHT;
    return 5000 - adist - abs((int)round(diffangle));
  }
}

void GObject::set(int x, int y, int type, const int *r, int sf, int sx, int sy, GObject *parent)
{
	this->x = x;
	this->y = y;
	this->sx = sx;
	this->sy = sy;
	this->type = type;
	if (r != NULL)
  	memcpy(this->radius, r, sizeof(this->radius));
	this->sf = sf;
  hit = 0;
  omega = 0;
	if (parent != NULL)
	{
    age = parent->age+1;
    aim = parent->aim;
    shot = parent->shot;
    nshots = parent->nshots;
    memcpy(sxm, parent->sxm, sizeof sxm);
    memcpy(sym, parent->sym, sizeof sym);
  }
  else
  {
    age = 0;
    aim = 0;
    shot = -1;
    nshots = 0;
    memset(sxm, 0, sizeof sxm);
    memset(sym, 0, sizeof sym);
  }
  sxm[age % OBJ_MEANSPEED] = sx;
  sym[age % OBJ_MEANSPEED] = sy;
}

GameStatus::GameStatus()
{
  // Lookup-Tabelle Blickrichtungen Schiff initialisieren
	for (int i=0; i<17; ++i)
    LOOKUP_SD[SHIPVLEN[i]] = i;

  // Mittelwertspeicher Latenz initialisieren
	for (int i=0; i<MEANLATENCY; ++i)
    HstLatency[i] = 0;

  new_game();
}

void GameStatus::InterpretScreen(FramePacket &packet)
{
	unsigned short *vector_ram = (unsigned short *)packet.vectorram;
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
  int shipdetect = 0;
  bool scorepos = 0;

	clear();
	if ((unsigned char)packet.vectorram[1] != 0xe0 &&
    (unsigned char)packet.vectorram[1] != 0xe2)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
	for (;;)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0x0: // VCTR
		case 0x1:
		case 0x2:
		case 0x3:
		case 0x4:
		case 0x5:
		case 0x6:
		case 0x7:
		case 0x8:
		case 0x9:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
				shots[nshots++].set(vx, vy);
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					ship_present = true;
					ship_x = vx;
					ship_y = vy;
					int ship_dx = (v1x - dx)/8;
          int ndx = ((ship_dx>0)?1:-1)*LOOKUP_SD[abs(ship_dx)];
					int ship_dy = (v1y - dy)/8;
          int ndy = ((ship_dy>0)?1:-1)*LOOKUP_SD[abs(ship_dy)];
          // Winkel berechnen
          if (ndx>=1 && ndy>=0) HstShipAngle[HstPtr] = ndy;
          if (ndy>=1 && ndx<=0) HstShipAngle[HstPtr] = -ndx + 16;
          if (ndx<=-1 && ndy<=0) HstShipAngle[HstPtr] = -ndy + 32;
          if (ndy<=-1 && ndx>=0) HstShipAngle[HstPtr] = ndx + 48;
					// Schiff- & Schusswinkel eintragen
          HstShotAngle[HstPtr] = ShotAngle;
          HstPtr = ++HstPtr % SHP_HSTSIZE;
          ++shipdetect;
					break;
				}
			}
			pc += 2;
			break;
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
			// Position Score
      if (vx == 100 && vy == 876) scorepos = 1;
      else scorepos = 0;
			pc += 2;
      break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				asteroids[nasteroids++].set(vx, vy, 1, vs);
				break;
			case 0x8ff:
				asteroids[nasteroids++].set(vx, vy, 2, vs);
				break;
			case 0x90d:
				asteroids[nasteroids++].set(vx, vy, 3, vs);
				break;
			case 0x91a:
				asteroids[nasteroids++].set(vx, vy, 4, vs);
				break;
			case 0x929:
				saucer_present = true;
				saucer_x = vx;
				saucer_y = vy;
				saucer_size = vs;
				break;
			case 0xa6d:
        lives++;
        break;
			case 0xadd:
        if (scorepos) score = score*10;
        break;
			case 0xb2e:
        if (scorepos) score = score*10 + 1;
        break;
			case 0xb32:
        if (scorepos) score = score*10 + 2;
        break;
			case 0xb3a:
        if (scorepos) score = score*10 + 3;
        break;
			case 0xb41:
        if (scorepos) score = score*10 + 4;
        break;
			case 0xb48:
        if (scorepos) score = score*10 + 5;
        break;
			case 0xb4f:
        if (scorepos) score = score*10 + 6;
        break;
			case 0xb56:
        if (scorepos) score = score*10 + 7;
        break;
			case 0xb5b:
        if (scorepos) score = score*10 + 8;
        break;
			case 0xb63:
        if (scorepos) score = score*10 + 9;
        break;
			}
			pc += 1;
			break;
		case 0xd: // RTSL
			pc += 1;
			break;
		case 0xe: // JMPL
			pc += 1;
			break;
		case 0xf: // SVEC
			pc += 1;
			break;
		}
	}
}

void GameStatus::clear(void)
{
	ship_present = false;
	saucer_present = false;
	nasteroids = 0;
  nshots = 0;
	lives = 0;
	score = 0;
}

void GameStatus::new_game(void)
{
  frame_count = 0;
  score_of = 0;
  score_old = 0;
  score_fin = 0;

	for (int i=0; i<SHP_HSTSIZE; ++i)
	{
    HstShipAngle[i] = 0;
    HstShotAngle[i] = 0;
  }
  HstPtr = 0;
  ShotAngle = 0;
}

void GameStatus::mvHst(int n)
{
  // Verschiebung Drehwinkel (mod. 256)
  for (int i=0; i<SHP_HSTSIZE; ++i)
  {
    HstShotAngle[i] = (HstShotAngle[i] + n) % 256;
  }
  ShotAngle = (ShotAngle + n) % 256;
}

void GameStatus::CalcLatency()
{
  HstLatency[frame_count%MEANLATENCY] = latency;
  double sl = 0;
  for (int i=0; i<MEANLATENCY; ++i)
  {
    sl += HstLatency[i];
  }
  avg_latency = (int)round(sl/MEANLATENCY);
}

void GameStatus::SyncShipAngle()
{
  if (latency<SHP_HSTSIZE-2)
  {
    // Stufe 1 (Plausibilittstest)
    if(HstShipAngle[(HstPtr+SHP_HSTSIZE-1)%SHP_HSTSIZE] ==
      SHIPDIR[HstShotAngle[(HstPtr+SHP_HSTSIZE-2-latency)%SHP_HSTSIZE]])
      return;
    // Stufe 2 (Einfache Korrektur)
    for (int i=1; i<=SHP_MAXCORR; ++i)
    {
      if(HstShipAngle[(HstPtr+SHP_HSTSIZE-1)%SHP_HSTSIZE] ==
        SHIPDIR[(unsigned char)(HstShotAngle[(HstPtr+SHP_HSTSIZE-2-latency)%SHP_HSTSIZE]+3*i)])
      {
        mvHst(3*i);
        fprintf(logfile, "%6d: Angle correction simple (+%u)\n", t, i);
        return;
      }
      if(HstShipAngle[(HstPtr+SHP_HSTSIZE-1)%SHP_HSTSIZE] ==
        SHIPDIR[(unsigned char)(HstShotAngle[(HstPtr+SHP_HSTSIZE-2-latency)%SHP_HSTSIZE]-3*i)])
      {
        mvHst(-3*i);
        fprintf(logfile, "%6d: Angle correction simple (-%u)\n", t, i);
        return;
      }
    }
  }
  // Stufe 3 (Vollst. Korrektur)
  mvHst(4*HstShipAngle[(HstPtr+SHP_HSTSIZE-1)]-ShotAngle);
  fprintf(logfile, "%6d: Angle correction complete (%u)\n", t, ShotAngle);
}

GameObjects::GameObjects(GameStatus& game, GameObjects& obj, int dt)
{
	const int *radius;
  clear();

  // Schiff
  if (game.ship_present) ship.set(game.ship_x, game.ship_y, 0, 0, 0,
    game.ship_x - obj.ship.x, game.ship_y - obj.ship.y, &obj.ship);
  else
    ship.set(0, 0, 0, 0, 0);

	// Ufo
  if (game.saucer_present)
	{
    // Radius des UFOs
    switch (game.saucer_size)
		{
		case 15: // groes UFO
		  radius = SZ_SMEDIUM;
		  break;
		case 14: // kleines UFO
			radius = SZ_SSMALL;
			break;
		}
    if(obj.dests[0].type == 0)
    {
      dests[ndests++].set(game.saucer_x, game.saucer_y, 0, radius, game.saucer_size,
        game.saucer_x - obj.dests[0].x, game.saucer_y - obj.dests[0].y, &obj.dests[0]);
    }
    else
    {
      dests[ndests++].set(game.saucer_x, game.saucer_y, 0, radius, game.saucer_size);
    }
  }

  // Asteroiden
  for (int i=0; i<game.nasteroids; ++i)
  {
    int bestobj = -1;
    int bestdist = OBJ_CATCH_AS;   // Fang Asteroiden
    int sx, sy;                    // Geschwindigkeit
    // Suche nahestes Objekt mit gleichen Eigenschaften
    for (int j=game.saucer_present?1:0; j<obj.ndests; ++j)
		{
			if (game.asteroids[i].type == obj.dests[j].type && game.asteroids[i].sf == obj.dests[j].sf)
			{
        int dx = norm(game.asteroids[i].x - (obj.dests[j].x + obj.dests[j].sx * dt), MAX_X);
  			int dy = norm(game.asteroids[i].y - (obj.dests[j].y + obj.dests[j].sy * dt), MAX_Y);
  			int dist = dx*dx+dy*dy;
  			if (dist < bestdist)
  			{
          bestdist = dist;
          bestobj = j;
          sx = norm(game.asteroids[i].x - obj.dests[j].x, MAX_X);
          sy = norm(game.asteroids[i].y - obj.dests[j].y, MAX_Y);
        }
      }
    }
		// Radius des Asteroiden
    switch (game.asteroids[i].sf)
		{
		case 0:  // groer Asteroid
			radius = SZ_ALARGE;
			break;
		case 15: // mittlerer Asteroid
			radius = SZ_AMEDIUM;
			break;
		case 14: // kleiner Asteroid
			radius = SZ_ASMALL;
			break;
		}
    // Neu oder alt?
    if (bestobj>-1)
    {
      dests[ndests++].set(game.asteroids[i].x, game.asteroids[i].y,
        game.asteroids[i].type, radius, game.asteroids[i].sf, sx, sy, &obj.dests[bestobj]);
    }
    else
    {
      dests[ndests++].set(game.asteroids[i].x, game.asteroids[i].y,
        game.asteroids[i].type, radius, game.asteroids[i].sf);
    }
  }

  // Schsse
  for (int i=0; i<game.nshots; ++i)
  {
    int bestobj = -1;
    int bestdist = OBJ_CATCH_SH;   // Fang Schsse
    int sx, sy;                    // Geschwindigkeit
    // Suche nahesten Schuss
    for (int j=0; j<obj.nshots; ++j)
		{
      int dx = norm(game.shots[i].x - (obj.shots[j].x + obj.shots[j].sx * dt), MAX_X);
			int dy = norm(game.shots[i].y - (obj.shots[j].y + obj.shots[j].sy * dt), MAX_Y);
			int dist = dx*dx+dy*dy;
			if (dist < bestdist)
			{
        bestdist = dist;
        bestobj = j;
        sx = norm(game.shots[i].x - obj.shots[j].x, MAX_Y);
        sy = norm(game.shots[i].y - obj.shots[j].y, MAX_Y);
      }
    }
    // Neu oder alt?
    if (bestobj>-1)
    {
      shots[nshots++].set(game.shots[i].x, game.shots[i].y, 0, 0, 0,
        sx, sy, &obj.shots[bestobj]);
    }
    else
    {
      shots[nshots++].set(game.shots[i].x, game.shots[i].y, 0, 0, 0);
    }
  }
}

void GameObjects::DetectHit()
{
  struct ShotEvent
  {
    int time;
    int shot;
    int object;
  };
  int nShotEvents = 0;
  ShotEvent *ShotEvents[MAX_SHOTEVENTS];
  bool obj_av[MAX_OBJECTS];
  bool shot_av[MAX_SHOTS];

  memset(shot_av, 1, nshots);
  memset(obj_av, 1, ndests);
  
  // Trefferliste berechnen
  for (int i=0; i<nshots; ++i)
  {
    if (shots[i].age >= OBJ_MEANSPEED)
    {
      // Mittlere Schussgeschwindigkeit
      double sx=0, sy=0;
      for (int j=0; j<OBJ_MEANSPEED; ++j)
      {
        sx += shots[i].sxm[j];
        sy += shots[i].sym[j];
      }
      sx /= OBJ_MEANSPEED;
      sy /= OBJ_MEANSPEED;
      
      // Schiff (vom UFO)
      double vsx=0, vsy=0;
      for (int k=0; k<OBJ_MEANSPEED; ++k)
      {
        vsx += ship.sxm[k];
        vsy += ship.sym[k];
      }
      vsx /= OBJ_MEANSPEED;
      vsy /= OBJ_MEANSPEED;
      // Transformation in schussfeste Koordinaten
      double kx = norm(ship.x - shots[i].x, MAX_X);
      double ky = norm(ship.y - shots[i].y, MAX_Y);
      // Transformation auf ruhenden Schuss
      double vrx = vsx - sx;
      double vry = vsy - sy;
      // Kollision Schuss
      double divisor = vrx*vrx + vry*vry;
      double a = (-ky*vry-kx*vrx) / divisor;
      double b = (ky*vrx-kx*vry) / divisor;
      // Abstand berechnen + korrigieren
      int dist = (int)round(b*b*(vrx*vrx+vry*vry) - KI_SECDIST_CA);
      // Eintragen, falls Bedingungen O.K.
      if (a>0 && a+shots[i].age<SHOTTTL && dist<0 && nShotEvents<MAX_SHOTEVENTS)
      {
        int time = (int)round(a);
        ShotEvents[nShotEvents] = new ShotEvent;
        ShotEvents[nShotEvents]->object = -1;
        ShotEvents[nShotEvents]->shot = i;
        ShotEvents[nShotEvents++]->time = time;
      }
      for (int j=0; j<ndests; ++j)
      {
        if (dests[j].age >= OBJ_MEANSPEED)
        {
          // Mittlere Objektgeschwindigkeit
          double vox=0, voy=0;
          for (int k=0; k<OBJ_MEANSPEED; ++k)
          {
            vox += dests[j].sxm[k];
            voy += dests[j].sym[k];
          }
          vox /= OBJ_MEANSPEED;
          voy /= OBJ_MEANSPEED;
          // Transformation in schussfeste Koordinaten
          double kx = norm(dests[j].x - shots[i].x, MAX_X);
          double ky = norm(dests[j].y - shots[i].y, MAX_Y);
          // Transformation auf ruhenden Schuss
          double vrx = vox - sx;
          double vry = voy - sy;
          // Kollision Schuss
          double divisor = vrx*vrx + vry*vry;
          double a = (-ky*vry-kx*vrx) / divisor;
          double b = (ky*vrx-kx*vry) / divisor;
          // Abstand berechnen + korrigieren
          int dist = (int)round(b*b*(vrx*vrx+vry*vry) - sqr(dests[j].radius[0]));
          // Eintragen, falls Bedingungen O.K.
          if (a>0 && a+shots[i].age<SHOTTTL && dist<0 && nShotEvents<MAX_SHOTEVENTS)
          {
            int time = (int)round(a);
            ShotEvents[nShotEvents] = new ShotEvent;
            ShotEvents[nShotEvents]->object = j;
            ShotEvents[nShotEvents]->shot = i;
            ShotEvents[nShotEvents++]->time = time;
          }
        }
      }
    }
  }

  // Trefferliste nach time aufsteigend sortieren
  int n = nShotEvents;
  bool swapped;
  do
  {
    swapped = 0;
    for (int i=0; i<n-1; ++i)
    {
      if (ShotEvents[i]->time>ShotEvents[i+1]->time)
      {
        ShotEvent *temp = ShotEvents[i];
        ShotEvents[i] = ShotEvents[i+1];
        ShotEvents[i+1] = temp;
        swapped = 1;
      }
    }
    n--;
  } while (swapped && n >= 0);

  // Treffer markieren & Liste frei geben
  for (int i=0; i<nShotEvents; ++i)
  {
    if (ShotEvents[i]->object == -1)
      ship.hit = 1;
    else if (obj_av[ShotEvents[i]->object] && shot_av[ShotEvents[i]->shot])
    {
      dests[ShotEvents[i]->object].hit = 1;
      obj_av[ShotEvents[i]->object] = 0;
      shot_av[ShotEvents[i]->shot] = 0;
    }
    delete ShotEvents[i];
  }
  
  // brige Objekte bearbeiten
  for (int i=0; i<ndests; ++i)
  {
    if (!dests[i].hit && dests[i].age >= OBJ_MEANSPEED &&
      dests[i].age > dests[i].shot + OBJ_MEANSPEED + 2)
    {
      dests[i].shot = -1;
      dests[i].nshots = 0;
    }
  }
}

void GameObjects::clear(void)
{
  ndests = 0;
  nshots = 0;
}

GameTargets::GameTargets(GameObjects& obj, int latency)
{
  clear();
  // Mittlere Schiffgeschwindigkeit
  int m = (obj.ship.age<OBJ_MEANSPEED)?obj.ship.age:OBJ_MEANSPEED;
  double sx=0, sy=0;
  for (int i=0; i<m; ++i)
  {
    sx += obj.ship.sxm[i];
    sy += obj.ship.sym[i];
  }
  sx /= m;
  sy /= m;
  
  for (int i=0; i<obj.ndests; ++i)
  {
    // Alter mindestens 2 (Geschwindigkeit)
    if (obj.dests[i].age>1)
    {
      // Mittlere Objektgeschwindigkeit
      int m = (obj.dests[i].age<OBJ_MEANSPEED)?obj.dests[i].age:OBJ_MEANSPEED;
      double vox=0, voy=0;
      for (int j=0; j<m; ++j)
      {
        vox += obj.dests[i].sxm[j];
        voy += obj.dests[i].sym[j];
      }
      vox /= m;
      voy /= m;

      // Transformation auf ruhendes Schiff
      double vrx = vox - sx;
      double vry = voy - sy;
      
      // Winkelgeschwindigkeit berechnen
      double ox = norm(obj.dests[i].x - obj.ship.x, MAX_X);
      double oy = norm(obj.dests[i].y - obj.ship.y, MAX_Y);
      double norm = sqrt(ox*ox+oy*oy)*sqrt((ox+vrx)*(ox+vrx)+(oy+vry)*(oy+vry));
      obj.dests[i].omega = ((ox*(oy+vry)-oy*(ox+vrx))>0?1:-1)*
        acos((ox*(ox+vrx)+oy*(oy+vry))/norm);

      // Minimum aus allen Quadranten berechnen
      double kx_min, ky_min, t_min = -1;
      for (int qx=-1; qx<1; qx++)
        for (int qy=-1; qy<1; qy++)
        {
          // Transformation in schiffsfeste Koordinaten
          double kx = ox + qx*MAX_X;
          double ky = oy + qy*MAX_Y;

          // Kollision Schuss
          double root = sqrt(2*kx*vrx*ky*vry-vrx*vrx*ky*ky-vry*vry*kx*kx+SHOTSPEED*(kx*kx+ky*ky));
          double colltime1 = (kx*vrx+ky*vry+root) / (SHOTSPEED-(vrx*vrx+vry*vry));
          double colltime2 = (kx*vrx+ky*vry-root) / (SHOTSPEED-(vrx*vrx+vry*vry));

          // Zeit bis zum Treffer
          if (colltime1 > 0 && (colltime1 < t_min || t_min < 0))
          {
            t_min = colltime1;
            kx_min = kx;
            ky_min = ky;
          }
          if (colltime2 > 0 && (colltime2 < t_min || t_min < 0))
          {
            t_min = colltime2;
            kx_min = kx;
            ky_min = ky;
          }
        }

      // Beste Position verwenden, max. 70 Frames (TTL)
      if (t_min >= 0 && t_min <= 70)
      {
        // Latenzkorrektur + Startabweichung
        t_min += latency + TIMEADVANCE - .5;
        
        // Zielkoordinaten
        int tx = (int)round(kx_min + t_min * vox);
        int ty = (int)round(ky_min + t_min * voy);

        // Abstand & Kollision mit Schiff
        int adist, dist, time;

        // Abstand berechnen + korrigieren
        adist = (int)round(sqrt(tx*tx + ty*ty - sqr(obj.dests[i].radius[0])));
        double divisor = vrx*vrx + vry*vry;
        if (divisor > 0)
        {
          double a = (-ky_min*vry-kx_min*vrx) / divisor;
          double b = (ky_min*vrx-kx_min*vry) / divisor;
          dist = (int)round(b*b*(vrx*vrx+vry*vry) - sqr(obj.dests[i].radius[0]));
          if (a<0) time = MAX_INT;
          else time = (int)round(a);
        }
        else
        {
          dist = MAX_INT;
          time = MAX_INT;
        }

        // Winkel berechnen
        double norm = sqrt(tx*tx+ty*ty);
        double phi = (ty>0?acos(tx/norm):(2*M_PI-acos(tx/norm)));

        // Zielobjekt erstellen
        targets[ntargets++].set(tx, ty, phi, adist, dist, time, &obj.dests[i]);
      }
    }
  }
}

void GameTargets::clear(void)
{
  ntargets = 0;
}

NamePacket::NamePacket(void)
{
	memcpy(&signature[0], &MAGICBNAME[0], sizeof(MAGICBNAME));
	memset(&name[0], 0, sizeof(name));
}

void NamePacket::setname(const wchar_t *name)
{
  WideCharToMultiByte(CP_UTF8, 0, name, -1, this->name, 32, NULL, NULL);
}

KeysPacket::KeysPacket(void)
{
	memcpy(&signature[0], &MAGICBYTES[0], sizeof(MAGICBYTES));
	keys = '@';
	ping = 0;
}

void KeysPacket::clear(void)
{
	keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

void Player::ReceivePacket(FramePacket &packet)
{
	sockaddr_in sender;
	int senderlen = sizeof(struct sockaddr_in);
	int sender_size = sizeof sender;
	bool received = 0;
  fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		timeval tout;
    tout.tv_sec = 0; tout.tv_usec = 100000;
    if (select(sd+1, &readfds, &writefds, &exceptfds, &tout) == 0)
    {
      keys.clear();
      SendPacket(&keys, sizeof(keys));
      continue;
    }
    received = 1;
		int bytes_received = recvfrom(sd, (char *)&packet, sizeof packet, 0,
      (sockaddr*) &sender,&senderlen);
    server_ip = sender.sin_addr.s_addr;
		if (bytes_received != sizeof packet)
		{
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(1);
		}
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		tout.tv_sec = 0; tout.tv_usec = 0;
		select(sd+1, &readfds, &writefds, &exceptfds, &tout);
	} while(!received || FD_ISSET(sd, &readfds));
}

void Player::SendPacket(void *packet, int size)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (size != sendto(sd, (char *)packet, size, 0, (sockaddr*)&server, sizeof server))
	{
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
	}
}
