// This file is part of "Omniroid", an Asteroids bot written for the 2008 c't anniversary contest
// Omniroid was written by Vladimir "CyberShadow" Panteleev <thecybershadow@gmail.com>
// This file is written in the D Programming Language ( http://digitalmars.com/d/ )

/// Simple bot that continuously jumps into hyperspace, making sure to exit safely every time.
module jumperbot;

import asteroids;
import syncbot;
import network;

class JumperBot : SyncBot
{
	this(NetworkClient network)
	{
		super(network);
	}

	override KeysData getInput()
	{
		KeysData empty;
		auto myPool = getFastPool();
		foreach (ref game; myPool)
			if (game.ObjType[OBJECT_SHIP] <= 0)
				return empty;
		KeysData jump;
		jump.hyperspace = true;
		for (int f=0; f<4; f++) // take into account lag / packet loss
		{
			auto myPool2 = myPool.dup;
			for (int i=0; i<120; i++)
			{
				stepUsing(i==0?jump:empty, myPool2);
				foreach (ref game; myPool2)
					if (game.SafeJump == 0x80 || game.Lives != pool[0].Lives) // this choice leads to DEATH!
						return empty;
			}
			stepUsing(empty, myPool);
		}

		return jump;
	}
}

NetworkClient client;

void main(string[] args)
{
	if (client is null)
		client = new UdpNetworkClient(args.length>1?args[1]:"127.0.0.1");
	auto bot = new JumperBot(client);
	bot.run();
}
